/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ServiceInvoker {
    static Logger logger = LogManager.getLogger(ServiceInvoker.class);
    public static final String APPLICATION_VND_KCL_PROV_TEMPLATE_JSON = "application/vnd.kcl.prov-template+json";
    WebClient webclient = WebClient.create();

    public String getAccessTokenValue(String url, String name, String password, String clientid) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"grant_type", (Object)"password");
        values.add((Object)"username", (Object)name);
        values.add((Object)"password", (Object)password);
        values.add((Object)"client_id", (Object)clientid);
        System.out.println("values: " + String.valueOf(values));
        JsonNode resource = (JsonNode)((WebClient.RequestBodySpec)this.webclient.post().uri(url, new Object[0])).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)values)).retrieve().bodyToMono(JsonNode.class).block();
        String token = Objects.requireNonNull(resource).get("access_token").textValue();
        return token;
    }

    public <T> Optional<T> postInstructions(String serviceEndpoint, T data, String accessTokenValue) {
        Duration timeoutIn10Seconds = Duration.ofSeconds(10L);
        return ((WebClient.RequestBodySpec)this.webclient.method(HttpMethod.POST).uri(serviceEndpoint, new Object[0])).body(BodyInserters.fromValue(data)).header("Content-Type", new String[]{APPLICATION_VND_KCL_PROV_TEMPLATE_JSON}).header("Accept", new String[]{APPLICATION_VND_KCL_PROV_TEMPLATE_JSON}).headers(h -> h.setBearerAuth(accessTokenValue)).retrieve().bodyToMono(data.getClass()).blockOptional(timeoutIn10Seconds);
    }

    public <Tin, Tout> Optional<Tout> postInstructionsInOut(String serviceEndpoint, Tin data, ParameterizedTypeReference<Tout> clazz, String accessTokenValue) {
        Duration timeoutIn10Seconds = Duration.ofSeconds(10L);
        return ((WebClient.RequestBodySpec)this.webclient.method(HttpMethod.POST).uri(serviceEndpoint, new Object[0])).body(BodyInserters.fromValue(data)).header("Content-Type", new String[]{APPLICATION_VND_KCL_PROV_TEMPLATE_JSON}).header("Accept", new String[]{APPLICATION_VND_KCL_PROV_TEMPLATE_JSON}).headers(h -> {
            if (accessTokenValue != null) {
                h.setBearerAuth(accessTokenValue);
            }
        }).retrieve().onStatus(HttpStatus::is4xxClientError, response -> {
            String statusCode = response.statusCode().toString();
            ServiceInvoker.logTraceResponse(logger, response);
            return Mono.error(() -> {
                try {
                    return new IllegalStateException(String.format("4xxClientError %s for input data:\n %s\n access token: %s\n", statusCode, new ObjectMapper().writeValueAsString(data), accessTokenValue));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }).onStatus(HttpStatus::is5xxServerError, response -> {
            String statusCode = response.statusCode().toString();
            ServiceInvoker.logTraceResponse(logger, response);
            return Mono.error(() -> {
                try {
                    return new IllegalStateException(String.format("5xxServerError %s for input data:\n %s\n access token: %s\n", statusCode, new ObjectMapper().writeValueAsString(data), accessTokenValue));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }).bodyToMono(clazz).onErrorResume(throwable -> {
            logger.error("\nError issue [{}]\n", (Object)throwable.getMessage());
            return Mono.error((Throwable)throwable);
        }).blockOptional(timeoutIn10Seconds);
    }

    public static void logTraceResponse(Logger log, ClientResponse response) {
        log.error("Response status: {}", (Object)response.statusCode());
        log.error("Response headers: {}", (Object)response.headers().asHttpHeaders());
        response.bodyToMono(String.class).publishOn(Schedulers.immediate()).subscribe(body -> log.error("Response body: {}", body));
    }

    private void acceptedCodecs(ClientCodecConfigurer clientCodecConfigurer) {
        clientCodecConfigurer.customCodecs().encoder((Encoder)new Jackson2JsonEncoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
        clientCodecConfigurer.customCodecs().decoder((Decoder)new Jackson2JsonDecoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
    }

    public <Tout> Optional<Tout> get(String serviceEndpoint, String accept, Class<Tout> clazz, String accessTokenValue) {
        Duration timeoutIn10Seconds = Duration.ofSeconds(10L);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.builder().build().method(HttpMethod.GET).uri(serviceEndpoint, new Object[0])).accept(new MediaType[]{MediaType.asMediaType((MimeType)MimeType.valueOf((String)accept))})).headers(h -> h.setBearerAuth(accessTokenValue))).retrieve().bodyToMono(clazz).onErrorResume(throwable -> {
            logger.error("Error issue [{}]", (Object)throwable.getMessage());
            return Mono.error((Throwable)throwable);
        }).blockOptional(timeoutIn10Seconds);
    }
}

