/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.translator;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.interop.ApiUriFragments;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.model.test.RoundTripFromJavaTest;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.client.StringMessageBodyReader;
import org.openprovenance.prov.service.core.readers.VanillaDocumentMessageBodyReader;
import org.openprovenance.prov.service.core.writers.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.vanilla.ProvFactory;

public class TranslateIT
extends RoundTripFromJavaTest
implements ApiUriFragments {
    static final Logger logger = LogManager.getLogger(TranslateIT.class);
    static final ClientConfig config = new ClientConfig(TranslateIT.class);
    private final Client client;
    private final DocumentEquality documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), null);
    private final VanillaDocumentMessageBodyWriter bodyWriter;
    private final InteropFramework intf;
    private final ProvFactory pf = new ProvFactory();
    static Map<String, String> fileToUri = new HashMap<String, String>();

    public TranslateIT() {
        this.intf = new InteropFramework((org.openprovenance.prov.model.ProvFactory)this.pf);
        this.bodyWriter = new VanillaDocumentMessageBodyWriter((ProvDocumentWriter)this.intf);
        this.client = this.getClient();
    }

    public Client getClient() {
        Client client = ClientBuilder.newBuilder().build();
        client.register((Object)this.bodyWriter);
        client.register((Object)new VanillaDocumentMessageBodyReader((org.openprovenance.prov.model.ProvFactory)this.pf));
        return client;
    }

    public void compareDocAndFile(Document doc, String file, boolean check) {
        file = (String)file + this.extension();
        this.writeDocument(doc, (String)file);
        List<Pair> docs = this.readDocuments((String)file);
        for (Pair pair : docs) {
            Document doc3 = pair.document;
            Formats.ProvFormat format = pair.format;
            this.compareDocuments(doc, doc3, check && this.checkTest((String)file, format));
        }
    }

    public boolean checkTest(String name, Formats.ProvFormat format) {
        if (name.endsWith("bundle4" + this.extension()) && format.equals((Object)Formats.ProvFormat.PROVX)) {
            System.out.println(this.escapeRed("########## Skipping  comparison for bundle4 and PROVX"));
            return false;
        }
        if (name.endsWith("bundle5" + this.extension()) && format.equals((Object)Formats.ProvFormat.PROVX)) {
            System.out.println(this.escapeRed("########## Skipping  comparison for bundle5 and PROVX"));
            return false;
        }
        return true;
    }

    public boolean mergeDuplicateProperties() {
        return true;
    }

    public List<Pair> readDocuments(String file) {
        String location = fileToUri.get(file);
        Document doc2 = this.readDocument(location, "application/json", ".json");
        Document doc3 = this.readDocument(location, "text/provenance-notation", ".provn");
        Document doc1 = this.readDocument(location, "application/provenance+xml", ".provx");
        Document doc5 = this.readDocument(location, "application/ld+json", ".jsonld");
        Object o1 = this.readObject(location, "image/svg+xml");
        LinkedList<Pair> ll = new LinkedList<Pair>();
        ll.add(new Pair(doc1, Formats.ProvFormat.PROVX));
        ll.add(new Pair(doc2, Formats.ProvFormat.JSON));
        ll.add(new Pair(doc3, Formats.ProvFormat.PROVN));
        ll.add(new Pair(doc5, Formats.ProvFormat.JSONLD));
        return ll;
    }

    public Document readDocument(String location, String media, String extension) {
        WebTarget target = this.client.target(location + extension);
        Response response2 = target.request(new String[]{media}).get();
        org.openprovenance.prov.vanilla.Document doc = (org.openprovenance.prov.vanilla.Document)response2.readEntity(org.openprovenance.prov.vanilla.Document.class);
        return doc;
    }

    public String readAsString(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        client.register(StringMessageBodyReader.class);
        WebTarget target = client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        String o = (String)response2.readEntity(String.class);
        client.close();
        return o;
    }

    public Object readObject(String location, String media) {
        WebTarget target = this.client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        return response2.readEntity(InputStream.class);
    }

    public void writeDocument(Document doc, String file) {
        logger.info("translating: " + file);
        WebTarget target = this.client.target(TranslateIT.config.postURL);
        Response response = target.request(new String[]{"text/provenance-notation"}).post(Entity.entity((Object)doc, (String)"text/provenance-notation"));
        String location = response.getHeaderString("Location");
        location = location.replace(".provn", "");
        fileToUri.put(file, location);
    }

    public boolean checkSchema(String name) {
        return false;
    }

    public void compareDocuments(Document doc, Document doc2, boolean check) {
        TranslateIT.assertEquals((String)"self doc equality", (Object)doc, (Object)doc);
        TranslateIT.assertEquals((String)"self doc2 equality", (Object)doc2, (Object)doc2);
        if (check) {
            boolean result = this.documentEquality.check(doc, doc2);
            if (!result) {
                System.out.println("Pre-write graph: " + String.valueOf(doc));
                System.out.println("Read graph: " + String.valueOf(doc2));
            }
            TranslateIT.assertTrue((String)"doc equals doc2", (boolean)result);
        }
    }

    public void testDictionaryInsertion1() {
    }

    public void testDictionaryInsertion2() {
    }

    public void testDictionaryInsertion3() {
    }

    public void testDictionaryInsertion4() {
    }

    public void testDictionaryInsertion5() {
    }

    public void testDictionaryInsertion6() {
    }

    public void testDictionaryInsertion7() {
    }

    public void testDictionaryRemoval1() {
    }

    public void testDictionaryRemoval2() {
    }

    public void testDictionaryRemoval3() {
    }

    public void testDictionaryRemoval4() {
    }

    public void testDictionaryRemoval5() {
    }

    public void testMembership2() {
    }

    public void testMembership3() {
    }

    public void testQualifiedAlternateOf1() {
    }

    public void testQualifiedAlternateOf2() {
    }

    public void testQualifiedHadMember1() {
    }

    public void testQualifiedSpecializationOf1() {
    }

    public void addFurtherAttributes(HasOther he) {
        he.getOther().add(pFactory.newOther("http://example.org/", "tag1", "ex4", (Object)"hello", TranslateIT.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example.org/", "tag1", "ex4", (Object)"bonjour", TranslateIT.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example.org/", "tag1", "ex4", (Object)pFactory.newGYear(2002), TranslateIT.name.XSD_GYEAR));
        he.getOther().add(pFactory.newOther("http://example.org/", "tag2", "ex4", (Object)"bye", TranslateIT.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example2.org/", "tag3", "ex2", (Object)"hi", TranslateIT.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example.org/", this.get0tagWithDigit(), "ex4", (Object)"hello", TranslateIT.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example.org/", this.get0tagWithDigit(), "ex4", (Object)"hello2", TranslateIT.name.XSD_STRING));
    }

    public void testEntity101() {
        System.out.println(this.escapeRed("########## Skipping testEntity101 in TranslatorIT.java"));
    }

    public void testDefault1() {
        System.out.println(this.escapeRed("########## Skipping testing for default1 in PROVX"));
    }

    public void testDictionaryMembership1() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership1 (service)"));
    }

    public void testDictionaryMembership2() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership2 (service)"));
    }

    public void testDictionaryMembership3() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership3 (service)"));
    }

    public void testDictionaryMembership4() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership4 (service)"));
    }

    public static class Pair {
        Document document;
        Formats.ProvFormat format;

        Pair(Document document, Formats.ProvFormat format) {
            this.document = document;
            this.format = format;
        }
    }
}

