/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.readers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.openprovenance.prov.service.readers.JsonOrCsv;

@Provider
@Consumes(value={"text/csv", "application/vnd.kcl.prov-template+json"})
public class JsonOrCsvMessageBodyReader
implements MessageBodyReader<JsonOrCsv> {
    ObjectMapper om = new ObjectMapper();

    public JsonOrCsvMessageBodyReader() {
        System.out.println("JsonOrCsvMessageBodyReader ....");
    }

    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        boolean b = mediaType.toString().startsWith("text/csv") || mediaType.toString().startsWith("application/vnd.kcl.prov-template+json");
        return b;
    }

    public JsonOrCsv readFrom(Class<JsonOrCsv> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        String mediaString = this.trimCharSet(mediaType);
        if (mediaString.equals("text/csv")) {
            CSVParser parser = CSVParser.parse((InputStream)inputStream, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT);
            JsonOrCsv res = new JsonOrCsv();
            res.csv = parser;
            res.json = null;
            return res;
        }
        if (mediaString.equals("application/vnd.kcl.prov-template+json")) {
            List maps = (List)this.om.readValue(inputStream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            JsonOrCsv res = new JsonOrCsv();
            res.csv = null;
            res.json = maps;
            return res;
        }
        return null;
    }
}

