/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.dispatch;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.apache.commons.lang.StringEscapeUtils;
import org.openprovenance.prov.client.ProcessorArgsInterface;
import org.openprovenance.prov.client.RecordsProcessorInterface;
import org.openprovenance.prov.service.dispatch.EnactorException;

public class EnactCsvRecords<T> {
    static Logger logger = LogManager.getLogger(EnactCsvRecords.class);

    public List<T> process(CSVParser parser, Map<String, ProcessorArgsInterface<T>> enactors, Map<String, RecordsProcessorInterface<T>> enactors_N) throws IOException {
        return this.process((Collection)parser.getRecords(), enactors, enactors_N);
    }

    public List<T> process(Collection<CSVRecord> records, Map<String, ProcessorArgsInterface<T>> enactors, Map<String, RecordsProcessorInterface<T>> enactors_N) {
        Object[] args0;
        int size0;
        LinkedList<Object> populatedRecords = new LinkedList<Object>();
        CSVRecord record0 = records.iterator().next();
        String method = this.populateRecordAndExtractMethod(record0, size0 = record0.size(), args0 = new Object[size0]);
        ProcessorArgsInterface<T> processor_1 = enactors.get(method);
        if (processor_1 != null) {
            for (CSVRecord record2 : records) {
                int size = record2.size();
                Object[] args = new Object[size];
                this.populateRecordAndExtractMethod(record2, size, args);
                populatedRecords.add(processor_1.process(args));
            }
        } else {
            RecordsProcessorInterface<T> processor_N = enactors_N.get(method);
            if (processor_N != null) {
                List ll = records.stream().map(record -> {
                    int size = record.size();
                    Object[] args = new Object[size];
                    this.populateRecordAndExtractMethod(record, size, args);
                    return args;
                }).collect(Collectors.toList());
                Object populatedRecords0 = processor_N.process(ll);
                populatedRecords.add(populatedRecords0);
            } else {
                throw new EnactorException("Unknown method " + method, method);
            }
        }
        return populatedRecords;
    }

    private String populateRecordAndExtractMethod(CSVRecord record, int size, Object[] args) {
        String method = null;
        for (int i = 0; i < size; ++i) {
            String s = this.destringify(record.get(i));
            if (i == 0) {
                method = s;
            }
            args[i] = s == null || s.isEmpty() ? null : s;
        }
        return method;
    }

    public String destringify(String s) {
        String s1 = StringEscapeUtils.unescapeCsv((String)s);
        return s1;
    }
}

