/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;

public class JSONConstructor
implements ModelConstructor {
    private Namespace documentNamespace = null;
    private Namespace currentNamespace = null;
    private Map<String, Object> documentBundles = new HashMap<String, Object>();
    private List<JsonProvRecord> documentRecords = new ArrayList<JsonProvRecord>();
    private List<JsonProvRecord> currentRecords = this.documentRecords;
    private final Name name;
    private static final Map<String, Integer> countMap = new HashMap<String, Integer>();

    public JSONConstructor(Name name) {
        this.name = name;
    }

    public Map<String, Object> getJSONStructure() {
        Map<String, Object> document = this.getJSONStructure(this.documentRecords, this.documentNamespace);
        if (!this.documentBundles.isEmpty()) {
            document.put("bundle", this.documentBundles);
        }
        return document;
    }

    public Map<String, Object> getJSONStructure(List<JsonProvRecord> records, Namespace namespace) {
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        Hashtable<String, String> prefixes = new Hashtable<String, String>(namespace.getPrefixes());
        if (namespace.getDefaultNamespace() != null) {
            prefixes.put("default", namespace.getDefaultNamespace());
        }
        if (!prefixes.isEmpty()) {
            bundle.put("prefix", prefixes);
        }
        for (JsonProvRecord o : records) {
            if (o == null) continue;
            JsonProvRecord record = o;
            String type = record.type;
            HashMap<String, Cloneable> structure = (HashMap<String, Cloneable>)bundle.get(type);
            if (structure == null) {
                structure = new HashMap<String, Cloneable>();
                bundle.put(type, structure);
            }
            HashMap<Object, Object> hash = new HashMap<Object, Object>();
            List<Object[]> tuples = record.attributes;
            for (Object[] tuple : tuples) {
                Object attribute = tuple[0];
                Object value = tuple[1];
                if (hash.containsKey(attribute)) {
                    ArrayList<Object> values;
                    Object existing = hash.get(attribute);
                    if (existing instanceof List) {
                        values = (ArrayList<Object>)existing;
                        values.add(value);
                        continue;
                    }
                    values = new ArrayList<Object>();
                    values.add(existing);
                    values.add(value);
                    hash.put(attribute, values);
                    continue;
                }
                hash.put(attribute, value);
            }
            if (structure.containsKey(record.id)) {
                ArrayList values;
                Object existing = structure.get(record.id);
                if (existing instanceof List) {
                    values = (ArrayList)existing;
                    values.add(hash);
                    continue;
                }
                values = new ArrayList();
                values.add(existing);
                values.add(hash);
                structure.put(record.id, values);
                continue;
            }
            structure.put(record.id, hash);
        }
        return bundle;
    }

    private static String getBlankID(String type) {
        if (!countMap.containsKey(type)) {
            countMap.put(type, 0);
        }
        int count = countMap.get(type);
        countMap.put(type, ++count);
        return "_:" + type + count;
    }

    private Object[] tuple(Object o1, Object o2) {
        Object[] tuple = new Object[]{o1, o2};
        return tuple;
    }

    private Object typedLiteral(String value, String datatype, String lang) {
        if (datatype == "xsd:string" && lang == null) {
            return value;
        }
        if (datatype == "xsd:double") {
            return Double.parseDouble(value);
        }
        if (datatype == "xsd:int") {
            return Integer.parseInt(value);
        }
        if (datatype == "xsd:boolean") {
            return Boolean.parseBoolean(value);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("$", value);
        if (datatype != null) {
            result.put("type", datatype);
        }
        if (lang != null) {
            result.put("lang", lang);
        }
        return result;
    }

    private String convertValueToString(Object value, Object convertedValue) {
        if (convertedValue instanceof String) {
            return (String)convertedValue;
        }
        if (convertedValue instanceof QualifiedName) {
            return this.currentNamespace.qualifiedNameToString((QualifiedName)convertedValue);
        }
        if (convertedValue instanceof LangString) {
            LangString iStr = (LangString)convertedValue;
            return iStr.getValue();
        }
        if (convertedValue instanceof byte[]) {
            return (String)value;
        }
        return (String)value;
    }

    private Object convertValue(Object value) {
        if (value instanceof String || value instanceof Double || value instanceof Integer || value instanceof Boolean) {
            return value;
        }
        if (value instanceof QualifiedName) {
            return this.typedLiteral(this.currentNamespace.qualifiedNameToString((QualifiedName)value), "xsd:QName", null);
        }
        if (value instanceof LangString) {
            LangString iStr = (LangString)value;
            String lang = iStr.getLang();
            if (lang != null) {
                return this.typedLiteral(iStr.getValue(), "prov:InternationalizedString", lang);
            }
            return iStr.getValue();
        }
        throw new RuntimeException("Cannot convert this value: " + value.toString());
    }

    private Object[] convertAttribute(Attribute attr) {
        LangString iStr;
        String lang;
        String attrName = this.currentNamespace.qualifiedNameToString(attr.getElementName());
        Object value = attr.getValue();
        QualifiedName type = attr.getType();
        String datatype = this.currentNamespace.qualifiedNameToString(type);
        Object attrValue = value instanceof QualifiedName ? this.typedLiteral(this.currentNamespace.qualifiedNameToString((QualifiedName)value), datatype, null) : (value instanceof LangString ? ((lang = (iStr = (LangString)value).getLang()) != null ? this.typedLiteral(iStr.getValue(), "prov:InternationalizedString", lang) : iStr.getValue()) : this.typedLiteral(value.toString(), datatype, null));
        return this.tuple(attrName, attrValue);
    }

    private List<Object[]> convertAttributes(Collection<Attribute> attrs) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (attrs != null) {
            for (Attribute attr : attrs) {
                result.add(this.convertAttribute(attr));
            }
        }
        return result;
    }

    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        JsonProvRecord record = new JsonProvRecord("entity", this.currentNamespace.qualifiedNameToString(id), attrs);
        this.currentRecords.add(record);
        return null;
    }

    public Activity newActivity(QualifiedName id, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (startTime != null) {
            attrs.add(this.tuple("prov:startTime", startTime.toXMLFormat()));
        }
        if (endTime != null) {
            attrs.add(this.tuple("prov:endTime", endTime.toXMLFormat()));
        }
        JsonProvRecord record = new JsonProvRecord("activity", this.currentNamespace.qualifiedNameToString(id), attrs);
        this.currentRecords.add(record);
        return null;
    }

    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        JsonProvRecord record = new JsonProvRecord("agent", this.currentNamespace.qualifiedNameToString(id), attrs);
        this.currentRecords.add(record);
        return null;
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (entity != null) {
            attrs.add(this.tuple("prov:entity", this.currentNamespace.qualifiedNameToString(entity)));
        }
        if (time != null) {
            attrs.add(this.tuple("prov:time", time.toXMLFormat()));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("u");
        JsonProvRecord record = new JsonProvRecord("used", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (entity != null) {
            attrs.add(this.tuple("prov:entity", this.currentNamespace.qualifiedNameToString(entity)));
        }
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (time != null) {
            attrs.add(this.tuple("prov:time", time.toXMLFormat()));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wGB");
        JsonProvRecord record = new JsonProvRecord("wasGeneratedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (entity != null) {
            attrs.add(this.tuple("prov:entity", this.currentNamespace.qualifiedNameToString(entity)));
        }
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (time != null) {
            attrs.add(this.tuple("prov:time", time.toXMLFormat()));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wIB");
        JsonProvRecord record = new JsonProvRecord("wasInvalidatedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (trigger != null) {
            attrs.add(this.tuple("prov:trigger", this.currentNamespace.qualifiedNameToString(trigger)));
        }
        if (starter != null) {
            attrs.add(this.tuple("prov:starter", this.currentNamespace.qualifiedNameToString(starter)));
        }
        if (time != null) {
            attrs.add(this.tuple("prov:time", time.toXMLFormat()));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wSB");
        JsonProvRecord record = new JsonProvRecord("wasStartedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (trigger != null) {
            attrs.add(this.tuple("prov:trigger", this.currentNamespace.qualifiedNameToString(trigger)));
        }
        if (ender != null) {
            attrs.add(this.tuple("prov:ender", this.currentNamespace.qualifiedNameToString(ender)));
        }
        if (time != null) {
            attrs.add(this.tuple("prov:time", time.toXMLFormat()));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wEB");
        JsonProvRecord record = new JsonProvRecord("wasEndedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1, QualifiedName activity, QualifiedName generation, QualifiedName usage, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (e2 != null) {
            attrs.add(this.tuple("prov:generatedEntity", this.currentNamespace.qualifiedNameToString(e2)));
        }
        if (e1 != null) {
            attrs.add(this.tuple("prov:usedEntity", this.currentNamespace.qualifiedNameToString(e1)));
        }
        if (activity != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(activity)));
        }
        if (generation != null) {
            attrs.add(this.tuple("prov:generation", this.currentNamespace.qualifiedNameToString(generation)));
        }
        if (usage != null) {
            attrs.add(this.tuple("prov:usage", this.currentNamespace.qualifiedNameToString(usage)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wDF");
        JsonProvRecord record = new JsonProvRecord("wasDerivedFrom", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (a != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(a)));
        }
        if (ag != null) {
            attrs.add(this.tuple("prov:agent", this.currentNamespace.qualifiedNameToString(ag)));
        }
        if (plan != null) {
            attrs.add(this.tuple("prov:plan", this.currentNamespace.qualifiedNameToString(plan)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wAW");
        JsonProvRecord record = new JsonProvRecord("wasAssociatedWith", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName e, QualifiedName ag, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (e != null) {
            attrs.add(this.tuple("prov:entity", this.currentNamespace.qualifiedNameToString(e)));
        }
        if (ag != null) {
            attrs.add(this.tuple("prov:agent", this.currentNamespace.qualifiedNameToString(ag)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("wAT");
        JsonProvRecord record = new JsonProvRecord("wasAttributedTo", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName ag2, QualifiedName ag1, QualifiedName a, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (ag2 != null) {
            attrs.add(this.tuple("prov:delegate", this.currentNamespace.qualifiedNameToString(ag2)));
        }
        if (ag1 != null) {
            attrs.add(this.tuple("prov:responsible", this.currentNamespace.qualifiedNameToString(ag1)));
        }
        if (a != null) {
            attrs.add(this.tuple("prov:activity", this.currentNamespace.qualifiedNameToString(a)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("aOBO");
        JsonProvRecord record = new JsonProvRecord("actedOnBehalfOf", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName a2, QualifiedName a1, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (a2 != null) {
            attrs.add(this.tuple("prov:informed", this.currentNamespace.qualifiedNameToString(a2)));
        }
        if (a1 != null) {
            attrs.add(this.tuple("prov:informant", this.currentNamespace.qualifiedNameToString(a1)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("Infm");
        JsonProvRecord record = new JsonProvRecord("wasInformedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName a2, QualifiedName a1, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (a2 != null) {
            attrs.add(this.tuple("prov:influencee", this.currentNamespace.qualifiedNameToString(a2)));
        }
        if (a1 != null) {
            attrs.add(this.tuple("prov:influencer", this.currentNamespace.qualifiedNameToString(a1)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("Infl");
        JsonProvRecord record = new JsonProvRecord("wasInfluencedBy", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public AlternateOf newAlternateOf(QualifiedName e2, QualifiedName e1) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (e2 != null) {
            attrs.add(this.tuple("prov:alternate2", this.currentNamespace.qualifiedNameToString(e2)));
        }
        if (e1 != null) {
            attrs.add(this.tuple("prov:alternate1", this.currentNamespace.qualifiedNameToString(e1)));
        }
        String recordID = JSONConstructor.getBlankID("aO");
        JsonProvRecord record = new JsonProvRecord("alternateOf", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public SpecializationOf newSpecializationOf(QualifiedName e2, QualifiedName e1) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (e2 != null) {
            attrs.add(this.tuple("prov:specificEntity", this.currentNamespace.qualifiedNameToString(e2)));
        }
        if (e1 != null) {
            attrs.add(this.tuple("prov:generalEntity", this.currentNamespace.qualifiedNameToString(e1)));
        }
        String recordID = JSONConstructor.getBlankID("sO");
        JsonProvRecord record = new JsonProvRecord("specializationOf", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public MentionOf newMentionOf(QualifiedName e2, QualifiedName e1, QualifiedName b) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (e2 != null) {
            attrs.add(this.tuple("prov:specificEntity", this.currentNamespace.qualifiedNameToString(e2)));
        }
        if (e1 != null) {
            attrs.add(this.tuple("prov:generalEntity", this.currentNamespace.qualifiedNameToString(e1)));
        }
        if (b != null) {
            attrs.add(this.tuple("prov:bundle", this.currentNamespace.qualifiedNameToString(b)));
        }
        String recordID = JSONConstructor.getBlankID("mO");
        JsonProvRecord record = new JsonProvRecord("mentionOf", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public HadMember newHadMember(QualifiedName c, Collection<QualifiedName> e) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (c != null) {
            attrs.add(this.tuple("prov:collection", this.currentNamespace.qualifiedNameToString(c)));
        }
        if (e != null && !e.isEmpty()) {
            ArrayList<String> entityList = new ArrayList<String>();
            for (QualifiedName entity : e) {
                entityList.add(this.currentNamespace.qualifiedNameToString(entity));
            }
            attrs.add(this.tuple("prov:entity", entityList));
        }
        String recordID = JSONConstructor.getBlankID("hM");
        JsonProvRecord record = new JsonProvRecord("hadMember", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public Document newDocument(Namespace namespaces, Collection<Statement> statements, Collection<Bundle> bundles) {
        return null;
    }

    public Bundle newNamedBundle(QualifiedName id, Namespace namespaces, Collection<Statement> statements) {
        Map<String, Object> bundle = this.getJSONStructure(this.currentRecords, this.currentNamespace);
        this.documentBundles.put(this.currentNamespace.qualifiedNameToString(id), bundle);
        this.currentRecords = this.documentRecords;
        this.currentNamespace = this.documentNamespace;
        return null;
    }

    public void startDocument(Namespace namespace) {
        this.currentNamespace = this.documentNamespace = namespace;
    }

    public void startBundle(QualifiedName bundleId, Namespace namespaces) {
        this.currentNamespace = namespaces;
        this.currentRecords = new ArrayList<JsonProvRecord>();
    }

    private Object encodeKeyEntitySet(List<Entry> keyEntitySet) {
        boolean isAllKeyOfSameDatatype = true;
        Key firstKey = keyEntitySet.get(0).getKey();
        QualifiedName firstKeyClass = firstKey.getType();
        if (this.name.PROV_LANG_STRING.equals((Object)firstKeyClass)) {
            isAllKeyOfSameDatatype = false;
        }
        if (isAllKeyOfSameDatatype) {
            for (Entry pair : keyEntitySet) {
                QualifiedName keyClass = pair.getKey().getType();
                if (keyClass == firstKeyClass) continue;
                isAllKeyOfSameDatatype = false;
                break;
            }
        }
        if (isAllKeyOfSameDatatype) {
            HashMap<String, String> dictionary = new HashMap<String, String>();
            String keyDatatype = this.currentNamespace.qualifiedNameToString(keyEntitySet.get(0).getKey().getType());
            dictionary.put("$key-datatype", keyDatatype);
            for (Entry pair : keyEntitySet) {
                String key = this.convertValueToString(pair.getKey().getValue(), pair.getKey().getConvertedValue());
                String entity = this.currentNamespace.qualifiedNameToString(pair.getEntity());
                dictionary.put(key, entity);
            }
            return dictionary;
        }
        ArrayList values = new ArrayList(keyEntitySet.size());
        for (Entry pair : keyEntitySet) {
            String entity = this.currentNamespace.qualifiedNameToString(pair.getEntity());
            Hashtable<String, Object> item = new Hashtable<String, Object>();
            item.put("$", entity);
            item.put("key", this.convertValue(pair.getKey().getConvertedValue()));
            values.add(item);
        }
        return values;
    }

    public DerivedByInsertionFrom newDerivedByInsertionFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Entry> keyEntitySet, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (after != null) {
            attrs.add(this.tuple("prov:after", this.currentNamespace.qualifiedNameToString(after)));
        }
        if (before != null) {
            attrs.add(this.tuple("prov:before", this.currentNamespace.qualifiedNameToString(before)));
        }
        if (keyEntitySet != null && !keyEntitySet.isEmpty()) {
            attrs.add(this.tuple("prov:key-entity-set", this.encodeKeyEntitySet(keyEntitySet)));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("dBIF");
        JsonProvRecord record = new JsonProvRecord("derivedByInsertionFrom", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public DerivedByRemovalFrom newDerivedByRemovalFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Key> keys, Collection<Attribute> attributes) {
        List<Object[]> attrs = this.convertAttributes(attributes);
        if (after != null) {
            attrs.add(this.tuple("prov:after", this.currentNamespace.qualifiedNameToString(after)));
        }
        if (before != null) {
            attrs.add(this.tuple("prov:before", this.currentNamespace.qualifiedNameToString(before)));
        }
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Object> values = new ArrayList<Object>(keys.size());
            for (Key key : keys) {
                values.add(this.convertValue(key.getValue()));
            }
            attrs.add(this.tuple("prov:key-set", values));
        }
        String recordID = id != null ? this.currentNamespace.qualifiedNameToString(id) : JSONConstructor.getBlankID("dBRF");
        JsonProvRecord record = new JsonProvRecord("derivedByRemovalFrom", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public DictionaryMembership newDictionaryMembership(QualifiedName dict, List<Entry> keyEntitySet) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        if (dict != null) {
            attrs.add(this.tuple("prov:dictionary", this.currentNamespace.qualifiedNameToString(dict)));
        }
        if (keyEntitySet != null && !keyEntitySet.isEmpty()) {
            attrs.add(this.tuple("prov:key-entity-set", this.encodeKeyEntitySet(keyEntitySet)));
        }
        String recordID = JSONConstructor.getBlankID("hDM");
        JsonProvRecord record = new JsonProvRecord("hadDictionaryMember", recordID, attrs);
        this.currentRecords.add(record);
        return null;
    }

    public QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return null;
    }

    private class JsonProvRecord {
        String type;
        String id;
        List<Object[]> attributes;

        public JsonProvRecord(String type, String id, List<Object[]> attributes) {
            this.type = type;
            this.id = id;
            this.attributes = attributes;
        }
    }
}

