/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTDescribe;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTProjectionElem;
import org.openrdf.query.parser.sparql.ast.ASTQuery;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTSelect;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.ASTWhereClause;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class WildcardProjectionProcessor
extends ASTVisitorBase {
    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        ASTDescribeQuery describeQuery;
        ASTDescribe describeClause;
        ASTWhereClause queryBody;
        ASTQuery queryNode = qc.getQuery();
        if (queryNode != null && (queryBody = queryNode.getWhereClause()) != null) {
            SelectClauseCollector collector = new SelectClauseCollector();
            try {
                queryBody.jjtAccept(collector, null);
                Set<ASTSelect> selectClauses = collector.getSelectClauses();
                for (ASTSelect selectClause : selectClauses) {
                    if (!selectClause.isWildcard()) continue;
                    ASTSelectQuery q = (ASTSelectQuery)selectClause.jjtGetParent();
                    WildcardProjectionProcessor.addQueryVars(q.getWhereClause(), selectClause);
                    selectClause.setWildcard(false);
                }
            }
            catch (VisitorException e) {
                throw new MalformedQueryException((Throwable)e);
            }
        }
        if (queryNode instanceof ASTSelectQuery) {
            ASTSelectQuery selectQuery = (ASTSelectQuery)queryNode;
            ASTSelect selectClause = selectQuery.getSelect();
            if (selectClause.isWildcard()) {
                WildcardProjectionProcessor.addQueryVars(selectQuery.getWhereClause(), selectClause);
                selectClause.setWildcard(false);
            }
        } else if (queryNode instanceof ASTDescribeQuery && (describeClause = (describeQuery = (ASTDescribeQuery)queryNode).getDescribe()).isWildcard()) {
            WildcardProjectionProcessor.addQueryVars(describeQuery.getWhereClause(), describeClause);
            describeClause.setWildcard(false);
        }
    }

    private static void addQueryVars(ASTWhereClause queryBody, Node wildcardNode) throws MalformedQueryException {
        QueryVariableCollector visitor = new QueryVariableCollector();
        try {
            queryBody.jjtAccept(visitor, null);
            for (String varName : visitor.getVariableNames()) {
                ASTVar varNode = new ASTVar(48);
                ASTProjectionElem projectionElemNode = new ASTProjectionElem(8);
                varNode.setName(varName);
                projectionElemNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(projectionElemNode);
                wildcardNode.jjtAppendChild(projectionElemNode);
                projectionElemNode.jjtSetParent(wildcardNode);
            }
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectClauseCollector
    extends ASTVisitorBase {
        private Set<ASTSelect> selectClauses = new LinkedHashSet<ASTSelect>();

        private SelectClauseCollector() {
        }

        public Set<ASTSelect> getSelectClauses() {
            return this.selectClauses;
        }

        @Override
        public Object visit(ASTSelect node, Object data) throws VisitorException {
            this.selectClauses.add(node);
            return super.visit(node, data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryVariableCollector
    extends ASTVisitorBase {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private QueryVariableCollector() {
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTSelectQuery node, Object data) throws VisitorException {
            return this.visit(node.getSelect(), data);
        }

        @Override
        public Object visit(ASTProjectionElem node, Object data) throws VisitorException {
            String alias = node.getAlias();
            if (alias != null) {
                this.variableNames.add(alias);
                return null;
            }
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            if (!node.isAnonymous()) {
                this.variableNames.add(node.getName());
            }
            return super.visit(node, data);
        }
    }
}

