/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.dot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.openprovenance.prov.dot.AccountColorMapEntry;
import org.openprovenance.prov.dot.ActivityMapEntry;
import org.openprovenance.prov.dot.AgentMapEntry;
import org.openprovenance.prov.dot.EntityMapEntry;
import org.openprovenance.prov.dot.ProvPrinterConfigDeserialiser;
import org.openprovenance.prov.dot.ProvPrinterConfiguration;
import org.openprovenance.prov.dot.RelationStyleMapEntry;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Influence;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.xml.ProvDeserialiser;
import org.openprovenance.prov.xml.ProvFactory;

public class ProvToDot {
    private static final String TOOLBOX_DOT_NS = "http://openprovenance.org/Toolbox/dot#";
    public static final String DEFAULT_CONFIGURATION_FILE = "defaultConfig.xml";
    public static final String DEFAULT_CONFIGURATION_FILE_WITH_ROLE = "defaultConfigWithRole.xml";
    public static final String DEFAULT_CONFIGURATION_FILE_WITH_ROLE_NO_LABEL = "defaultConfigWithRoleNoLabel.xml";
    public static final String USAGE = "prov2dot provFile.xml out.dot out.pdf [configuration.xml]";
    ProvUtilities u = new ProvUtilities();
    ProvFactory of = new ProvFactory();
    boolean collapseAnnotations = true;
    static int embeddedAnnotationCounter = 0;
    int annotationCount = 0;
    boolean displayActivityValue = false;
    boolean displayActivityColor = false;
    boolean displayEntityValue = false;
    boolean displayEntityColor = false;
    boolean displayAgentColor = false;
    boolean displayAgentValue = false;
    boolean displayAnnotationColor = true;
    HashMap<String, String> processNameMap = new HashMap();
    HashMap<String, String> artifactNameMap = new HashMap();
    HashMap<String, String> agentNameMap = new HashMap();
    int bncounter = 0;
    HashMap<String, String> accountColourMap = new HashMap();
    String defaultRelationStyle;
    HashMap<String, RelationStyleMapEntry> edgeStyleMap = new HashMap();
    String name;
    String defaultAccountLabel;
    String defaultAccountColor;
    private String layout;

    public String qualifiedNameToString(QualifiedName qName) {
        return qName.getNamespaceURI() + qName.getLocalPart();
    }

    public String localnameToString(QualifiedName qName) {
        return qName.getLocalPart();
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0 || args.length > 4) {
            System.out.println(USAGE);
            return;
        }
        String opmFile = args[0];
        String outDot = args[1];
        String outPdf = args[2];
        String configFile = args.length == 4 ? args[3] : null;
        ProvToDot converter = configFile == null ? new ProvToDot() : new ProvToDot(configFile);
        converter.convert(opmFile, outDot, outPdf, null);
    }

    public ProvToDot() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE);
        this.init(is);
    }

    public ProvToDot(boolean withRoleFlag) {
        InputStream is = withRoleFlag ? this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE_WITH_ROLE) : this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE);
        this.init(is);
    }

    public ProvToDot(Config config) {
        InputStream is = null;
        switch (config) {
            case DEFAULT: {
                System.out.println("ProvToDot DEFAULT");
                is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE);
                break;
            }
            case ROLE: {
                System.out.println("ProvToDot role");
                is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE_WITH_ROLE);
                break;
            }
            default: {
                is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE_WITH_ROLE_NO_LABEL);
            }
        }
        this.init(is);
    }

    public ProvToDot(String configurationFile) {
        this();
        this.init(configurationFile);
    }

    public ProvToDot(String configurationFile, String other) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(configurationFile);
        this.init(is);
    }

    public ProvPrinterConfigDeserialiser getDeserialiser() {
        return ProvPrinterConfigDeserialiser.getThreadProvPrinterConfigDeserialiser();
    }

    public void init(String configurationFile) {
        ProvPrinterConfigDeserialiser printerDeserial = this.getDeserialiser();
        try {
            ProvPrinterConfiguration opc = printerDeserial.deserialiseProvPrinterConfiguration(new File(configurationFile));
            this.init(opc);
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
    }

    public void init(InputStream is) {
        ProvPrinterConfigDeserialiser printerDeserial = this.getDeserialiser();
        try {
            ProvPrinterConfiguration opc = printerDeserial.deserialiseProvPrinterConfiguration(is);
            this.init(opc);
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
    }

    public void init(ProvPrinterConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        if (configuration.getRelations() != null) {
            if (configuration.getRelations().getDefault() != null) {
                this.defaultRelationStyle = configuration.getRelations().getDefault();
            }
            for (RelationStyleMapEntry edge : configuration.getRelations().getRelation()) {
                this.edgeStyleMap.put(edge.getType(), edge);
            }
        }
        if (configuration.getActivities() != null) {
            if (configuration.getActivities().isDisplayValue() != null) {
                this.displayActivityValue = configuration.getActivities().isDisplayValue();
            }
            if (configuration.getActivities().isColoredAsAccount() != null) {
                this.displayActivityColor = configuration.getActivities().isColoredAsAccount();
            }
            for (ActivityMapEntry process : configuration.getActivities().getActivity()) {
                this.processNameMap.put(process.getValue(), process.getDisplay());
            }
        }
        if (configuration.getEntities() != null) {
            if (configuration.getEntities().isDisplayValue() != null) {
                this.displayEntityValue = configuration.getEntities().isDisplayValue();
            }
            if (configuration.getEntities().isColoredAsAccount() != null) {
                this.displayEntityColor = configuration.getEntities().isColoredAsAccount();
            }
            for (EntityMapEntry artifact : configuration.getEntities().getEntity()) {
                this.artifactNameMap.put(artifact.getValue(), artifact.getDisplay());
            }
        }
        if (configuration.getAgents() != null) {
            if (configuration.getAgents().isDisplayValue() != null) {
                this.displayAgentValue = configuration.getAgents().isDisplayValue();
            }
            if (configuration.getAgents().isColoredAsAccount() != null) {
                this.displayAgentColor = configuration.getAgents().isColoredAsAccount();
            }
            for (AgentMapEntry agent : configuration.getAgents().getAgent()) {
                this.agentNameMap.put(agent.getValue(), agent.getDisplay());
            }
        }
        if (configuration.getAccounts() != null) {
            if (configuration.getAccounts().getDefaultAccount() != null) {
                this.defaultAccountLabel = configuration.getAccounts().getDefaultAccount();
            }
            if (configuration.getAccounts().getDefaultColor() != null) {
                this.defaultAccountColor = configuration.getAccounts().getDefaultColor();
            }
            for (AccountColorMapEntry account : configuration.getAccounts().getAccount()) {
                this.accountColourMap.put(account.getName(), account.getColor());
            }
        }
        if (configuration.getGraphName() != null) {
            this.name = configuration.getGraphName();
        }
    }

    public void convert(String opmFile, String dotFile, String pdfFile, String title) throws FileNotFoundException, IOException, JAXBException {
        this.convert((Document)ProvDeserialiser.getThreadProvDeserialiser().deserialiseDocument(new File(opmFile)), dotFile, pdfFile, title);
    }

    public void convert(Document graph, String dotFile, String pdfFile, String title) throws FileNotFoundException, IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot -o " + pdfFile + " -Tpdf " + dotFile);
    }

    public void convert(Document graph, String dotFile, OutputStream pdfStream, String title) throws FileNotFoundException, IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot  -Tpdf " + dotFile);
        InputStream is = proc.getInputStream();
        IOUtils.copy((InputStream)is, (OutputStream)pdfStream);
    }

    public void convert(Document graph, String dotFile, String title) throws FileNotFoundException, IOException {
        this.convert(graph, new File(dotFile), title);
    }

    public void convert(Document graph, String dotFile, String aFile, String type, String title) throws FileNotFoundException, IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot -o " + aFile + " -T" + type + " " + dotFile);
        try {
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String s_error = errorReader.readLine();
            if (s_error != null) {
                System.out.println("Error:  " + s_error);
            }
            proc.waitFor();
            System.err.println("exit value " + proc.exitValue());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void convert(Document graph, String dotFile, OutputStream os, String type, String title) throws FileNotFoundException, IOException {
        this.convert(graph, new File(dotFile), title);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec("dot  -T" + type + " " + dotFile);
        InputStream is = proc.getInputStream();
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    public void convert(Document graph, File file, String title) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(file);
        this.convert(graph, new PrintStream(os), title);
    }

    public void convert(Document graph, OutputStream os, String title) {
        this.convert(graph, new PrintStream(os), title);
    }

    public void convert(Document doc, PrintStream out, String title) {
        if (title != null) {
            this.name = title;
        }
        List edges = this.u.getRelations(doc);
        this.prelude(doc, out);
        if (this.u.getActivity(doc) != null) {
            for (Activity p : this.u.getActivity(doc)) {
                this.emitActivity(p, out);
            }
        }
        if (this.u.getEntity(doc) != null) {
            for (Activity p : this.u.getEntity(doc)) {
                this.emitEntity((Entity)p, out);
            }
        }
        if (this.u.getAgent(doc) != null) {
            for (Activity p : this.u.getAgent(doc)) {
                this.emitAgent((Agent)p, out);
            }
        }
        if (this.u.getBundle(doc) != null) {
            for (Bundle bun : this.u.getBundle(doc)) {
                this.convert(bun, out);
            }
        }
        for (Relation e : edges) {
            this.emitDependency(e, out);
        }
        this.postlude(doc, out);
    }

    public void convert(Bundle bun, PrintStream out) {
        List edges = this.u.getRelations(bun);
        this.prelude(bun, out);
        if (this.u.getActivity(bun) != null) {
            for (Activity p : this.u.getActivity(bun)) {
                this.emitActivity(p, out);
            }
        }
        if (this.u.getEntity(bun) != null) {
            for (Activity p : this.u.getEntity(bun)) {
                this.emitEntity((Entity)p, out);
            }
        }
        if (this.u.getAgent(bun) != null) {
            for (Activity p : this.u.getAgent(bun)) {
                this.emitAgent((Agent)p, out);
            }
        }
        for (Relation e : edges) {
            this.emitDependency(e, out);
        }
        this.postlude(bun, out);
    }

    public void emitAnnotations(HasOther node, PrintStream out) {
    }

    public void emitActivity(Activity p, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitElement(p.getId(), this.addURL(p.getId(), this.addActivityShape(p, this.addActivityLabel(p, this.addActivityColor(p, properties)))), out);
        this.emitAnnotations("", (HasOther)p, out);
    }

    public void emitEntity(Entity a, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitElement(a.getId(), this.addURL(a.getId(), this.addEntityShape(a, this.addEntityLabel(a, this.addEntityColor(a, properties)))), out);
        this.emitAnnotations("", (HasOther)a, out);
    }

    public void emitAgent(Agent ag, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.emitElement(ag.getId(), this.addURL(ag.getId(), this.addAgentShape(ag, this.addAgentLabel(ag, this.addAgentColor(ag, properties)))), out);
        this.emitAnnotations("", (HasOther)ag, out);
    }

    public void emitAnnotations(String id, HasOther ann, PrintStream out) {
        if ((ann.getOther() == null || ann.getOther().isEmpty() || this.countOthers(ann) == 0) && ((HasType)ann).getType().isEmpty()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        QualifiedName newId = this.annotationId(((Identifiable)ann).getId(), id);
        this.emitElement(newId, this.addAnnotationShape(ann, this.addAnnotationColor(ann, this.addAnnotationLabel(ann, properties))), out);
        HashMap<String, String> linkProperties = new HashMap<String, String>();
        this.emitRelation(this.qualifiedNameToString(newId), this.qualifiedNameToString(((Identifiable)ann).getId()), this.addAnnotationLinkProperties(ann, linkProperties), out, true);
    }

    public QualifiedName annotationId(QualifiedName id, String node) {
        return this.of.newQualifiedName("http://annot/", "ann" + node + this.annotationCount++, null);
    }

    public HashMap<String, String> addURL(QualifiedName id, HashMap<String, String> properties) {
        if (id != null) {
            properties.put("URL", id.getNamespaceURI() + id.getLocalPart());
        }
        return properties;
    }

    public HashMap<String, String> addAnnotationLinkProperties(HasOther ann, HashMap<String, String> properties) {
        properties.put("arrowhead", "none");
        properties.put("style", "dashed");
        properties.put("color", "gray");
        return properties;
    }

    public HashMap<String, String> addActivityShape(Activity p, HashMap<String, String> properties) {
        properties.put("shape", "polygon");
        properties.put("sides", "4");
        return properties;
    }

    public HashMap<String, String> addBlankNodeShape(HashMap<String, String> properties) {
        properties.put("shape", "point");
        properties.put("label", "");
        return properties;
    }

    public HashMap<String, String> addActivityLabel(Activity p, HashMap<String, String> properties) {
        properties.put("label", this.processLabel(p));
        return properties;
    }

    public HashMap<String, String> addActivityColor(Activity p, HashMap<String, String> properties) {
        if (this.displayActivityColor) {
            properties.put("color", this.processColor(p));
            properties.put("fontcolor", this.processColor(p));
        } else {
            properties.put("fillcolor", "#9FB1FC");
            properties.put("color", "#0000FF");
            properties.put("style", "filled");
        }
        this.addColors((HasOther)p, properties);
        return properties;
    }

    public HashMap<String, String> addColors(HasOther object, HashMap<String, String> properties) {
        Hashtable table = this.u.attributesWithNamespace(object, TOOLBOX_DOT_NS);
        List o = (List)table.get("fillcolor");
        if (o != null && !o.isEmpty()) {
            properties.put("fillcolor", ((Other)o.get(0)).getValue().toString());
            properties.put("style", "filled");
        }
        if ((o = (List)table.get("color")) != null && !o.isEmpty()) {
            properties.put("color", ((Other)o.get(0)).getValue().toString());
        }
        if ((o = (List)table.get("url")) != null && !o.isEmpty()) {
            properties.put("URL", ((Other)o.get(0)).getValue().toString());
        }
        if ((o = (List)table.get("size")) != null && !o.isEmpty() && object instanceof Influence) {
            properties.put("penwidth", ((Other)o.get(0)).getValue().toString());
        }
        if ((o = (List)table.get("tooltip")) != null && !o.isEmpty()) {
            properties.put("tooltip", ((Other)o.get(0)).getValue().toString());
        }
        return properties;
    }

    public HashMap<String, String> addEntityShape(Entity p, HashMap<String, String> properties) {
        List types = p.getType();
        for (Type type : types) {
            QualifiedName name;
            if (!(type.getValue() instanceof QualifiedName) || !"Dictionary".equals((name = (QualifiedName)type.getValue()).getLocalPart()) && !"EmptyDictionary".equals(name.getLocalPart())) continue;
            properties.put("shape", "folder");
        }
        return properties;
    }

    public HashMap<String, String> addEntityColor(Entity a, HashMap<String, String> properties) {
        if (this.displayEntityColor) {
            properties.put("color", this.entityColor(a));
            properties.put("fontcolor", this.entityColor(a));
        } else {
            properties.put("fillcolor", "#FFFC87");
            properties.put("color", "#808080");
            properties.put("style", "filled");
        }
        this.addColors((HasOther)a, properties);
        return properties;
    }

    public HashMap<String, String> addEntityLabel(Entity p, HashMap<String, String> properties) {
        properties.put("label", this.entityLabel(p));
        return properties;
    }

    public HashMap<String, String> addAgentShape(Agent p, HashMap<String, String> properties) {
        properties.put("shape", "house");
        return properties;
    }

    public HashMap<String, String> addAgentLabel(Agent p, HashMap<String, String> properties) {
        properties.put("label", this.agentLabel(p));
        return properties;
    }

    public HashMap<String, String> addAgentColor(Agent a, HashMap<String, String> properties) {
        if (this.displayAgentColor) {
            properties.put("color", this.agentColor(a));
            properties.put("fontcolor", this.agentColor(a));
        } else {
            properties.put("fillcolor", "#FDB266");
            properties.put("style", "filled");
        }
        this.addColors((HasOther)a, properties);
        return properties;
    }

    public HashMap<String, String> addAnnotationShape(HasOther ann, HashMap<String, String> properties) {
        properties.put("shape", "note");
        return properties;
    }

    public HashMap<String, String> addAnnotationLabel(HasOther ann, HashMap<String, String> properties) {
        String label = "";
        label = label + "<<TABLE cellpadding=\"0\" border=\"0\">\n";
        for (Type type : ((HasType)ann).getType()) {
            label = label + "\t<TR>\n";
            label = label + "\t    <TD align=\"left\">" + "type" + ":</TD>\n";
            label = label + "\t    <TD align=\"left\">" + this.getPropertyValueFromAny(type) + "</TD>\n";
            label = label + "\t</TR>\n";
        }
        for (Other prop : ann.getOther()) {
            if ("fillcolor".equals(prop.getElementName().getLocalPart()) || "size".equals(prop.getElementName().getLocalPart())) continue;
            label = label + "\t<TR>\n";
            label = label + "\t    <TD align=\"left\">" + this.convertProperty((Attribute)prop) + ":</TD>\n";
            label = label + "\t    <TD align=\"left\">" + this.convertValue((Attribute)prop) + "</TD>\n";
            label = label + "\t</TR>\n";
        }
        label = label + "    </TABLE>>\n";
        properties.put("label", label);
        properties.put("fontsize", "10");
        return properties;
    }

    public int countOthers(HasOther ann) {
        int count = 0;
        for (Other obj : ann.getOther()) {
            if (TOOLBOX_DOT_NS.equals(obj.getElementName().getNamespaceURI())) continue;
            ++count;
        }
        return count;
    }

    public String convertValue(Attribute v) {
        if (v.getValue() instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)v.getValue();
            return name.getLocalPart();
        }
        String label = this.getPropertyValueFromAny(v);
        int i = label.lastIndexOf("#");
        int j = label.lastIndexOf("/");
        return label.substring(Math.max(i, j) + 1, label.length());
    }

    public String convertProperty(Attribute oLabel) {
        String label = this.getPropertyFromAny(oLabel);
        int i = label.lastIndexOf("#");
        int j = label.lastIndexOf("/");
        return label.substring(Math.max(i, j) + 1, label.length());
    }

    public String getPropertyFromAny(Attribute o) {
        return o.getElementName().getUri();
    }

    public String getPropertyValueFromAny(Type t) {
        Object val = t.getValue();
        if (val instanceof QualifiedName) {
            QualifiedName q = (QualifiedName)val;
            return q.getNamespaceURI() + q.getLocalPart();
        }
        return "" + val;
    }

    public String getPropertyValueFromAny(Attribute o) {
        Object val = o.getValue();
        if (val instanceof QualifiedName) {
            QualifiedName q = (QualifiedName)val;
            return q.getNamespaceURI() + q.getLocalPart();
        }
        return "" + val;
    }

    public HashMap<String, String> addAnnotationColor(HasOther ann, HashMap<String, String> properties) {
        if (this.displayAnnotationColor) {
            properties.put("color", this.annotationColor(ann));
            properties.put("fontcolor", "black");
        }
        return properties;
    }

    public String processLabel(Activity p) {
        if (this.displayActivityValue) {
            return this.convertActivityName("" + this.of.getLabel((HasOther)p));
        }
        return this.localnameToString(p.getId());
    }

    public String processColor(Activity p) {
        LinkedList<String> colors = new LinkedList<String>();
        return this.selectColor(colors);
    }

    public String selectColor(List<String> colors) {
        String tr = "transparent";
        for (String c : colors) {
            if (c.equals(tr)) continue;
            return c;
        }
        return tr;
    }

    public String entityLabel(Entity p) {
        if (this.displayEntityValue) {
            return this.convertEntityName("" + this.of.getLabel((HasOther)p));
        }
        return this.localnameToString(p.getId());
    }

    public String entityColor(Entity p) {
        LinkedList<String> colors = new LinkedList<String>();
        return this.selectColor(colors);
    }

    public String agentColor(Agent p) {
        LinkedList<String> colors = new LinkedList<String>();
        return this.selectColor(colors);
    }

    public String annotationColor(HasOther ann) {
        LinkedList<String> colors = new LinkedList<String>();
        colors.add("gray");
        return this.selectColor(colors);
    }

    public String agentLabel(Agent p) {
        if (this.displayAgentValue) {
            return this.convertAgentName("" + this.of.getLabel((HasOther)p));
        }
        return this.localnameToString(p.getId());
    }

    public String convertActivityName(String process) {
        String name = this.processNameMap.get(process);
        if (name != null) {
            return name;
        }
        return process;
    }

    public String convertEntityName(String artifact) {
        String name = this.artifactNameMap.get(artifact);
        if (name != null) {
            return name;
        }
        return artifact;
    }

    public String convertAgentName(String agent) {
        String name = this.agentNameMap.get(agent);
        if (name != null) {
            return name;
        }
        return agent;
    }

    public void emitDependency(Relation e, PrintStream out) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List others = this.u.getOtherCauses(e);
        if (others != null) {
            String bnid = "bn" + this.bncounter++;
            this.emitBlankNode(this.dotify(bnid), this.addBlankNodeShape(properties), out);
            HashMap<String, String> properties2 = new HashMap<String, String>();
            properties2.put("arrowhead", "none");
            String arrowTail = this.getArrowShapeForRelation(e);
            if (arrowTail != null) {
                properties2.put("arrowtail", arrowTail);
                properties2.put("dir", "back");
            }
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties2);
            }
            HashMap<String, String> properties3 = new HashMap<String, String>();
            QualifiedName effect = this.u.getEffect(e);
            if (effect != null) {
                this.emitRelation(this.qualifiedNameToString(effect), bnid, properties2, out, true);
            }
            this.relationName(e, properties3);
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties3);
            }
            if (e instanceof DerivedByInsertionFrom) {
                properties3.put("arrowhead", "onormal");
            }
            if (this.u.getCause(e) != null) {
                this.emitRelation(bnid, this.qualifiedNameToString(this.u.getCause(e)), properties3, out, true);
            }
            HashMap<String, String> properties4 = new HashMap<String, String>();
            if (e instanceof HasOther) {
                this.addColors((HasOther)e, properties4);
            }
            for (QualifiedName other : others) {
                if (other == null) continue;
                this.emitRelation(bnid, this.qualifiedNameToString(other), properties4, out, true);
            }
        } else if (this.u.getCause(e) != null) {
            String arrowTail;
            this.relationName(e, properties);
            if (e instanceof Influence) {
                this.addColors((HasOther)((Influence)e), properties);
            }
            if ((arrowTail = this.getArrowShapeForRelation(e)) != null) {
                properties.put("arrowtail", arrowTail);
                properties.put("dir", "both");
            }
            QualifiedName effect = this.u.getEffect(e);
            QualifiedName cause = this.u.getCause(e);
            if (effect != null && cause != null) {
                this.emitRelation(this.qualifiedNameToString(effect), this.qualifiedNameToString(cause), properties, out, true);
            }
        }
    }

    void relationName(Relation e, HashMap<String, String> properties) {
        String l = this.getShortLabelForRelation(e);
        if (l != null) {
            properties.put("taillabel", l);
            properties.put("labelangle", "60.0");
            properties.put("labeldistance", "1.5");
            properties.put("rotation", "20");
            properties.put("labelfontsize", "8");
        }
    }

    String getArrowShapeForRelation(Relation e) {
        if (e instanceof WasStartedBy) {
            return "oinv";
        }
        if (e instanceof WasEndedBy) {
            return "odiamond";
        }
        if (e instanceof WasInvalidatedBy) {
            return "odiamond";
        }
        return null;
    }

    String getLabelForRelation(Relation e) {
        if (e instanceof Used) {
            return "used";
        }
        if (e instanceof WasGeneratedBy) {
            return "wasGeneratedBy";
        }
        if (e instanceof WasDerivedFrom) {
            return "wasDerivedFrom";
        }
        if (e instanceof WasStartedBy) {
            return "wasStartedBy";
        }
        if (e instanceof WasEndedBy) {
            return "wasEndedBy";
        }
        if (e instanceof WasInvalidatedBy) {
            return "wasInvalidatedBy";
        }
        if (e instanceof WasInformedBy) {
            return "wasInformedBy";
        }
        if (e instanceof WasAssociatedWith) {
            return "wasAssociatedWith";
        }
        if (e instanceof WasAttributedTo) {
            return "wasAttributedTo";
        }
        if (e instanceof WasInfluencedBy) {
            return "wasInfluencedBy";
        }
        if (e instanceof ActedOnBehalfOf) {
            return "actedOnBehalfOf";
        }
        if (e instanceof SpecializationOf) {
            return "specializationOf";
        }
        if (e instanceof AlternateOf) {
            return "alternateOf";
        }
        return null;
    }

    String getShortLabelForRelation(Relation e) {
        if (e instanceof Used) {
            return "use";
        }
        if (e instanceof WasGeneratedBy) {
            return "gen";
        }
        if (e instanceof WasDerivedFrom) {
            return "der";
        }
        if (e instanceof WasStartedBy) {
            return "start";
        }
        if (e instanceof WasEndedBy) {
            return "end";
        }
        if (e instanceof WasInvalidatedBy) {
            return "inv";
        }
        if (e instanceof WasInformedBy) {
            return "inf";
        }
        if (e instanceof WasAssociatedWith) {
            return "assoc";
        }
        if (e instanceof WasAttributedTo) {
            return "att";
        }
        if (e instanceof WasInfluencedBy) {
            return "inf";
        }
        if (e instanceof ActedOnBehalfOf) {
            return "del";
        }
        if (e instanceof SpecializationOf) {
            return "spe";
        }
        if (e instanceof AlternateOf) {
            return "alt";
        }
        return null;
    }

    public HashMap<String, String> addRelationAttributes(String accountLabel, Relation e, HashMap<String, String> properties) {
        String colour = this.convertAccount(accountLabel);
        properties.put("color", colour);
        properties.put("fontcolor", colour);
        properties.put("style", this.getRelationStyle(e));
        this.addRelationLabel(e, properties);
        return properties;
    }

    public void addRelationLabel(Relation e0, HashMap<String, String> properties) {
        String role;
        String label = null;
        if (!(e0 instanceof Influence)) {
            return;
        }
        Influence e = (Influence)e0;
        List type = this.of.getType((HasOther)e);
        if (type != null && !type.isEmpty()) {
            label = ((Type)type.get(0)).getValue().toString();
        } else if (this.getRelationPrintRole((Relation)e) && (role = this.of.getRole((HasOther)e)) != null) {
            label = this.displayRole(role);
            properties.put("fontsize", "8");
        }
        if (label != null) {
            properties.put("label", this.convertRelationLabel(label));
            if (properties.get("fontsize") == null) {
                properties.put("fontsize", "10");
            }
        }
    }

    public String displayRole(String role) {
        return "(" + role + ")";
    }

    public String convertRelationLabel(String label) {
        return label.substring(label.indexOf("#") + 1, label.length());
    }

    public String convertAccount(String account) {
        String colour = this.accountColourMap.get(account);
        if (colour != null) {
            return colour;
        }
        return this.defaultAccountColor;
    }

    public String getRelationStyle(Relation edge) {
        String name = edge.getClass().getName();
        RelationStyleMapEntry style = this.edgeStyleMap.get(name);
        if (style != null) {
            return style.getStyle();
        }
        return this.defaultRelationStyle;
    }

    public boolean getRelationPrintRole(Relation edge) {
        String name = edge.getClass().getName();
        RelationStyleMapEntry style = this.edgeStyleMap.get(name);
        if (style != null) {
            Boolean flag = style.isPrintRole();
            if (flag == null) {
                return false;
            }
            return flag;
        }
        return false;
    }

    public String dotify(String name) {
        return "n" + name.replace('-', '_').replace('.', '_').replace('/', '_').replace(':', '_').replace('#', '_').replace('~', '_');
    }

    public void emitElement(QualifiedName name, HashMap<String, String> properties, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append("" + this.dotify(this.qualifiedNameToString(name)));
        this.emitProperties(sb, properties);
        out.println(sb.toString());
    }

    public void emitBlankNode(String bnid, HashMap<String, String> properties, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append(bnid);
        this.emitProperties(sb, properties);
        out.println(sb.toString());
    }

    public void emitRelation(String src, String dest, HashMap<String, String> properties, PrintStream out, boolean directional) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dotify(src));
        if (directional) {
            sb.append(" -> ");
        } else {
            sb.append(" -- ");
        }
        sb.append(this.dotify(dest));
        this.emitProperties(sb, properties);
        out.println(sb.toString());
    }

    public void emitProperties(StringBuffer sb, HashMap<String, String> properties) {
        sb.append(" [");
        boolean first = true;
        for (String key : properties.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            String value = properties.get(key);
            sb.append(key);
            if (value.startsWith("<")) {
                sb.append("=");
                sb.append(value);
                continue;
            }
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
        sb.append("]");
    }

    void prelude(Document doc, PrintStream out) {
        out.println("digraph \"" + this.name + "\" { size=\"16,12\"; rankdir=\"BT\"; ");
        if (this.layout != null) {
            out.println("layout=\"" + this.layout + "\"; ");
        }
    }

    void postlude(Document doc, PrintStream out) {
        out.println("}");
        out.close();
    }

    void prelude(Bundle doc, PrintStream out) {
        out.println("subgraph cluster" + this.dotify(this.qualifiedNameToString(doc.getId())) + " { ");
        out.println("  label=\"" + this.localnameToString(doc.getId()) + "\";");
        out.println("  URL=\"" + this.qualifiedNameToString(doc.getId()) + "\";");
    }

    void postlude(Bundle doc, PrintStream out) {
        out.println("}");
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public static enum Config {
        DEFAULT,
        ROLE,
        ROLE_NO_LABEL;

    }
}

