/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.btree;

import info.aduna.io.ByteArrayUtil;
import info.aduna.io.NioFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.openrdf.sail.nativerdf.btree.BTree;

class AllocatedNodesList {
    private static final byte[] MAGIC_NUMBER = new byte[]{97, 110, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final int HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final BTree btree;
    private final NioFile nioFile;
    private BitSet allocatedNodes;
    private boolean needsSync = false;

    public AllocatedNodesList(File allocNodesFile, BTree btree) throws IOException {
        if (allocNodesFile == null) {
            throw new IllegalArgumentException("allocNodesFile must not be null");
        }
        if (btree == null) {
            throw new IllegalArgumentException("btree muts not be null");
        }
        this.nioFile = new NioFile(allocNodesFile);
        this.btree = btree;
    }

    public File getFile() {
        return this.nioFile.getFile();
    }

    public synchronized void close() throws IOException {
        this.close(true);
    }

    public synchronized boolean delete() throws IOException {
        this.close(false);
        return this.nioFile.delete();
    }

    public synchronized void close(boolean syncChanges) throws IOException {
        if (syncChanges) {
            this.sync();
        }
        this.allocatedNodes = null;
        this.needsSync = false;
        this.nioFile.close();
    }

    public synchronized void sync() throws IOException {
        if (this.needsSync) {
            BitSet bitSet = this.allocatedNodes;
            int bitSetLength = this.allocatedNodes.length();
            if (bitSetLength < this.allocatedNodes.size()) {
                bitSet = this.allocatedNodes.get(0, bitSetLength);
            }
            byte[] data = ByteArrayUtil.toByteArray((BitSet)bitSet);
            this.nioFile.truncate((long)(HEADER_LENGTH + data.length));
            this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
            this.nioFile.writeByte((byte)1, (long)MAGIC_NUMBER.length);
            this.nioFile.writeBytes(data, (long)HEADER_LENGTH);
            this.needsSync = false;
        }
    }

    private void scheduleSync() throws IOException {
        if (!this.needsSync) {
            this.nioFile.truncate(0L);
            this.needsSync = true;
        }
    }

    public synchronized void clear() throws IOException {
        if (this.allocatedNodes != null) {
            this.allocatedNodes.clear();
        } else {
            this.allocatedNodes = new BitSet();
        }
        this.scheduleSync();
    }

    public synchronized int allocateNode() throws IOException {
        this.initAllocatedNodes();
        int newNodeID = this.allocatedNodes.nextClearBit(1);
        this.allocatedNodes.set(newNodeID);
        this.scheduleSync();
        return newNodeID;
    }

    public synchronized void freeNode(int nodeID) throws IOException {
        this.initAllocatedNodes();
        this.allocatedNodes.clear(nodeID);
        this.scheduleSync();
    }

    public synchronized int getMaxNodeID() throws IOException {
        this.initAllocatedNodes();
        return Math.max(0, this.allocatedNodes.length() - 1);
    }

    public synchronized int getNodeCount() throws IOException {
        this.initAllocatedNodes();
        return this.allocatedNodes.cardinality();
    }

    private void initAllocatedNodes() throws IOException {
        if (this.allocatedNodes == null) {
            if (this.nioFile.size() > 0L) {
                this.loadAllocatedNodesInfo();
            } else {
                this.crawlAllocatedNodes();
            }
        }
    }

    private void loadAllocatedNodesInfo() throws IOException {
        byte[] data;
        if (this.nioFile.size() >= (long)HEADER_LENGTH && Arrays.equals(MAGIC_NUMBER, this.nioFile.readBytes(0L, MAGIC_NUMBER.length))) {
            byte version = this.nioFile.readByte((long)MAGIC_NUMBER.length);
            if (version > 1) {
                throw new IOException("Unable to read allocated nodes file; it uses a newer file format");
            }
            if (version != 1) {
                throw new IOException("Unable to read allocated nodes file; invalid file format version: " + version);
            }
            data = this.nioFile.readBytes((long)HEADER_LENGTH, (int)(this.nioFile.size() - (long)HEADER_LENGTH));
        } else {
            data = this.nioFile.readBytes(0L, (int)this.nioFile.size());
            this.scheduleSync();
        }
        this.allocatedNodes = ByteArrayUtil.toBitSet((byte[])data);
    }

    private void crawlAllocatedNodes() throws IOException {
        this.allocatedNodes = new BitSet();
        BTree.Node rootNode = this.btree.readRootNode();
        if (rootNode != null) {
            this.crawlAllocatedNodes(rootNode);
        }
        this.scheduleSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawlAllocatedNodes(BTree.Node node) throws IOException {
        try {
            this.allocatedNodes.set(node.getID());
            if (!node.isLeaf()) {
                for (int i = 0; i < node.getValueCount() + 1; ++i) {
                    this.crawlAllocatedNodes(node.getChildNode(i));
                }
            }
        }
        finally {
            node.release();
        }
    }
}

