/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.xml.Document;
import org.openprovenance.prov.xml.ProvUtilities;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ProvDeserialiser {
    static ProvUtilities utils = new ProvUtilities();
    protected static JAXBContext jc;
    private static ThreadLocal<ProvDeserialiser> threadDeserialiser;

    public ProvDeserialiser() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)"org.openprovenance.prov.xml");
        }
    }

    public ProvDeserialiser(String packageList) throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)packageList);
        }
    }

    public static ProvDeserialiser getThreadProvDeserialiser() {
        return threadDeserialiser.get();
    }

    public Document deserialiseDocument(File serialised) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        Object root = u.unmarshal(serialised);
        Document res = (Document)((JAXBElement)root).getValue();
        this.updateNamespaces(res);
        return res;
    }

    public void updateNamespaces(Document document) {
        Namespace rootNamespace = Namespace.gatherNamespaces((org.openprovenance.prov.model.Document)document);
        document.setNamespace(rootNamespace);
        for (Bundle bu : utils.getBundle(document)) {
            Namespace ns = bu.getNamespace();
            if (ns != null) {
                ns.setParent(rootNamespace);
                continue;
            }
            ns = new Namespace();
            ns.setParent(rootNamespace);
            bu.setNamespace(ns);
        }
    }

    public Document deserialiseDocument(InputStream is) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        Object root = u.unmarshal(is);
        Document res = (Document)((JAXBElement)root).getValue();
        this.updateNamespaces(res);
        return res;
    }

    public Document validateDocument(String[] schemaFiles, File serialised) throws JAXBException, SAXException, IOException {
        return this.validateDocument(schemaFiles, serialised, true);
    }

    public Document validateDocument(String[] schemaFiles, File serialised, boolean withCurie) throws JAXBException, SAXException, IOException {
        int schemaCount;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] sources = new Source[2 + schemaFiles.length];
        if (withCurie) {
            schemaCount = 3;
            sources = new Source[schemaCount + schemaFiles.length];
            sources[0] = new StreamSource(this.getClass().getResourceAsStream("/curie.xsd"));
            sources[1] = new StreamSource(this.getClass().getResourceAsStream("/xml.xsd"));
            sources[2] = new StreamSource(this.getClass().getResourceAsStream("/prov-20130307.xsd"));
        } else {
            schemaCount = 3;
            sources = new Source[schemaCount + schemaFiles.length];
            sources[0] = new StreamSource(this.getClass().getResourceAsStream("/curie.xsd"));
            sources[1] = new StreamSource(this.getClass().getResourceAsStream("/xml.xsd"));
            sources[2] = new StreamSource(this.getClass().getResourceAsStream("/prov-20130307.xsd"));
        }
        int i = 0;
        for (String schemaFile : schemaFiles) {
            sources[schemaCount + i] = new StreamSource(new File(schemaFile));
            ++i;
        }
        Schema schema = sf.newSchema(sources);
        Unmarshaller u = jc.createUnmarshaller();
        u.setSchema(schema);
        Object root = u.unmarshal(serialised);
        Document res = (Document)((JAXBElement)root).getValue();
        return res;
    }

    public Document validateDocumentNew(String[] schemaFiles, File serialised) throws JAXBException, SAXException, IOException {
        int schemaCount = 2;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] sources = new Source[schemaCount + schemaFiles.length];
        sources = new Source[schemaCount + schemaFiles.length];
        sources[0] = new StreamSource(this.getClass().getResourceAsStream("/w3c/xml.xsd"));
        sources[1] = new StreamSource(this.getClass().getResourceAsStream("/w3c/prov-single.xsd"));
        int i = 0;
        for (String schemaFile : schemaFiles) {
            sources[schemaCount + i] = new StreamSource(new File(schemaFile));
            ++i;
        }
        Schema schema = sf.newSchema(sources);
        Unmarshaller u = jc.createUnmarshaller();
        u.setSchema(schema);
        Object root = u.unmarshal(serialised);
        Document res = (Document)((JAXBElement)root).getValue();
        return res;
    }

    public static void main(String[] args) {
        ProvDeserialiser deserial = ProvDeserialiser.getThreadProvDeserialiser();
        if (args == null || args.length == 0) {
            System.out.println("Usage: opmxml-validate <filename> {schemaFiles}*");
            return;
        }
        File f = new File(args[0]);
        String[] schemas = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            schemas[i - 1] = args[i];
        }
        try {
            deserial.validateDocument(schemas, f);
            System.out.println(args[0] + " IS a valid OPM graph");
            return;
        }
        catch (JAXBException je) {
            je.printStackTrace();
            System.out.println(args[0] + " IS NOT a valid OPM graph");
        }
        catch (SAXException je) {
            je.printStackTrace();
            System.out.println(args[0] + " IS NOT a valid OPM graph");
        }
        catch (IOException io) {
            io.printStackTrace();
            System.out.println(args[0] + " IS NOT a valid OPM graph");
        }
    }

    static {
        threadDeserialiser = new ThreadLocal<ProvDeserialiser>(){

            @Override
            protected synchronized ProvDeserialiser initialValue() {
                try {
                    return new ProvDeserialiser();
                }
                catch (JAXBException jxb) {
                    throw new RuntimeException("ProvDeserialiser: deserialiser init failure()");
                }
            }
        };
    }

    class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }

    class ResourceResolver
    implements LSResourceResolver {
        ResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            System.out.println("resolveResource " + type + "\n" + namespaceURI + "\n" + publicId + "\n" + systemId + "\n" + baseURI);
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("/w3c/" + systemId);
            return new Input(publicId, systemId, resourceAsStream);
        }
    }
}

