/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeFactory;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.ObjectFactory;
import org.openprovenance.prov.xml.Key;
import org.openprovenance.prov.xml.Label;
import org.openprovenance.prov.xml.Location;
import org.openprovenance.prov.xml.ObjectFactory2;
import org.openprovenance.prov.xml.Other;
import org.openprovenance.prov.xml.ProvSerialiser;
import org.openprovenance.prov.xml.QualifiedName;

public class ProvFactory
extends org.openprovenance.prov.model.ProvFactory {
    private static String fileName = "toolbox.properties";
    private static final ProvFactory oFactory = new ProvFactory();
    public static final String packageList = "org.openprovenance.prov.xml";
    private static final String toolboxVersion = ProvFactory.getPropertiesFromClasspath(fileName).getProperty("toolbox.version");
    protected DatatypeFactory dataFactory;

    public static ProvFactory getFactory() {
        return oFactory;
    }

    private static Properties getPropertiesFromClasspath(String propFileName) {
        Properties props = new Properties();
        InputStream inputStream = ProvFactory.class.getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
        }
        catch (IOException ee) {
            return null;
        }
        return props;
    }

    public static String printURI(URI u) {
        return u.toString();
    }

    public ProvFactory() {
        super((ObjectFactory)new ObjectFactory2());
        this.init();
    }

    public ProvFactory(ObjectFactory2 of) {
        super((ObjectFactory)of);
        this.init();
    }

    public String getVersion() {
        return toolboxVersion;
    }

    public Attribute newAttribute(Attribute.AttributeKind kind, Object value, org.openprovenance.prov.model.QualifiedName type) {
        switch (kind) {
            case PROV_LOCATION: {
                return this.newLocation(value, type);
            }
            case OTHER: {
                throw new UnsupportedOperationException();
            }
            case PROV_LABEL: {
                return this.newLabel(value, type);
            }
            case PROV_ROLE: {
                return this.newRole(value, type);
            }
            case PROV_TYPE: {
                return this.newType(value, type);
            }
            case PROV_VALUE: {
                return this.newValue(value, type);
            }
            case PROV_KEY: {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public Attribute newAttribute(org.openprovenance.prov.model.QualifiedName elementName, Object value, org.openprovenance.prov.model.QualifiedName type) {
        if (elementName.equals((Object)this.getName().PROV_LOCATION)) {
            return this.newLocation(value, type);
        }
        if (elementName.equals((Object)this.getName().PROV_TYPE)) {
            return this.newType(value, type);
        }
        if (elementName.equals((Object)this.getName().PROV_VALUE)) {
            return this.newValue(value, type);
        }
        if (elementName.equals((Object)this.getName().PROV_ROLE)) {
            return this.newRole(value, type);
        }
        if (elementName.equals((Object)this.getName().PROV_LABEL)) {
            return this.newLabel(value, type);
        }
        if (elementName.equals((Object)this.getName().PROV_KEY)) {
            return this.newKey(value, type);
        }
        return this.newOther(elementName, value, type);
    }

    public Key newKey(Object value, org.openprovenance.prov.model.QualifiedName type) {
        Key key = new Key();
        key.type = type;
        key.setValueFromObject(value);
        return key;
    }

    public Label newLabel(Object value, org.openprovenance.prov.model.QualifiedName type) {
        Label res = new Label();
        res.type = type;
        res.setValueFromObject(value);
        return res;
    }

    public Location newLocation(Object value, org.openprovenance.prov.model.QualifiedName type) {
        Location loc = new Location();
        loc.type = type;
        loc.setValueFromObject(value);
        return loc;
    }

    public Other newOther(org.openprovenance.prov.model.QualifiedName elementName, Object value, org.openprovenance.prov.model.QualifiedName type) {
        Other res = new Other();
        res.type = type;
        res.setValueFromObject(value);
        res.setElementName(elementName);
        return res;
    }

    public org.openprovenance.prov.model.QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return new QualifiedName(namespace, local, prefix);
    }

    public org.openprovenance.prov.model.ProvSerialiser getSerializer() throws JAXBException {
        return new ProvSerialiser();
    }
}

