/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.xml;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.xml.ActedOnBehalfOf;
import org.openprovenance.prov.xml.Activity;
import org.openprovenance.prov.xml.Agent;
import org.openprovenance.prov.xml.AlternateOf;
import org.openprovenance.prov.xml.Bundle;
import org.openprovenance.prov.xml.Entity;
import org.openprovenance.prov.xml.HadMember;
import org.openprovenance.prov.xml.MentionOf;
import org.openprovenance.prov.xml.ProvFactory;
import org.openprovenance.prov.xml.SpecializationOf;
import org.openprovenance.prov.xml.Used;
import org.openprovenance.prov.xml.WasAssociatedWith;
import org.openprovenance.prov.xml.WasAttributedTo;
import org.openprovenance.prov.xml.WasDerivedFrom;
import org.openprovenance.prov.xml.WasEndedBy;
import org.openprovenance.prov.xml.WasGeneratedBy;
import org.openprovenance.prov.xml.WasInfluencedBy;
import org.openprovenance.prov.xml.WasInformedBy;
import org.openprovenance.prov.xml.WasInvalidatedBy;
import org.openprovenance.prov.xml.WasStartedBy;

public class ProvUtilities
extends org.openprovenance.prov.model.ProvUtilities {
    private ProvFactory p = new ProvFactory();
    private static final Hashtable<Class, String[]> fields = new Hashtable();
    private static final Hashtable<Class, Class[]> types = new Hashtable();

    public MentionOf getMentionForRemoteEntity(Bundle local, Entity remoteEntity, Bundle remote) {
        return this.getMentionForLocalEntity(local.getStatement(), remoteEntity, remote);
    }

    MentionOf getMentionForRemoteEntity(List<Object> objects, Entity remoteEntity, Bundle remote) {
        for (Object o : objects) {
            if (!(o instanceof MentionOf)) continue;
            MentionOf ctxt = (MentionOf)o;
            QualifiedName id1 = remoteEntity.getId();
            QualifiedName id2 = remote.getId();
            if (!ctxt.getGeneralEntity().equals((Object)id1) || !ctxt.getBundle().equals((Object)id2)) continue;
            return ctxt;
        }
        return null;
    }

    public MentionOf getMentionForLocalEntity(Bundle local, Entity localEntity, Bundle remote) {
        return this.getMentionForLocalEntity(local.getStatement(), localEntity, remote);
    }

    MentionOf getMentionForLocalEntity(List<Statement> records, Entity localEntity, Bundle remote) {
        for (Statement o : records) {
            if (!(o instanceof MentionOf)) continue;
            MentionOf ctxt = (MentionOf)o;
            QualifiedName id1 = localEntity.getId();
            QualifiedName id2 = remote.getId();
            if (!ctxt.getSpecificEntity().equals((Object)id1) || !ctxt.getBundle().equals((Object)id2)) continue;
            return ctxt;
        }
        return null;
    }

    public String toURI(QName qname) {
        return qname.getNamespaceURI() + qname.getLocalPart();
    }

    public static Hashtable<Class, Class[]> getTypes() {
        return types;
    }

    public Method getterMethod(Statement o, int i) throws NoSuchMethodException {
        String field = fields.get(o.getClass())[i];
        Method method = o.getClass().getDeclaredMethod("get" + field, new Class[0]);
        return method;
    }

    public static String[] getTypes(Object o) {
        return fields.get(o.getClass());
    }

    public Method setterMethod(Statement o, int i, Object val) throws NoSuchMethodException {
        String field = fields.get(o.getClass())[i];
        Method method = o.getClass().getDeclaredMethod("set" + field, types.get(o.getClass())[i]);
        return method;
    }

    public static void putFields(Class cl, String[] str) {
        fields.put(cl, str);
    }

    public static void putTypes(Class cl, Class[] str) {
        types.put(cl, str);
    }

    public <T> T addAttributes(T from, T to) {
        if (from instanceof Used) {
            return (T)this.p.addAttributes((Used)from, (Used)to);
        }
        if (from instanceof WasStartedBy) {
            return (T)this.p.addAttributes((WasStartedBy)from, (WasStartedBy)to);
        }
        if (from instanceof WasEndedBy) {
            return (T)this.p.addAttributes((WasEndedBy)from, (WasEndedBy)to);
        }
        if (from instanceof WasGeneratedBy) {
            return (T)this.p.addAttributes((WasGeneratedBy)from, (WasGeneratedBy)to);
        }
        if (from instanceof WasDerivedFrom) {
            return (T)this.p.addAttributes((WasDerivedFrom)from, (WasDerivedFrom)to);
        }
        if (from instanceof WasAssociatedWith) {
            return (T)this.p.addAttributes((WasAssociatedWith)from, (WasAssociatedWith)to);
        }
        if (from instanceof WasInvalidatedBy) {
            return (T)this.p.addAttributes((WasInvalidatedBy)from, (WasInvalidatedBy)to);
        }
        if (from instanceof WasAttributedTo) {
            return (T)this.p.addAttributes((WasAttributedTo)from, (WasAttributedTo)to);
        }
        if (from instanceof WasInformedBy) {
            return (T)this.p.addAttributes((WasInformedBy)from, (WasInformedBy)to);
        }
        if (from instanceof WasInfluencedBy) {
            return (T)this.p.addAttributes((WasInfluencedBy)from, (WasInfluencedBy)to);
        }
        if (from instanceof ActedOnBehalfOf) {
            return (T)this.p.addAttributes((ActedOnBehalfOf)from, (ActedOnBehalfOf)to);
        }
        System.out.println("addAttributes Unknown relation " + from);
        throw new UnsupportedOperationException();
    }

    public int getFirstTimeIndex(Statement o) {
        String[] types = ProvUtilities.getTypes(o);
        if (o instanceof Activity) {
            return types.length - 3;
        }
        if (this.hasNoTime(o)) {
            if (o instanceof HasOther) {
                return types.length - 1;
            }
            return types.length;
        }
        return types.length - 2;
    }

    public int getLastIndex(Object o) {
        String[] types = ProvUtilities.getTypes(o);
        return types.length - 1;
    }

    static {
        fields.put(Activity.class, new String[]{"Id", "StartTime", "EndTime", "Other"});
        fields.put(Entity.class, new String[]{"Id", "Other"});
        fields.put(Agent.class, new String[]{"Id", "Other"});
        fields.put(Used.class, new String[]{"Id", "Activity", "Entity", "Time", "Other"});
        fields.put(WasGeneratedBy.class, new String[]{"Id", "Entity", "Activity", "Time", "Other"});
        fields.put(WasInvalidatedBy.class, new String[]{"Id", "Entity", "Activity", "Time", "Other"});
        fields.put(WasStartedBy.class, new String[]{"Id", "Activity", "Trigger", "Starter", "Time", "Other"});
        fields.put(WasEndedBy.class, new String[]{"Id", "Activity", "Trigger", "Ender", "Time", "Other"});
        fields.put(WasInformedBy.class, new String[]{"Id", "Informed", "Informant", "Other"});
        fields.put(WasDerivedFrom.class, new String[]{"Id", "GeneratedEntity", "UsedEntity", "Activity", "Generation", "Usage", "Other"});
        fields.put(WasInfluencedBy.class, new String[]{"Id", "Influencee", "Influencer", "Others"});
        fields.put(WasAttributedTo.class, new String[]{"Id", "Entity", "Agent", "Other"});
        fields.put(WasAssociatedWith.class, new String[]{"Id", "Activity", "Agent", "Plan", "Other"});
        fields.put(ActedOnBehalfOf.class, new String[]{"Id", "Delegate", "Responsible", "Activity", "Others"});
        fields.put(SpecializationOf.class, new String[]{"SpecificEntity", "GeneralEntity"});
        fields.put(AlternateOf.class, new String[]{"Alternate2", "Alternate2"});
        fields.put(HadMember.class, new String[]{"Collection", "Entity"});
        fields.put(MentionOf.class, new String[]{"Id", "SpecificEntity", "GeneralEntity", "Bundle"});
        types.put(Entity.class, new Class[]{QualifiedName.class, Object.class});
        types.put(Agent.class, new Class[]{QualifiedName.class, Object.class});
        types.put(Activity.class, new Class[]{QualifiedName.class, XMLGregorianCalendar.class, XMLGregorianCalendar.class, Object.class});
        types.put(Used.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, XMLGregorianCalendar.class, Object.class});
        types.put(WasGeneratedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, XMLGregorianCalendar.class, Object.class});
        types.put(WasInvalidatedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, XMLGregorianCalendar.class, Object.class});
        types.put(WasStartedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, XMLGregorianCalendar.class, Object.class});
        types.put(WasEndedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, XMLGregorianCalendar.class, Object.class});
        types.put(WasInformedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(WasDerivedFrom.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(WasInfluencedBy.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(WasAttributedTo.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(WasAssociatedWith.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(ActedOnBehalfOf.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class, Object.class});
        types.put(SpecializationOf.class, new Class[]{QualifiedName.class, QualifiedName.class});
        types.put(MentionOf.class, new Class[]{QualifiedName.class, QualifiedName.class, QualifiedName.class, QualifiedName.class});
        types.put(AlternateOf.class, new Class[]{QualifiedName.class, QualifiedName.class});
        types.put(HadMember.class, new Class[]{QualifiedName.class, Object.class});
    }
}

