/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf;

import java.util.Collection;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.rdf.GraphBuilder;
import org.openprovenance.prov.rdf.Ontology;

public class RdfConstructor<RESOURCE, LITERAL, STATEMENT>
implements ModelConstructor {
    private Namespace namespace;
    final GraphBuilder<RESOURCE, LITERAL, STATEMENT> gb;
    final Ontology onto;
    final ProvFactory pFactory;
    final Name name;

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace ns) {
        this.namespace = ns;
    }

    public RdfConstructor(GraphBuilder<RESOURCE, LITERAL, STATEMENT> gb, ProvFactory pFactory) {
        this.onto = new Ontology(pFactory);
        this.gb = gb;
        this.pFactory = pFactory;
        this.name = pFactory.getName();
    }

    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        this.assertType(id, this.onto.QNAME_PROVO_Entity);
        this.processAttributes(id, attributes);
        return null;
    }

    public Activity newActivity(QualifiedName id, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        this.assertType(id, this.onto.QNAME_PROVO_Activity);
        if (startTime != null) {
            this.gb.assertStatement(this.gb.createDataProperty(id, this.onto.QNAME_PROVO_startedAtTime, this.newLiteral(startTime)));
        }
        if (endTime != null) {
            this.gb.assertStatement(this.gb.createDataProperty(id, this.onto.QNAME_PROVO_endedAtTime, this.newLiteral(endTime)));
        }
        this.processAttributes(id, attributes);
        return null;
    }

    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        this.assertType(id, this.onto.QNAME_PROVO_Agent);
        this.processAttributes(id, attributes);
        return null;
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        QualifiedName u = this.addInfluence(id, activity, entity, time, null, false, attributes, this.onto.QNAME_PROVO_Usage);
        return null;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        QualifiedName g = this.addInfluence(id, entity, activity, time, null, false, attributes, this.onto.QNAME_PROVO_Generation);
        return null;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        QualifiedName inv = this.addInfluence(id, entity, activity, time, null, false, attributes, this.onto.QNAME_PROVO_Invalidation);
        return null;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        QualifiedName s = this.addInfluence(id, activity, trigger, time, starter, false, attributes, this.onto.QNAME_PROVO_Start);
        return null;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        QualifiedName e = this.addInfluence(id, activity, trigger, time, ender, false, attributes, this.onto.QNAME_PROVO_End);
        return null;
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName entity2, QualifiedName entity1, QualifiedName activity, QualifiedName generation, QualifiedName usage, Collection<Attribute> attributes) {
        int knownSubtypes = 0;
        QualifiedName der = id;
        if (ProvUtilities.hasType((QualifiedName)this.onto.QNAME_PROVO_Revision, attributes)) {
            ++knownSubtypes;
            der = this.addInfluence(der, entity2, entity1, null, activity, false, attributes, this.onto.QNAME_PROVO_Revision);
        }
        if (ProvUtilities.hasType((QualifiedName)this.onto.QNAME_PROVO_Quotation, attributes)) {
            ++knownSubtypes;
            der = this.addInfluence(der, entity2, entity1, null, activity, false, attributes, this.onto.QNAME_PROVO_Quotation);
        }
        if (ProvUtilities.hasType((QualifiedName)this.onto.QNAME_PROVO_PrimarySource, attributes)) {
            ++knownSubtypes;
            der = this.addInfluence(der, entity2, entity1, null, activity, false, attributes, this.onto.QNAME_PROVO_PrimarySource);
        }
        if (knownSubtypes == 0) {
            der = this.addInfluence(der, entity2, entity1, null, activity, false, attributes, this.onto.QNAME_PROVO_Derivation);
        }
        if (der != null) {
            if (generation != null) {
                this.gb.assertStatement(this.gb.createObjectProperty(der, this.onto.QNAME_PROVO_hadGeneration, generation));
            }
            if (usage != null) {
                this.gb.assertStatement(this.gb.createObjectProperty(der, this.onto.QNAME_PROVO_hadUsage, usage));
            }
        }
        return null;
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        QualifiedName d = this.addInfluence(id, a, ag, null, plan, false, attributes, this.onto.QNAME_PROVO_Association);
        return null;
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName e, QualifiedName ag, Collection<Attribute> attributes) {
        QualifiedName a = this.addInfluence(id, e, ag, null, null, false, attributes, this.onto.QNAME_PROVO_Attribution);
        return null;
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName agent2, QualifiedName agent1, QualifiedName a, Collection<Attribute> attributes) {
        QualifiedName d = this.addInfluence(id, agent2, agent1, null, a, false, attributes, this.onto.QNAME_PROVO_Delegation);
        return null;
    }

    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName activity2, QualifiedName activity1, Collection<Attribute> attributes) {
        QualifiedName com = this.addInfluence(id, activity2, activity1, null, null, false, attributes, this.onto.QNAME_PROVO_Communication);
        return null;
    }

    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName qn2, QualifiedName qn1, Collection<Attribute> attributes) {
        QualifiedName u = this.addInfluence(id, qn2, qn1, null, null, false, attributes, this.onto.QNAME_PROVO_Influence);
        return null;
    }

    public AlternateOf newAlternateOf(QualifiedName entity2, QualifiedName entity1) {
        if (entity2 != null && entity1 != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(entity2, this.onto.QNAME_PROVO_alternateOf, entity1));
        }
        return null;
    }

    public SpecializationOf newSpecializationOf(QualifiedName entity2, QualifiedName entity1) {
        if (entity2 != null && entity1 != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(entity2, this.onto.QNAME_PROVO_specializationOf, entity1));
        }
        return null;
    }

    public MentionOf newMentionOf(QualifiedName entity2, QualifiedName entity1, QualifiedName b) {
        if (entity2 != null && entity1 != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(entity2, this.onto.QNAME_PROVO_mentionOf, entity1));
        }
        if (entity2 != null && b != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(entity2, this.onto.QNAME_PROVO_asInBundle, b));
        }
        return null;
    }

    public HadMember newHadMember(QualifiedName collection, Collection<QualifiedName> ll) {
        for (QualifiedName entity : ll) {
            this.gb.assertStatement(this.gb.createObjectProperty(collection, this.onto.QNAME_PROVO_hadMember, entity));
        }
        return null;
    }

    public Document newDocument(Namespace namespaces, Collection<Statement> statements, Collection<Bundle> bundles) {
        return null;
    }

    public Bundle newNamedBundle(QualifiedName id, Namespace namespaces, Collection<Statement> statements) {
        return null;
    }

    public void startDocument(Namespace namespaces) {
        if (namespaces != null) {
            // empty if block
        }
        this.gb.setContext();
    }

    public void startBundle(QualifiedName bundleId, Namespace namespaces) {
        if (bundleId != null) {
            this.gb.setContext(this.gb.qualifiedNameToURI(bundleId));
        }
    }

    public void processAttributes(QualifiedName q, Collection<Attribute> attributes) {
        RESOURCE r = this.gb.qualifiedNameToResource(q);
        if (attributes != null) {
            for (Attribute attr : attributes) {
                String value;
                Object lit = null;
                QualifiedName type = attr.getType();
                QualifiedName pred = this.onto.convertToRdf(attr.getElementName());
                if (attr.getValue() instanceof LangString) {
                    LangString iString = (LangString)attr.getValue();
                    value = iString.getValue();
                    lit = this.gb.newLiteral(value, iString.getLang());
                    this.gb.assertStatement(this.gb.createDataProperty(r, pred, lit));
                    continue;
                }
                if (attr.getValue() instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)attr.getValue();
                    String qnAsString = qn.getPrefix() == null || qn.getPrefix().equals("") ? qn.getLocalPart() : qn.getPrefix() + ":" + qn.getLocalPart();
                    this.gb.assertStatement(this.gb.createObjectProperty(r, pred, qn));
                    continue;
                }
                value = attr.getValue().toString();
                lit = this.gb.newLiteral(value, type);
                this.gb.assertStatement(this.gb.createDataProperty(r, pred, lit));
            }
        }
    }

    public QualifiedName addInfluence(QualifiedName infl, QualifiedName subject, QualifiedName object, XMLGregorianCalendar time, QualifiedName other, boolean someOther, Collection<Attribute> attributes, QualifiedName qualifiedClass) {
        if (infl != null || time != null || other != null || someOther || attributes != null && !attributes.isEmpty()) {
            infl = this.assertType(infl, qualifiedClass);
            if (object != null) {
                this.assertInfluencer(infl, object, qualifiedClass);
            }
            if (subject != null) {
                this.assertQualifiedInfluence(subject, infl, qualifiedClass);
            }
            if (time != null) {
                this.assertAtTime(infl, time);
            }
            if (other != null) {
                this.asserterOther(infl, other, qualifiedClass);
            }
            this.processAttributes(infl, attributes);
        }
        if (this.binaryProp(infl, subject) && object != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(subject, this.onto.unqualifiedTable.get(qualifiedClass), object));
        }
        return infl;
    }

    public QualifiedName addInfluenceDELETEME(QualifiedName infl, QualifiedName subject, QualifiedName object, XMLGregorianCalendar time, QualifiedName other, boolean someOther, Collection<Attribute> attributes, QualifiedName qualifiedClass) {
        if (infl != null || time != null || other != null || someOther || attributes != null && !attributes.isEmpty()) {
            infl = this.assertType(infl, qualifiedClass);
            if (object != null) {
                this.assertInfluencer(infl, object, qualifiedClass);
            }
            if (subject != null) {
                this.assertQualifiedInfluence(subject, infl, qualifiedClass);
            }
            if (time != null) {
                this.assertAtTime(infl, time);
            }
            if (other != null) {
                this.asserterOther(infl, other, qualifiedClass);
            }
            this.processAttributes(infl, attributes);
        }
        if (this.binaryProp(infl, subject) && object != null) {
            this.gb.assertStatement(this.gb.createObjectProperty(subject, this.onto.unqualifiedTable.get(qualifiedClass), object));
        }
        return infl;
    }

    public void asserterOther(QualifiedName subject, QualifiedName other, QualifiedName qualifiedClass) {
        this.gb.assertStatement(this.gb.createObjectProperty(subject, this.onto.otherTable.get(qualifiedClass), other));
    }

    public void assertAtTime(QualifiedName subject, XMLGregorianCalendar time) {
        this.gb.assertStatement(this.gb.createDataProperty(subject, this.onto.QNAME_PROVO_atTime, this.newLiteral(time)));
    }

    private LITERAL newLiteral(XMLGregorianCalendar time) {
        return this.gb.newLiteral(time.toString(), this.name.QNAME_XSD_HASH_DATETIME);
    }

    public void assertQualifiedInfluence(QualifiedName subject, QualifiedName infl, QualifiedName qualifiedClass) {
        this.gb.assertStatement(this.gb.createObjectProperty(subject, this.onto.qualifiedInfluenceTable.get(qualifiedClass), infl));
    }

    public void assertInfluencer(QualifiedName infl, QualifiedName object, QualifiedName qualifiedClass) {
        this.gb.assertStatement(this.gb.createObjectProperty(infl, this.onto.influencerTable.get(qualifiedClass), object));
    }

    public QualifiedName assertType(QualifiedName infl, QualifiedName qualifiedClass) {
        if (infl == null) {
            infl = this.gb.newBlankName();
        }
        this.gb.assertStatement(this.gb.createObjectProperty(infl, this.onto.QNAME_RDF_TYPE, qualifiedClass));
        return infl;
    }

    public Object convertExtension(Object name, Object id, Object args, Object dAttrs) {
        return null;
    }

    public Object convertInsertion(Object id, Object id2, Object id1, Object map, Object dAttrs) {
        throw new UnsupportedOperationException();
    }

    public Object convertEntry(Object o1, Object o2) {
        throw new UnsupportedOperationException();
    }

    public Object convertKeyEntitySet(List<Object> o) {
        throw new UnsupportedOperationException();
    }

    public Object convertRemoval(Object id, Object id2, Object id1, Object keys, Object dAttrs) {
        throw new UnsupportedOperationException();
    }

    public Object convertDictionaryMemberOf(Object id, Object id2, Object map, Object complete, Object dAttrs) {
        throw new UnsupportedOperationException();
    }

    public Object convertCollectionMemberOf(Object id, Object id2, Object map, Object complete, Object dAttrs) {
        throw new UnsupportedOperationException();
    }

    public Object convertKeys(List<Object> keys) {
        throw new UnsupportedOperationException();
    }

    public boolean binaryProp(Object id, Object subject) {
        return id == null && subject != null;
    }

    public DerivedByInsertionFrom newDerivedByInsertionFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Entry> keyEntitySet, Collection<Attribute> attributes) {
        QualifiedName der = this.addInfluence(id, after, before, null, null, true, attributes, this.onto.QNAME_PROVO_Insertion);
        for (Entry p : keyEntitySet) {
            QualifiedName thePair = this.gb.newBlankName();
            this.gb.assertStatement(this.gb.createObjectProperty(der, this.onto.QNAME_PROVO_insertedKeyEntityPair, thePair));
            LITERAL lit = this.valueToLiteral((TypedValue)p.getKey());
            this.gb.assertStatement(this.gb.createDataProperty(thePair, this.onto.QNAME_PROVO_pairKey, lit));
            this.gb.assertStatement(this.gb.createObjectProperty(thePair, this.onto.QNAME_PROVO_pairEntity, p.getEntity()));
        }
        return null;
    }

    private LITERAL valueToLiteral(TypedValue val) {
        LITERAL lit = null;
        if (val.getValue() instanceof QualifiedName) {
            String value = Namespace.qualifiedNameToStringWithNamespace((QualifiedName)((QualifiedName)val.getValue()));
            lit = this.gb.newLiteral(value, val.getType());
        } else if (val.getValue() instanceof LangString) {
            LangString iString = (LangString)val.getValue();
            lit = this.gb.newLiteral(iString.getValue(), iString.getLang());
        } else {
            String value = val.getValue().toString();
            lit = this.gb.newLiteral(value, val.getType());
        }
        return lit;
    }

    public DerivedByRemovalFrom newDerivedByRemovalFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Key> keys, Collection<Attribute> attributes) {
        QualifiedName der = this.addInfluence(id, after, before, null, null, true, attributes, this.onto.QNAME_PROVO_Removal);
        for (Key k : keys) {
            LITERAL lit = this.valueToLiteral((TypedValue)k);
            this.gb.assertStatement(this.gb.createDataProperty(der, this.onto.QNAME_PROVO_removedKey, lit));
        }
        return null;
    }

    public DictionaryMembership newDictionaryMembership(QualifiedName dict, List<Entry> keyEntitySet) {
        for (Entry p : keyEntitySet) {
            QualifiedName thePair = this.gb.newBlankName();
            this.gb.assertStatement(this.gb.createObjectProperty(dict, this.onto.QNAME_PROVO_hadDictionaryMember, thePair));
            LITERAL lit = this.valueToLiteral((TypedValue)p.getKey());
            this.gb.assertStatement(this.gb.createDataProperty(thePair, this.onto.QNAME_PROVO_pairKey, lit));
            this.gb.assertStatement(this.gb.createObjectProperty(thePair, this.onto.QNAME_PROVO_pairEntity, p.getEntity()));
        }
        return null;
    }

    public QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return null;
    }
}

