/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.rdf.RdfConverterException;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RDFXMLWriter;
import org.openrdf.rio.trig.TriGWriter;
import org.openrdf.rio.turtle.TurtleWriter;

public class RepositoryHelper {
    public void setPrefixes(RDFHandler serialiser, Map<String, String> prefixes) throws RDFHandlerException {
        serialiser.handleNamespace("prov", "http://www.w3.org/ns/prov#");
        for (String key : prefixes.keySet()) {
            serialiser.handleNamespace(key, prefixes.get(key));
        }
    }

    public void dumpToRDF(String file, ContextAwareRepository manager, RDFFormat format, Namespace namespace) {
        FileWriter writer;
        try {
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            throw new RdfConverterException("couldn't create file writer", e);
        }
        this.dumpToRDF(writer, manager, format, namespace);
    }

    public void dumpToRDF(Writer writer, ContextAwareRepository manager, RDFFormat format, Namespace namespace) {
        Map prefixes = namespace.getPrefixes();
        if (namespace.getDefaultNamespace() != null) {
            // empty if block
        }
        N3Writer serialiser = null;
        if (format.equals((Object)RDFFormat.N3)) {
            serialiser = new N3Writer(writer);
        } else if (format.equals((Object)RDFFormat.RDFXML)) {
            serialiser = new RDFXMLWriter(writer);
        } else if (format.equals((Object)RDFFormat.NTRIPLES)) {
            serialiser = new NTriplesWriter(writer);
        } else if (format.equals((Object)RDFFormat.TRIG)) {
            serialiser = new TriGWriter(writer);
        } else if (format.equals((Object)RDFFormat.TURTLE)) {
            serialiser = new TurtleWriter(writer);
        }
        try {
            this.setPrefixes((RDFHandler)serialiser, prefixes);
            manager.getConnection().export((RDFHandler)serialiser, new Resource[0]);
        }
        catch (RDFHandlerException e) {
            e.printStackTrace();
            throw new RdfConverterException("setting prefix failed", e);
        }
        catch (RepositoryException e) {
            throw new RdfConverterException("export failed", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RdfConverterException("writer closing failed", e);
            }
        }
    }

    public void readFromRDF(File file, String uri, ContextAwareRepository manager, RDFFormat format) throws Exception {
        manager.getConnection().add(file, uri, format, new Resource[0]);
    }
}

