/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf;

import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.rdf.GraphBuilder;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareRepository;

public class SesameGraphBuilder
implements GraphBuilder<Resource, LiteralImpl, Statement> {
    final ContextAwareRepository manager;
    private final ProvFactory pFactory;
    static int blankCounter = 0;
    private Resource currentContext = null;

    public SesameGraphBuilder(ContextAwareRepository manager, ProvFactory pFactory) {
        this.manager = manager;
        this.pFactory = pFactory;
    }

    @Override
    public void assertStatement(Statement stmnt) {
        try {
            if (this.currentContext == null) {
                this.manager.getConnection().add(stmnt, new Resource[0]);
            } else {
                this.manager.getConnection().add(stmnt, new Resource[]{this.currentContext});
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public Statement createDataProperty(Resource r, QualifiedName pred, LiteralImpl literalImpl) {
        return new StatementImpl(r, (URI)this.qualifiedNameToURI(pred), (Value)literalImpl);
    }

    @Override
    public Statement createDataProperty(QualifiedName subject, QualifiedName pred, LiteralImpl literalImpl) {
        return this.createDataProperty(this.qualifiedNameToResource(subject), pred, literalImpl);
    }

    @Override
    public Statement createObjectProperty(Resource r, QualifiedName pred, QualifiedName object) {
        return new StatementImpl(r, (URI)this.qualifiedNameToURI(pred), (Value)this.qualifiedNameToURI(object));
    }

    @Override
    public Statement createObjectProperty(QualifiedName subject, QualifiedName pred, QualifiedName object) {
        return new StatementImpl(this.qualifiedNameToResource(subject), (URI)this.qualifiedNameToURI(pred), (Value)this.qualifiedNameToResource(object));
    }

    @Override
    public URIImpl qualifiedNameToURI(QualifiedName qname) {
        if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return new URIImpl("http://www.w3.org/2001/XMLSchema#" + qname.getLocalPart());
        }
        return new URIImpl(qname.getNamespaceURI() + qname.getLocalPart());
    }

    @Override
    public Resource qualifiedNameToResource(QualifiedName qname) {
        if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return new URIImpl("http://www.w3.org/2001/XMLSchema#" + qname.getLocalPart());
        }
        if (this.isBlankName(qname)) {
            return new BNodeImpl(qname.getLocalPart());
        }
        return new URIImpl(qname.getNamespaceURI() + qname.getLocalPart());
    }

    boolean isBlankName(QualifiedName name) {
        return name.getNamespaceURI().equals("http://openprovenance.org/toolbox/") && name.getPrefix().equals("_");
    }

    @Override
    public QualifiedName newBlankName() {
        return this.newToolboxQName("blank" + ++blankCounter);
    }

    public QualifiedName newToolboxQName(String local) {
        return this.pFactory.newQualifiedName("http://openprovenance.org/toolbox/", local, "_");
    }

    @Override
    public void setContext() {
        this.currentContext = null;
    }

    @Override
    public void setContext(Resource uri) {
        this.currentContext = uri;
    }

    @Override
    public LiteralImpl newLiteral(String value, QualifiedName type) {
        return new LiteralImpl(value, (URI)this.qualifiedNameToURI(type));
    }

    @Override
    public LiteralImpl newLiteral(String value, String lang) {
        return new LiteralImpl(value, lang);
    }
}

