/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.rdf.collector.RdfCollector;
import org.openprovenance.prov.rdf.collector.Types;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;

public class QualifiedCollector
extends RdfCollector {
    public QualifiedCollector(ProvFactory pFactory, Ontology onto) {
        super(pFactory, onto);
    }

    private ArrayList<List<?>> permute(List<?> ... lists) {
        ArrayList output = new ArrayList();
        if (lists.length == 0) {
            output.add(new ArrayList());
            return output;
        }
        for (List<?> list : lists) {
            if (list.size() != 0) continue;
            list.add(null);
        }
        List<?> first = lists[0];
        List<?>[] rest = Arrays.copyOfRange(lists, 1, lists.length);
        for (Object x : first) {
            ArrayList<List<?>> permuted = this.permute(rest);
            for (List<?> tocombine : permuted) {
                ArrayList l = new ArrayList();
                l.add(x);
                l.addAll(tocombine);
                output.add(l);
            }
        }
        return output;
    }

    private List<QualifiedName> getSubjects(QualifiedName context, QualifiedName pred, QualifiedName object) {
        HashMap resources = (HashMap)this.collators.get(context);
        ArrayList<QualifiedName> subjects = new ArrayList<QualifiedName>();
        for (QualifiedName subject : resources.keySet()) {
            List statements = (List)resources.get(subject);
            for (Statement statement : statements) {
                QualifiedName valQ;
                QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
                Value value = statement.getObject();
                if (!pred.equals((Object)predQ) || !(value instanceof Resource) || !(valQ = this.convertResourceToQualifiedName((Resource)value)).equals((Object)object)) continue;
                subjects.add(subject);
            }
        }
        return subjects;
    }

    @Override
    protected void buildGraph() {
        super.buildGraph();
        for (QualifiedName contextQ : this.collators.keySet()) {
            HashMap collator = (HashMap)this.collators.get(contextQ);
            for (QualifiedName qname : collator.keySet()) {
                Types.ProvType[] types;
                block20: for (Types.ProvType type : types = this.getExplicitTypes(contextQ, qname)) {
                    switch (type) {
                        case GENERATION: {
                            this.createGeneration(contextQ, qname);
                            continue block20;
                        }
                        case USAGE: {
                            this.createUsage(contextQ, qname);
                            continue block20;
                        }
                        case ASSOCIATION: {
                            this.createAssociation(contextQ, qname);
                            continue block20;
                        }
                        case ATTRIBUTION: {
                            this.createAttribution(contextQ, qname);
                            continue block20;
                        }
                        case COMMUNICATION: {
                            this.createCommunication(contextQ, qname);
                            continue block20;
                        }
                        case DELEGATION: {
                            this.createDelegation(contextQ, qname);
                            continue block20;
                        }
                        case DERIVATION: {
                            this.createDerivation(contextQ, qname, this.onto.QNAME_PROVO_qualifiedDerivation);
                            continue block20;
                        }
                        case PRIMARYSOURCE: {
                            this.createPrimarySource(contextQ, qname);
                            continue block20;
                        }
                        case QUOTATION: {
                            this.createQuotation(contextQ, qname);
                            continue block20;
                        }
                        case REVISION: {
                            this.createRevision(contextQ, qname);
                            continue block20;
                        }
                        case END: {
                            this.createEnd(contextQ, qname);
                            continue block20;
                        }
                        case INVALIDATION: {
                            this.createInvalidation(contextQ, qname);
                            continue block20;
                        }
                        case START: {
                            this.createStart(contextQ, qname);
                            continue block20;
                        }
                        case INFLUENCE: {
                            this.createInfluence(contextQ, qname);
                            continue block20;
                        }
                        case INSERTION: {
                            this.createInsertion(contextQ, qname);
                            continue block20;
                        }
                        case REMOVAL: {
                            this.createRemoval(contextQ, qname);
                            continue block20;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endRDF() {
        super.endRDF();
        this.nullifyBNodes();
    }

    private void nullifyBNodes() {
        for (StatementOrBundle sob : this.document.getStatementOrBundle()) {
            Identifiable idsob;
            if (!(sob instanceof Identifiable) || (idsob = (Identifiable)sob).getId() == null || !idsob.getId().getNamespaceURI().equals(BNODE_NS) || this.isBNodeReferenced((BNode)new BNodeImpl(idsob.getId().getLocalPart()))) continue;
            idsob.setId(null);
        }
    }

    private List<XMLGregorianCalendar> getInstantaneousTimes(List<Statement> statements) {
        ArrayList<XMLGregorianCalendar> times = new ArrayList<XMLGregorianCalendar>();
        for (Statement statement : statements) {
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (!(value instanceof Literal) || !predQ.equals((Object)this.onto.QNAME_PROVO_atTime)) continue;
            times.add((XMLGregorianCalendar)super.decodeLiteral((Literal)value));
        }
        return times;
    }

    private void createRevision(QualifiedName contextQ, QualifiedName qname) {
        List<WasDerivedFrom> wdfs = this.createDerivation(contextQ, qname, this.onto.QNAME_PROVO_qualifiedRevision);
        QualifiedName q = this.onto.QNAME_PROVO_Revision;
        Type type = this.pFactory.newType((Object)q, this.name.XSD_QNAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private void createQuotation(QualifiedName contextQ, QualifiedName qname) {
        List<WasDerivedFrom> wdfs = this.createDerivation(contextQ, qname, this.onto.QNAME_PROVO_qualifiedQuotation);
        QualifiedName q = this.onto.QNAME_PROVO_Quotation;
        Type type = this.pFactory.newType((Object)q, this.name.XSD_QNAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private void createPrimarySource(QualifiedName context, QualifiedName qname) {
        List<WasDerivedFrom> wdfs = this.createDerivation(context, qname, this.onto.QNAME_PROVO_qualifiedPrimarySource);
        QualifiedName q = this.onto.QNAME_PROVO_PrimarySource;
        Type type = this.pFactory.newType((Object)q, this.name.XSD_QNAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private List<WasDerivedFrom> createDerivation(QualifiedName context, QualifiedName qname, QualifiedName pred) {
        List<QualifiedName> entities = this.getObjects(context, qname, this.onto.QNAME_PROVO_entity);
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadActivity);
        List<QualifiedName> generations = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadGeneration);
        List<QualifiedName> usages = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadUsage);
        List<QualifiedName> generated = this.getSubjects(context, pred, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.DERIVATION);
        qname = this.getQualQName(qname);
        ArrayList<WasDerivedFrom> wdfs = new ArrayList<WasDerivedFrom>();
        ArrayList<List<?>> perms = this.permute(generated, entities, activities, generations, usages);
        for (List list : perms) {
            WasDerivedFrom wdf = this.pFactory.newWasDerivedFrom(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (QualifiedName)list.get(3), (QualifiedName)list.get(4), attributes);
            this.store(context, (Relation)wdf);
            wdfs.add(wdf);
        }
        return wdfs;
    }

    private List<WasInfluencedBy> createInfluence(QualifiedName context, QualifiedName qname) {
        HashSet<QualifiedName> all_influencers = new HashSet<QualifiedName>();
        List<QualifiedName> influencers = this.getObjects(context, qname, this.onto.QNAME_PROVO_influencer);
        List<QualifiedName> agents = this.getObjects(context, qname, this.onto.QNAME_PROVO_agent);
        List<QualifiedName> entities = this.getObjects(context, qname, this.onto.QNAME_PROVO_entity);
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_activity);
        all_influencers.addAll(influencers);
        all_influencers.addAll(agents);
        all_influencers.addAll(entities);
        all_influencers.addAll(activities);
        List<QualifiedName> influencees = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedInfluence, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.INFLUENCE);
        qname = this.getQualQName(qname);
        ArrayList<WasInfluencedBy> wibs = new ArrayList<WasInfluencedBy>();
        ArrayList<List<?>> perms = this.permute(influencees, new ArrayList(all_influencers));
        for (List list : perms) {
            WasInfluencedBy wib = this.pFactory.newWasInfluencedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wib);
            wibs.add(wib);
        }
        return wibs;
    }

    private void createEnd(QualifiedName context, QualifiedName qname) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qname);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> triggers = this.getObjects(context, qname, this.onto.QNAME_PROVO_entity);
        List<QualifiedName> enders = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadActivity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedEnd, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.END);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(activities, triggers, enders, times);
        for (List list : perms) {
            WasEndedBy web = this.pFactory.newWasEndedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (XMLGregorianCalendar)list.get(3), attributes);
            this.store(context, (Relation)web);
        }
    }

    private void createInsertion(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> objectDictionaries = this.getObjects(context, qname, this.onto.QNAME_PROVO_dictionary);
        List<QualifiedName> pairs = this.getObjects(context, qname, this.onto.QNAME_PROVO_insertedKeyEntityPair);
        List<QualifiedName> subjectDictionaries = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedInsertion, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.INSERTION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(subjectDictionaries, objectDictionaries);
        for (List list : perms) {
            DerivedByInsertionFrom dbif = this.pFactory.newDerivedByInsertionFrom(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), this.createKeyEntityPairs(context, pairs), attributes);
            this.store(context, (Relation)dbif);
        }
    }

    private void createRemoval(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> objectDictionaries = this.getObjects(context, qname, this.onto.QNAME_PROVO_dictionary);
        List<Value> keys = this.getDataObjects(context, qname, this.onto.QNAME_PROVO_removedKey);
        List<QualifiedName> subjectDictionaries = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedRemoval, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.REMOVAL);
        qname = this.getQualQName(qname);
        LinkedList<Key> theKeys = new LinkedList<Key>();
        for (Value key : keys) {
            theKeys.add(this.valueToKey(key));
        }
        ArrayList<List<?>> perms = this.permute(subjectDictionaries, objectDictionaries);
        for (List list : perms) {
            DerivedByRemovalFrom dbif = this.pFactory.newDerivedByRemovalFrom(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), theKeys, attributes);
            this.store(context, (Relation)dbif);
        }
    }

    private void createStart(QualifiedName context, QualifiedName qname) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qname);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> triggers = this.getObjects(context, qname, this.onto.QNAME_PROVO_entity);
        List<QualifiedName> starters = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadActivity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedStart, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.START);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(activities, triggers, starters, times);
        for (List list : perms) {
            WasStartedBy wsb = this.pFactory.newWasStartedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (XMLGregorianCalendar)list.get(3), attributes);
            this.store(context, (Relation)wsb);
        }
    }

    private void createInvalidation(QualifiedName context, QualifiedName qname) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qname);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_activity);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedInvalidation, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.INVALIDATION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(entities, activities, times);
        for (List list : perms) {
            WasInvalidatedBy wib = this.pFactory.newWasInvalidatedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)wib);
        }
    }

    private void createDelegation(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadActivity);
        List<QualifiedName> agents = this.getObjects(context, qname, this.onto.QNAME_PROVO_agent);
        List<QualifiedName> subordinates = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedDelegation, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.DELEGATION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(subordinates, agents, activities);
        for (List list : perms) {
            ActedOnBehalfOf aobo = this.pFactory.newActedOnBehalfOf(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), attributes);
            this.store(context, (Relation)aobo);
        }
    }

    private void createCommunication(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_activity);
        List<QualifiedName> effects = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedCommunication, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.COMMUNICATION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(effects, activities);
        for (List list : perms) {
            WasInformedBy wib = this.pFactory.newWasInformedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wib);
        }
    }

    private void createAttribution(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> agents = this.getObjects(context, qname, this.onto.QNAME_PROVO_agent);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedAttribution, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.ATTRIBUTION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(entities, agents);
        for (List list : perms) {
            WasAttributedTo wat = this.pFactory.newWasAttributedTo(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wat);
        }
    }

    private void createAssociation(QualifiedName context, QualifiedName qname) {
        List<QualifiedName> plans = this.getObjects(context, qname, this.onto.QNAME_PROVO_hadPlan);
        List<QualifiedName> agents = this.getObjects(context, qname, this.onto.QNAME_PROVO_agent);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedAssociation, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.ASSOCIATION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(activities, agents, plans);
        for (List list : perms) {
            WasAssociatedWith waw = this.pFactory.newWasAssociatedWith(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), attributes);
            this.store(context, (Relation)waw);
        }
    }

    private void createUsage(QualifiedName context, QualifiedName qname) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qname);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> entities = this.getObjects(context, qname, this.onto.QNAME_PROVO_entity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedUsage, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.USAGE);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(activities, entities, times);
        for (List list : perms) {
            Used used = this.pFactory.newUsed(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)used);
        }
    }

    private QualifiedName getQualQName(QualifiedName qname) {
        if (qname.getNamespaceURI() == "" || qname.getNamespaceURI().equals(BNODE_NS)) {
            BNodeImpl bnode = new BNodeImpl(qname.getLocalPart());
            if (!this.isBNodeReferenced((BNode)bnode)) {
                return null;
            }
            return this.pFactory.newQualifiedName(BNODE_NS, qname.getLocalPart(), "bnode");
        }
        return qname;
    }

    private void createGeneration(QualifiedName context, QualifiedName qname) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qname);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> activities = this.getObjects(context, qname, this.onto.QNAME_PROVO_activity);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QNAME_PROVO_qualifiedGeneration, qname);
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.GENERATION);
        qname = this.getQualQName(qname);
        ArrayList<List<?>> perms = this.permute(entities, activities, times);
        for (List list : perms) {
            WasGeneratedBy wgb = this.pFactory.newWasGeneratedBy(qname, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)wgb);
        }
    }
}

