/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Element;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.rdf.collector.BundleHolder;
import org.openprovenance.prov.rdf.collector.Types;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class RdfCollector
extends RDFHandlerBase {
    protected final ProvFactory pFactory;
    protected final Name name;
    protected HashMap<QualifiedName, HashMap<QualifiedName, List<org.openrdf.model.Statement>>> collators;
    private Hashtable<QualifiedName, BundleHolder> bundles;
    protected Document document;
    private ValueConverter valueConverter;
    protected final Ontology onto;
    protected static String BNODE_NS = "http://openprovenance.org/provtoolbox/bnode/";
    protected final Types types;
    private final List<QualifiedName> QUAL_PREDS;
    final List<QualifiedName> DM_TYPES;
    Namespace namespace;

    public RdfCollector(ProvFactory pFactory, Ontology onto) {
        this.pFactory = pFactory;
        this.name = pFactory.getName();
        this.onto = onto;
        this.collators = new HashMap();
        this.document = pFactory.newDocument();
        this.valueConverter = new ValueConverter(pFactory);
        this.bundles = new Hashtable();
        this.namespace = new Namespace();
        this.document.setNamespace(this.namespace);
        this.handleNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.handleNamespace("bnode", BNODE_NS);
        this.types = new Types(onto);
        this.QUAL_PREDS = Arrays.asList(onto.QNAME_PROVO_qualifiedAssociation, onto.QNAME_PROVO_qualifiedAttribution, onto.QNAME_PROVO_qualifiedCommunication, onto.QNAME_PROVO_qualifiedDelegation, onto.QNAME_PROVO_qualifiedDerivation, onto.QNAME_PROVO_qualifiedEnd, onto.QNAME_PROVO_qualifiedGeneration, onto.QNAME_PROVO_qualifiedInfluence, onto.QNAME_PROVO_qualifiedInvalidation, onto.QNAME_PROVO_qualifiedPrimarySource, onto.QNAME_PROVO_qualifiedQuotation, onto.QNAME_PROVO_qualifiedRevision, onto.QNAME_PROVO_qualifiedStart, onto.QNAME_PROVO_qualifiedUsage, onto.QNAME_PROVO_qualifiedInsertion, onto.QNAME_PROVO_qualifiedRemoval);
        this.DM_TYPES = Arrays.asList(onto.QNAME_PROVO_Bundle, onto.QNAME_PROVO_Collection, onto.QNAME_PROVO_EmptyCollection, onto.QNAME_PROVO_Organization, onto.QNAME_PROVO_Person, onto.QNAME_PROVO_Plan, onto.QNAME_PROVO_PrimarySource, onto.QNAME_PROVO_Quotation, onto.QNAME_PROVO_Revision, onto.QNAME_PROVO_SoftwareAgent, onto.QNAME_PROVDC_Contributor, onto.QNAME_PROVO_Dictionary, onto.QNAME_PROVO_EmptyDictionary);
    }

    private HashMap<QualifiedName, List<org.openrdf.model.Statement>> getCollator(Resource context) {
        return this.collators.get(this.convertResourceToQualifiedName(context));
    }

    private BundleHolder getBundleHolder(QualifiedName context) {
        if (context == null) {
            context = this.pFactory.newQualifiedName("", "", "");
        }
        if (!this.bundles.containsKey(context)) {
            this.bundles.put(context, new BundleHolder());
        }
        return this.bundles.get(context);
    }

    protected void store(QualifiedName context, Relation relation0) {
        this.getBundleHolder(context).addStatement((Statement)relation0);
    }

    protected boolean isBNodeReferenced(BNode object) {
        Collection<HashMap<QualifiedName, List<org.openrdf.model.Statement>>> contexts = this.collators.values();
        for (HashMap<QualifiedName, List<org.openrdf.model.Statement>> context : contexts) {
            for (QualifiedName subject : context.keySet()) {
                List<org.openrdf.model.Statement> statements = context.get(subject);
                for (org.openrdf.model.Statement statement : statements) {
                    QualifiedName qname;
                    Value value = statement.getObject();
                    QualifiedName pred = this.convertURIToQualifiedName(statement.getPredicate());
                    if (this.QUAL_PREDS.contains(pred) || !(value instanceof BNode ? value.equals(object) : (value instanceof QualifiedName ? (qname = (QualifiedName)value).getNamespaceURI().equals(BNODE_NS) && qname.getLocalPart().equals(object.getID()) : value instanceof Resource && (qname = this.convertResourceToQualifiedName((Resource)value)).getNamespaceURI().equals(BNODE_NS) && qname.getLocalPart().equals(object.getID())))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isProvURI(QualifiedName qname) {
        return qname.getNamespaceURI().equals("http://www.w3.org/ns/prov#");
    }

    protected List<org.openrdf.model.Statement> getStatementsForPredicate(QualifiedName context, QualifiedName qname, QualifiedName uri) {
        ArrayList<org.openrdf.model.Statement> statements = new ArrayList<org.openrdf.model.Statement>();
        for (org.openrdf.model.Statement statement : this.collators.get(context).get(qname)) {
            if (!this.convertURIToQualifiedName(statement.getPredicate()).equals((Object)uri)) continue;
            statements.add(statement);
        }
        return statements;
    }

    protected org.openrdf.model.Statement getSingleStatementForPredicate(QualifiedName context, QualifiedName qname, QualifiedName uri) {
        List<org.openrdf.model.Statement> statements = this.getStatementsForPredicate(context, qname, uri);
        assert (statements.size() <= 1);
        org.openrdf.model.Statement statement = null;
        if (statements.size() == 1) {
            statement = statements.get(0);
        }
        return statement;
    }

    protected Types.ProvType[] getExplicitTypes(QualifiedName context, QualifiedName qname) {
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(qname);
        ArrayList<Types.ProvType> explicitOptions = new ArrayList<Types.ProvType>();
        for (org.openrdf.model.Statement statement : statements) {
            Types.ProvType provType;
            Value value;
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            if (!predQ.equals((Object)this.onto.QNAME_RDF_TYPE) || !((value = statement.getObject()) instanceof URI) || !this.isProvURI(this.convertURIToQualifiedName((URI)value)) || (provType = this.types.lookup(this.convertURIToQualifiedName((URI)value))) == null) continue;
            explicitOptions.add(provType);
        }
        if (explicitOptions.size() > 1) {
            ArrayList cloned = new ArrayList(explicitOptions);
            for (Types.ProvType option : explicitOptions) {
                for (Types.ProvType extended : this.types.getExtends(option)) {
                    cloned.remove((Object)extended);
                }
            }
            explicitOptions = cloned;
        }
        return explicitOptions.toArray(new Types.ProvType[0]);
    }

    protected QualifiedName convertResourceToQualifiedName(Resource resource) {
        if (resource instanceof URI) {
            return this.convertURIToQualifiedName((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.bnodeToQualifiedName((BNode)resource);
        }
        return null;
    }

    protected Object valueToObject(Value value) {
        if (value instanceof Resource) {
            return this.convertResourceToQualifiedName((Resource)value);
        }
        if (value instanceof Literal) {
            return this.decodeLiteral((Literal)value);
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return uri.toString();
        }
        if (value instanceof BNode) {
            return this.bnodeToQualifiedName(value);
        }
        return null;
    }

    public QualifiedName bnodeToQualifiedName(Value value) {
        return this.pFactory.newQualifiedName("http://bnodeNS/", ((BNode)value).getID(), null);
    }

    protected Key valueToKey(Value value) {
        if (value instanceof Resource) {
            return this.pFactory.newKey((Object)this.convertResourceToQualifiedName((Resource)value), this.name.XSD_QNAME);
        }
        if (value instanceof Literal) {
            QualifiedName xsdtype;
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                QualifiedName type = this.convertURIToQualifiedName(lit.getDatatype());
                xsdtype = this.onto.convertFromRdf(type);
            } else {
                xsdtype = this.name.PROV_LANG_STRING;
            }
            Object o = this.decodeLiteral(lit);
            if (o instanceof QualifiedName) {
                return this.pFactory.newKey(o, this.name.XSD_QNAME);
            }
            return this.pFactory.newKey(o, xsdtype);
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return this.pFactory.newKey((Object)uri.toString(), this.name.XSD_QNAME);
        }
        if (value instanceof BNode) {
            return this.pFactory.newKey((Object)this.bnodeToQualifiedName(value), this.name.XSD_QNAME);
        }
        return null;
    }

    protected Object decodeLiteral(Literal literal) {
        String dataType = "http://www.w3.org/2001/XMLSchema#string";
        if (literal.getLanguage() != null) {
            return this.pFactory.newInternationalizedString(literal.stringValue(), literal.getLanguage());
        }
        if (literal.getDatatype() != null) {
            if (literal instanceof URI) {
                QualifiedName qname = this.namespace.stringToQualifiedName(literal.getDatatype().stringValue(), this.pFactory);
                dataType = qname.getNamespaceURI() + qname.getLocalPart();
            } else {
                dataType = literal.getDatatype().stringValue();
            }
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#QName")) {
            return this.namespace.stringToQualifiedName(literal.stringValue(), this.pFactory);
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#string")) {
            return literal.stringValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#dateTime") || dataType.equals("http://www.w3.org/2001/XMLSchema#time") || dataType.equals("http://www.w3.org/2001/XMLSchema#date") || dataType.equals("http://www.w3.org/2001/XMLSchema#gYearMonth") || dataType.equals("http://www.w3.org/2001/XMLSchema#gMonthDay") || dataType.equals("http://www.w3.org/2001/XMLSchema#gYear") || dataType.equals("http://www.w3.org/2001/XMLSchema#gMonth") || dataType.equals("http://www.w3.org/2001/XMLSchema#gDay")) {
            return literal.calendarValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#int")) {
            return literal.intValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#integer")) {
            return literal.integerValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            return literal.booleanValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#double")) {
            return literal.doubleValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#float")) {
            return Float.valueOf(literal.floatValue());
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#long")) {
            return literal.longValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#short")) {
            return literal.shortValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#byte")) {
            return literal.byteValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            return literal.decimalValue();
        }
        if (dataType.equals("http://www.w3.org/2001/XMLSchema#anyURI")) {
            return literal.stringValue();
        }
        return literal.stringValue();
    }

    private void handleTypes(Types.ProvType[] types, QualifiedName context, QualifiedName subject) {
        block5: for (Types.ProvType type : types) {
            switch (type) {
                case ACTIVITY: {
                    this.createActivity(context, subject);
                    continue block5;
                }
                case AGENT: 
                case PERSON: 
                case ORGANIZATION: 
                case SOFTWAREAGENT: {
                    this.createAgent(context, subject);
                    continue block5;
                }
                case COLLECTION: 
                case DICTIONARY: 
                case ENTITY: 
                case PLAN: 
                case BUNDLE: {
                    this.createEntity(context, subject);
                    continue block5;
                }
            }
        }
        this.handlePredicates(context, subject);
    }

    protected void buildGraph() {
        for (QualifiedName contextQ : this.collators.keySet()) {
            HashMap<QualifiedName, List<org.openrdf.model.Statement>> collator = this.collators.get(contextQ);
            for (QualifiedName qname : collator.keySet()) {
                Types.ProvType[] explicitTypes = this.getExplicitTypes(contextQ, qname);
                this.handleTypes(explicitTypes, contextQ, qname);
            }
        }
    }

    protected void buildBundles() {
        if (this.bundles.containsKey(this.emptyQualifiedName())) {
            BundleHolder defaultBundle = this.bundles.get(this.emptyQualifiedName());
            for (Activity activity : defaultBundle.getActivities()) {
                this.document.getStatementOrBundle().add(activity);
            }
            for (Agent agent : defaultBundle.getAgents()) {
                this.document.getStatementOrBundle().add(agent);
            }
            for (Entity entity : defaultBundle.getEntities()) {
                this.document.getStatementOrBundle().add(entity);
            }
            for (Statement statement : defaultBundle.getStatements()) {
                this.document.getStatementOrBundle().add(statement);
            }
        }
        for (QualifiedName key : this.bundles.keySet()) {
            if (key.getLocalPart().equals("")) continue;
            BundleHolder bundleHolder = this.bundles.get(key);
            ArrayList<Object> statements = new ArrayList<Object>();
            statements.addAll(bundleHolder.getActivities());
            statements.addAll(bundleHolder.getEntities());
            statements.addAll(bundleHolder.getAgents());
            statements.addAll(bundleHolder.getStatements());
            Bundle bundle = this.pFactory.newNamedBundle(key, null, statements);
            this.document.getStatementOrBundle().add(bundle);
        }
    }

    public QualifiedName emptyQualifiedName() {
        return this.pFactory.newQualifiedName("", "", null);
    }

    protected QualifiedName convertURIToQualifiedName(URI uri) {
        QualifiedName qname;
        String uriNamespace = uri.getNamespace();
        String prefix = (String)this.namespace.getNamespaces().get(uriNamespace);
        String uriLocalName = uri.getLocalName();
        if (prefix != null) {
            qname = this.pFactory.newQualifiedName(uriNamespace, uriLocalName, prefix);
        } else {
            String defaultNS = this.namespace.getDefaultNamespace();
            if (defaultNS != null && defaultNS.equals(uriNamespace)) {
                qname = this.pFactory.newQualifiedName(uriNamespace, uriLocalName, null);
            } else {
                this.namespace.newPrefix(uriNamespace);
                String pref = (String)this.namespace.getNamespaces().get(uriNamespace);
                qname = this.pFactory.newQualifiedName(uriNamespace, uriLocalName, pref);
            }
        }
        return qname;
    }

    public List<Attribute> collectAttributes(QualifiedName context, QualifiedName qname, Types.ProvType type) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(qname);
        for (org.openrdf.model.Statement statement : statements) {
            Attribute attr;
            Attribute attr2;
            Object obj;
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (statement.getPredicate().equals((Object)RDF.TYPE)) {
                obj = this.valueToObject(statement.getObject());
                if (obj != null) {
                    Value vobj = statement.getObject();
                    Boolean sameAsType = false;
                    if (vobj instanceof URI) {
                        URI uri = (URI)vobj;
                        String uriVal = uri.getNamespace() + uri.getLocalName();
                        sameAsType = uriVal.equals(this.types.find(type));
                    }
                    if (!sameAsType.booleanValue()) {
                        if (statement.getObject() instanceof Resource) {
                            QualifiedName typeQ = this.convertResourceToQualifiedName((Resource)statement.getObject());
                            if (!this.isProvURI(typeQ) || this.DM_TYPES.indexOf(typeQ) != -1) {
                                attributes.add(this.pFactory.newAttribute(this.name.PROV_TYPE, (Object)typeQ, this.name.XSD_QNAME));
                            }
                        } else if (statement.getObject() instanceof Literal) {
                            Literal lit = (Literal)statement.getObject();
                            Attribute attr3 = this.newAttribute(lit, this.name.PROV_TYPE);
                            attributes.add(attr3);
                        }
                    }
                } else {
                    System.out.println(value);
                    System.out.println("Value wasn't a suitable type");
                }
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_hadRole)) {
                obj = statement.getObject();
                attr2 = this.newAttributeForValue((Value)obj, this.name.PROV_ROLE);
                attributes.add(attr2);
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_atLocation)) {
                obj = statement.getObject();
                attr2 = this.newAttributeForValue((Value)obj, this.name.PROV_LOCATION);
                attributes.add(attr2);
            }
            if (predQ.equals((Object)this.onto.QNAME_RDFS_LABEL)) {
                Literal lit = (Literal)statement.getObject();
                attr2 = this.newAttribute(lit, this.name.PROV_LABEL);
                attributes.add(attr2);
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_value)) {
                attr = this.newAttributeForValue(value, this.name.PROV_VALUE);
                attributes.add(attr);
            }
            if (this.isProvURI(predQ) || predQ.equals((Object)this.onto.QNAME_RDF_TYPE) || predQ.equals((Object)this.onto.QNAME_RDFS_LABEL)) continue;
            attr = this.newAttributeForValue(value, predQ);
            attributes.add(attr);
        }
        return attributes;
    }

    public Attribute newAttributeForValue(Value obj, QualifiedName type) {
        Attribute attr;
        if (obj instanceof Literal) {
            attr = this.newAttribute((Literal)obj, type);
        } else if (obj instanceof Resource) {
            attr = this.pFactory.newAttribute(type, (Object)this.convertResourceToQualifiedName((Resource)obj), this.name.XSD_QNAME);
        } else {
            throw new UnsupportedOperationException();
        }
        return attr;
    }

    public Attribute newAttribute(Literal lit, QualifiedName type) {
        String theValue = lit.getLanguage() != null ? this.pFactory.newInternationalizedString(lit.stringValue(), lit.getLanguage()) : lit.stringValue();
        Attribute attr = this.pFactory.newAttribute(type, (Object)theValue, lit.getDatatype() == null ? (lit.getLanguage() == null ? this.name.XSD_STRING : this.name.PROV_LANG_STRING) : this.onto.convertFromRdf(this.convertURIToQualifiedName(lit.getDatatype())));
        return attr;
    }

    private void handlePredicates(QualifiedName context, QualifiedName qname) {
        ArrayList<QualifiedName> members = new ArrayList<QualifiedName>();
        ArrayList<QualifiedName> dictionaryMembers = new ArrayList<QualifiedName>();
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(qname);
        for (org.openrdf.model.Statement statement : statements) {
            WasGeneratedBy wgb;
            WasDerivedFrom wdf;
            WasInfluencedBy wib;
            QualifiedName anyQ;
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasInfluencedBy)) {
                anyQ = this.convertResourceToQualifiedName((Resource)statement.getObject());
                wib = this.pFactory.newWasInfluencedBy(null, qname, anyQ, null);
                this.store(this.convertResourceToQualifiedName(statement.getContext()), (Relation)wib);
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_influenced)) {
                anyQ = this.convertResourceToQualifiedName((Resource)statement.getObject());
                wib = this.pFactory.newWasInfluencedBy(null, anyQ, qname, null);
                this.store(this.convertResourceToQualifiedName(statement.getContext()), (Relation)wib);
            }
            if (!(value instanceof Resource)) continue;
            QualifiedName valueQ = this.convertResourceToQualifiedName((Resource)value);
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasDerivedFrom)) {
                wdf = this.pFactory.newWasDerivedFrom((QualifiedName)null, qname, valueQ, null, null, null, null);
                this.store(context, (Relation)wdf);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_hadPrimarySource)) {
                wdf = this.pFactory.newWasDerivedFrom(null, qname, valueQ, null, null, null, null);
                this.pFactory.addPrimarySourceType((HasType)wdf);
                this.store(context, (Relation)wdf);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasQuotedFrom)) {
                wdf = this.pFactory.newWasDerivedFrom(null, qname, valueQ, null, null, null, null);
                this.pFactory.addQuotationType((HasType)wdf);
                this.store(context, (Relation)wdf);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasRevisionOf)) {
                wdf = this.pFactory.newWasDerivedFrom(null, qname, valueQ, null, null, null, null);
                this.pFactory.addRevisionType((HasType)wdf);
                this.store(context, (Relation)wdf);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasGeneratedBy)) {
                wgb = this.pFactory.newWasGeneratedBy(null, qname, valueQ, null, null);
                this.store(context, (Relation)wgb);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_alternateOf)) {
                AlternateOf ao = this.pFactory.newAlternateOf(qname, valueQ);
                this.store(context, (Relation)ao);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_specializationOf)) {
                SpecializationOf so = this.pFactory.newSpecializationOf(qname, valueQ);
                this.store(context, (Relation)so);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasInvalidatedBy)) {
                wib = this.pFactory.newWasInvalidatedBy(null, qname, valueQ, null, null);
                this.store(context, (Relation)wib);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasAttributedTo)) {
                WasAttributedTo wit = this.pFactory.newWasAttributedTo(null, qname, valueQ, null);
                this.store(context, (Relation)wit);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_mentionOf)) {
                org.openrdf.model.Statement asInBundleStatement = this.getSingleStatementForPredicate(context, qname, this.onto.QNAME_PROVO_asInBundle);
                Value o = asInBundleStatement == null ? null : asInBundleStatement.getObject();
                QualifiedName bundleQ = o == null ? null : this.convertURIToQualifiedName((URI)o);
                QualifiedName entityQ = value == null ? null : this.convertURIToQualifiedName((URI)value);
                MentionOf mo = this.pFactory.newMentionOf(entityQ, qname, bundleQ);
                this.store(context, (Relation)mo);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasAssociatedWith)) {
                WasAssociatedWith waw = this.pFactory.newWasAssociatedWith(null, qname, valueQ, null, null);
                this.store(context, (Relation)waw);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_used)) {
                Used used = this.pFactory.newUsed(null, qname, valueQ, null, null);
                this.store(context, (Relation)used);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasStartedBy)) {
                WasStartedBy wsb = this.pFactory.newWasStartedBy(null, qname, valueQ, null, null, null);
                this.store(context, (Relation)wsb);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_generated)) {
                wgb = this.pFactory.newWasGeneratedBy(null, valueQ, qname, null, null);
                this.store(context, (Relation)wgb);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasEndedBy)) {
                WasEndedBy web = this.pFactory.newWasEndedBy(null, qname, valueQ, null, null, null);
                this.store(context, (Relation)web);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_wasInformedBy)) {
                wib = this.pFactory.newWasInformedBy(null, qname, valueQ, null);
                this.store(context, (Relation)wib);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_actedOnBehalfOf)) {
                QualifiedName agentQ = this.convertResourceToQualifiedName((Resource)value);
                ActedOnBehalfOf aobo = this.pFactory.newActedOnBehalfOf(null, qname, agentQ, null, null);
                this.store(context, (Relation)aobo);
                continue;
            }
            if (predQ.equals((Object)this.onto.QNAME_PROVO_hadMember)) {
                members.add(this.convertResourceToQualifiedName((Resource)statement.getObject()));
                continue;
            }
            if (!predQ.equals((Object)this.onto.QNAME_PROVO_hadDictionaryMember)) continue;
            dictionaryMembers.add(this.convertResourceToQualifiedName((Resource)statement.getObject()));
        }
        if (members.size() > 0) {
            HadMember hm = this.pFactory.newHadMember(qname, members);
            this.store(context, (Relation)hm);
        }
        if (dictionaryMembers.size() > 0) {
            List<Entry> pairs = this.createKeyEntityPairs(context, dictionaryMembers);
            DictionaryMembership hm = this.pFactory.newDictionaryMembership(qname, pairs);
            this.store(context, (Relation)hm);
        }
    }

    protected List<Value> getDataObjects(QualifiedName context, QualifiedName subject, QualifiedName pred) {
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(subject);
        ArrayList<Value> objects = new ArrayList<Value>();
        for (org.openrdf.model.Statement statement : statements) {
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (!pred.equals((Object)predQ) || value instanceof Resource) continue;
            objects.add(value);
        }
        return objects;
    }

    protected List<Entry> createKeyEntityPairs(QualifiedName context, List<QualifiedName> pairs) {
        LinkedList<Entry> result = new LinkedList<Entry>();
        for (QualifiedName pair : pairs) {
            List<Value> keys = this.getDataObjects(context, pair, this.onto.QNAME_PROVO_pairKey);
            List<QualifiedName> entities = this.getObjects(context, pair, this.onto.QNAME_PROVO_pairEntity);
            Key key = null;
            QualifiedName name = null;
            if (!keys.isEmpty()) {
                key = this.valueToKey(keys.get(0));
            }
            if (!entities.isEmpty()) {
                name = entities.get(0);
            }
            Entry p = this.pFactory.newEntry(key, name);
            result.add(p);
        }
        return result;
    }

    protected List<QualifiedName> getObjects(QualifiedName context, QualifiedName subject, QualifiedName pred) {
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(subject);
        ArrayList<QualifiedName> objects = new ArrayList<QualifiedName>();
        for (org.openrdf.model.Statement statement : statements) {
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (!pred.equals((Object)predQ) || !(value instanceof Resource)) continue;
            objects.add(this.convertResourceToQualifiedName((Resource)value));
        }
        return objects;
    }

    private void createEntity(QualifiedName context, QualifiedName qname) {
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.ENTITY);
        Entity entity = this.pFactory.newEntity(qname, attributes);
        this.getBundleHolder(context).store((Element)entity);
    }

    private void createAgent(QualifiedName context, QualifiedName qname) {
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.AGENT);
        Agent agent = this.pFactory.newAgent(qname, attributes);
        this.getBundleHolder(context).store((Element)agent);
    }

    private void createActivity(QualifiedName context, QualifiedName qname) {
        List<Attribute> attributes = this.collectAttributes(context, qname, Types.ProvType.ACTIVITY);
        List<org.openrdf.model.Statement> statements = this.collators.get(context).get(qname);
        XMLGregorianCalendar startTime = null;
        XMLGregorianCalendar endTime = null;
        for (org.openrdf.model.Statement statement : statements) {
            Object literal;
            QualifiedName predQ = this.convertURIToQualifiedName(statement.getPredicate());
            Value value = statement.getObject();
            if (!(value instanceof Literal)) continue;
            if (predQ.equals((Object)this.onto.QNAME_PROVO_startedAtTime)) {
                literal = this.decodeLiteral((Literal)value);
                startTime = (XMLGregorianCalendar)literal;
                continue;
            }
            if (!predQ.equals((Object)this.onto.QNAME_PROVO_endedAtTime)) continue;
            literal = this.decodeLiteral((Literal)value);
            endTime = (XMLGregorianCalendar)literal;
        }
        Activity activity = this.pFactory.newActivity(qname, startTime, endTime, attributes);
        this.getBundleHolder(context).store((Element)activity);
    }

    public Document getDocument() {
        return this.document;
    }

    public void handleNamespace(String prefix, String namespace) {
        if (prefix.equals("")) {
            prefix = "def";
        }
        this.document.getNamespace().register(prefix, namespace);
    }

    protected QualifiedName bnodeToQualifiedName(BNode bnode) {
        return this.pFactory.newQualifiedName(BNODE_NS, bnode.getID(), "bnode");
    }

    public void handleStatement(org.openrdf.model.Statement statement) {
        HashMap<QualifiedName, List<org.openrdf.model.Statement>> currcollator;
        QualifiedName subjectQ = null;
        QualifiedName contextQ = this.convertResourceToQualifiedName(statement.getContext());
        Resource subject = statement.getSubject();
        if (subject instanceof BNodeImpl) {
            subjectQ = this.bnodeToQualifiedName((BNode)((BNodeImpl)subject));
        } else if (subject instanceof URI) {
            URI uri = (URI)subject;
            subjectQ = this.convertURIToQualifiedName(uri);
        } else {
            System.err.println("Invalid subject resource");
        }
        if (!this.collators.containsKey(contextQ)) {
            this.collators.put(contextQ, new HashMap());
        }
        if (!(currcollator = this.getCollator(statement.getContext())).containsKey(subjectQ)) {
            currcollator.put(subjectQ, new ArrayList());
        }
        currcollator.get(subjectQ).add(statement);
    }

    public void endRDF() {
        this.buildGraph();
        this.buildBundles();
    }
}

