/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf.collector;

import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.rdf.Ontology;

public class Types {
    private final Ontology onto;
    private final Map<ProvType, QualifiedName> type2qn = new HashMap<ProvType, QualifiedName>();
    private static final Map<ProvType, ProvType[]> extendsType = new HashMap<ProvType, ProvType[]>();
    private static final Map<QualifiedName, ProvType> qn2type = new HashMap<QualifiedName, ProvType>();

    public Types(Ontology onto) {
        this.onto = onto;
        this.initialize();
    }

    public void initialize() {
        this.registerType(ProvType.ENTITY, this.onto.QNAME_PROVO_Entity);
        this.registerType(ProvType.AGENT, this.onto.QNAME_PROVO_Agent);
        this.registerType(ProvType.ACTIVITY, this.onto.QNAME_PROVO_Activity);
        this.registerType(ProvType.INFLUENCE, this.onto.QNAME_PROVO_Influence);
        this.registerType(ProvType.BUNDLE, this.onto.QNAME_PROVO_Bundle, ProvType.ENTITY);
        this.registerType(ProvType.ORGANIZATION, this.onto.QNAME_PROVO_Organization, ProvType.AGENT);
        this.registerType(ProvType.PERSON, this.onto.QNAME_PROVO_Person, ProvType.AGENT);
        this.registerType(ProvType.SOFTWAREAGENT, this.onto.QNAME_PROVO_SoftwareAgent, ProvType.AGENT);
        this.registerType(ProvType.LOCATION, this.onto.QNAME_PROVO_Location);
        this.registerType(ProvType.ROLE, this.onto.QNAME_PROVO_Role);
        this.registerType(ProvType.PLAN, this.onto.QNAME_PROVO_Plan, ProvType.ENTITY);
        this.registerType(ProvType.CONTRIBUTOR, this.onto.QNAME_PROVDC_Contributor, ProvType.ROLE);
        this.registerType(ProvType.COLLECTION, this.onto.QNAME_PROVO_Collection, ProvType.ENTITY);
        this.registerType(ProvType.DICTIONARY, this.onto.QNAME_PROVO_Dictionary, ProvType.COLLECTION);
        this.registerType(ProvType.EMPTYCOLLECTION, this.onto.QNAME_PROVO_EmptyCollection, ProvType.COLLECTION);
        this.registerType(ProvType.EMPTYDICTIONARY, this.onto.QNAME_PROVO_EmptyDictionary, ProvType.DICTIONARY);
        this.registerType(ProvType.INSTANTANEOUSEVENT, this.onto.QNAME_PROVO_InstantaneousEvent);
        this.registerType(ProvType.ENTITYINFLUENCE, this.onto.QNAME_PROVO_EntityInfluence, ProvType.INFLUENCE);
        this.registerType(ProvType.INSERTION, this.onto.QNAME_PROVO_Insertion, ProvType.INFLUENCE);
        this.registerType(ProvType.REMOVAL, this.onto.QNAME_PROVO_Removal, ProvType.INFLUENCE);
        this.registerType(ProvType.ACTIVITYINFLUENCE, this.onto.QNAME_PROVO_ActivityInfluence, ProvType.INFLUENCE);
        this.registerType(ProvType.AGENTINFLUENCE, this.onto.QNAME_PROVO_AgentInfluence, ProvType.INFLUENCE);
        this.registerType(ProvType.ASSOCIATION, this.onto.QNAME_PROVO_Association, ProvType.AGENTINFLUENCE);
        this.registerType(ProvType.ATTRIBUTION, this.onto.QNAME_PROVO_Attribution, ProvType.AGENTINFLUENCE);
        this.registerType(ProvType.COMMUNICATION, this.onto.QNAME_PROVO_Communication, ProvType.AGENTINFLUENCE);
        this.registerType(ProvType.DELEGATION, this.onto.QNAME_PROVO_Delegation, ProvType.AGENTINFLUENCE);
        this.registerType(ProvType.DERIVATION, this.onto.QNAME_PROVO_Derivation, ProvType.ENTITYINFLUENCE);
        this.registerType(ProvType.QUOTATION, this.onto.QNAME_PROVO_Quotation, ProvType.ENTITYINFLUENCE);
        this.registerType(ProvType.REVISION, this.onto.QNAME_PROVO_Revision, ProvType.ENTITYINFLUENCE);
        this.registerType(ProvType.PRIMARYSOURCE, this.onto.QNAME_PROVO_PrimarySource, ProvType.ENTITYINFLUENCE);
        this.registerType(ProvType.END, this.onto.QNAME_PROVO_End, new ProvType[]{ProvType.INSTANTANEOUSEVENT, ProvType.ENTITYINFLUENCE});
        this.registerType(ProvType.START, this.onto.QNAME_PROVO_Start, new ProvType[]{ProvType.INSTANTANEOUSEVENT, ProvType.ENTITYINFLUENCE});
        this.registerType(ProvType.GENERATION, this.onto.QNAME_PROVO_Generation, new ProvType[]{ProvType.INSTANTANEOUSEVENT, ProvType.ACTIVITYINFLUENCE});
        this.registerType(ProvType.INVALIDATION, this.onto.QNAME_PROVO_Invalidation, new ProvType[]{ProvType.INSTANTANEOUSEVENT, ProvType.ACTIVITYINFLUENCE});
        this.registerType(ProvType.USAGE, this.onto.QNAME_PROVO_Usage, new ProvType[]{ProvType.INSTANTANEOUSEVENT, ProvType.ENTITYINFLUENCE});
    }

    void registerType(ProvType type, QualifiedName qname) {
        this.type2qn.put(type, qname);
        qn2type.put(qname, type);
        extendsType.put(type, new ProvType[0]);
    }

    void registerType(ProvType type, QualifiedName qname, ProvType extendsType) {
        this.type2qn.put(type, qname);
        qn2type.put(qname, type);
        Types.extendsType.put(type, new ProvType[]{extendsType});
    }

    void registerType(ProvType type, QualifiedName qname, ProvType[] extendsTypes) {
        this.type2qn.put(type, qname);
        qn2type.put(qname, type);
        extendsType.put(type, extendsTypes);
    }

    public ProvType lookup(QualifiedName qname) {
        return qn2type.get(qname);
    }

    public QualifiedName find(ProvType pt) {
        return this.type2qn.get((Object)pt);
    }

    public ProvType[] getExtends(ProvType type) {
        return extendsType.get((Object)type);
    }

    public static enum ProvType {
        ENTITY,
        AGENT,
        ACTIVITY,
        INFLUENCE,
        BUNDLE,
        ORGANIZATION,
        PERSON,
        SOFTWAREAGENT,
        LOCATION,
        ROLE,
        PLAN,
        CONTRIBUTOR,
        COLLECTION,
        DICTIONARY,
        EMPTYCOLLECTION,
        EMPTYDICTIONARY,
        INSTANTANEOUSEVENT,
        ENTITYINFLUENCE,
        INSERTION,
        REMOVAL,
        ACTIVITYINFLUENCE,
        AGENTINFLUENCE,
        ASSOCIATION,
        ATTRIBUTION,
        COMMUNICATION,
        DELEGATION,
        DERIVATION,
        QUOTATION,
        REVISION,
        PRIMARYSOURCE,
        END,
        START,
        GENERATION,
        INVALIDATION,
        USAGE;

    }
}

