/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;

public class Bindings {
    public static final String VALUE = "value_";
    public static final String VALUE2 = "2dvalue_";
    public static final String APP_VALUE = "http://openprovenance.org/tmpl#value_";
    public static final String APP_VALUE2 = "http://openprovenance.org/tmpl#2dvalue_";
    private final Hashtable<QualifiedName, List<QualifiedName>> variables;
    private final Hashtable<QualifiedName, List<List<TypedValue>>> attributes;
    final ProvFactory pf;
    static ProvUtilities u = new ProvUtilities();

    public Bindings(ProvFactory pf) {
        this(new Hashtable<QualifiedName, List<QualifiedName>>(), new Hashtable<QualifiedName, List<List<TypedValue>>>(), pf);
    }

    public Bindings(Hashtable<QualifiedName, List<QualifiedName>> variables, Hashtable<QualifiedName, List<List<TypedValue>>> attributes, ProvFactory pf) {
        this.variables = variables;
        this.attributes = attributes;
        this.pf = pf;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Bindings)) {
            return false;
        }
        Bindings b = (Bindings)o;
        return b.variables.equals(this.variables) && b.attributes.equals(this.attributes);
    }

    public Hashtable<QualifiedName, List<QualifiedName>> getVariables() {
        return this.variables;
    }

    public Hashtable<QualifiedName, List<List<TypedValue>>> getAttributes() {
        return this.attributes;
    }

    public void addVariable(QualifiedName name, QualifiedName val) {
        List<QualifiedName> v = this.variables.get(name);
        if (v == null) {
            this.variables.put(name, new LinkedList());
        }
        this.variables.get(name).add(val);
    }

    public void addAttribute(QualifiedName name, List<TypedValue> values) {
        List<List<TypedValue>> v = this.attributes.get(name);
        if (v == null) {
            this.attributes.put(name, new LinkedList());
        }
        this.attributes.get(name).add(values);
    }

    public String toString() {
        return "[" + this.getVariables() + " -- " + this.getAttributes() + "]";
    }

    public Document toDocument() {
        Document result = this.pf.newDocument();
        LinkedList<StatementOrBundle> ll = new LinkedList<StatementOrBundle>();
        this.add1DValues(ll, this.variables);
        this.add2Dvalues(ll, this.attributes);
        result.getStatementOrBundle().addAll(ll);
        result.setNamespace(this.pf.newNamespace(Namespace.gatherNamespaces((Document)result)));
        return result;
    }

    public void add2Dvalues(List<StatementOrBundle> ll, Hashtable<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            Entity e = this.pf.newEntity(entry.getKey());
            int count1 = 0;
            LinkedList<Other> attrs = new LinkedList<Other>();
            for (List<TypedValue> vals : entry.getValue()) {
                int count2 = 0;
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newOther("http://openprovenance.org/tmpl#", VALUE2 + count1 + "_" + count2, "tmpl", val.getValue(), val.getType()));
                    ++count2;
                }
                ++count1;
            }
            e.getOther().addAll(attrs);
            ll.add((StatementOrBundle)e);
        }
    }

    public void add1DValues(List<StatementOrBundle> ll, Hashtable<QualifiedName, List<QualifiedName>> variables) {
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : variables.entrySet()) {
            Entity e = this.pf.newEntity(entry.getKey());
            int count = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (QualifiedName qn : entry.getValue()) {
                attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE + count, "tmpl", (Object)qn, this.pf.getName().XSD_QNAME));
                ++count;
            }
            this.pf.setAttributes((HasOther)e, attrs);
            ll.add((StatementOrBundle)e);
        }
    }

    public static Bindings fromDocument(Document doc, ProvFactory pf) {
        Bindings result = new Bindings(pf);
        List entities = u.getEntity(doc);
        for (Entity entity : entities) {
            int size2;
            Hashtable<Integer, QualifiedName> map = new Hashtable<Integer, QualifiedName>();
            Hashtable map2 = new Hashtable();
            for (Other attr : entity.getOther()) {
                String uri = attr.getElementName().getUri();
                if (uri.startsWith(APP_VALUE)) {
                    Integer i = Integer.valueOf(uri.substring(APP_VALUE.length()));
                    if (!(attr.getValue() instanceof QualifiedName)) continue;
                    map.put(i, (QualifiedName)attr.getValue());
                    continue;
                }
                if (!uri.startsWith(APP_VALUE2)) continue;
                String index = uri.substring(APP_VALUE2.length());
                String[] nums = index.split("_");
                Integer i = Integer.valueOf(nums[0]);
                Integer j = Integer.valueOf(nums[1]);
                Hashtable row = (Hashtable)map2.get(i);
                if (row == null) {
                    map2.put(i, new Hashtable());
                }
                ((Hashtable)map2.get(i)).put(j, attr);
            }
            ArrayList ll = new ArrayList();
            int size = map.entrySet().size();
            if (size > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    Bindings.set((Integer)entry.getKey(), ll, entry.getValue());
                }
                result.getVariables().put(entity.getId(), ll);
            }
            if ((size2 = map2.entrySet().size()) <= 0) continue;
            LinkedList allvalues = new LinkedList();
            for (Map.Entry entry1 : map2.entrySet()) {
                LinkedList values = new LinkedList();
                for (Map.Entry entry2 : ((Hashtable)entry1.getValue()).entrySet()) {
                    Bindings.set((Integer)entry2.getKey(), values, entry2.getValue());
                }
                Bindings.set((Integer)entry1.getKey(), allvalues, values);
            }
            result.getAttributes().put(entity.getId(), allvalues);
        }
        return result;
    }

    public static <E> void set(int pos, List<E> ll, E val) {
        int size;
        for (int i = size = ll.size(); i <= pos; ++i) {
            ll.add(null);
        }
        ll.set(pos, val);
    }
}

