/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

public class FilterOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new FilterFinder(tupleExpr));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterRelocator
    extends QueryModelVisitorBase<RuntimeException> {
        protected final Filter filter;
        protected final Set<String> filterVars;

        public static void relocate(Filter filter) {
            filter.visit((QueryModelVisitor)new FilterRelocator(filter));
        }

        public FilterRelocator(Filter filter) {
            this.filter = filter;
            this.filterVars = VarNameCollector.process((QueryModelNode)filter.getCondition());
        }

        protected void meetNode(QueryModelNode node) {
            assert (node instanceof TupleExpr);
            this.relocate(this.filter, (TupleExpr)node);
        }

        public void meet(Join join) {
            if (join.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join.getLeftArg().visit((QueryModelVisitor)this);
            } else if (join.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join.getRightArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)join);
            }
        }

        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)leftJoin);
            }
        }

        public void meet(Union union) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, union.getLeftArg());
            this.relocate(clone, union.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        public void meet(Difference node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        public void meet(Intersection node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        public void meet(Extension node) {
            if (node.getArg().getBindingNames().containsAll(this.filterVars)) {
                node.getArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)node);
            }
        }

        public void meet(EmptySet node) {
            if (this.filter.getParentNode() != null) {
                this.filter.replaceWith((QueryModelNode)this.filter.getArg());
            }
        }

        public void meet(Filter filter) {
            filter.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Distinct node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Order node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(QueryRoot node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Reduced node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        protected void relocate(Filter filter, TupleExpr newFilterArg) {
            if (filter.getArg() != newFilterArg) {
                if (filter.getParentNode() != null) {
                    filter.replaceWith((QueryModelNode)filter.getArg());
                }
                newFilterArg.replaceWith((QueryModelNode)filter);
                filter.setArg(newFilterArg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterFinder
    extends QueryModelVisitorBase<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public FilterFinder(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        public void meet(Filter filter) {
            super.meet(filter);
            FilterRelocator.relocate(filter);
        }
    }
}

