/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.iterator.LeftJoinIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BadlyDesignedLeftJoinIterator
extends LeftJoinIterator {
    private final BindingSet inputBindings;
    private final Set<String> problemVars;

    public BadlyDesignedLeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet inputBindings, Set<String> problemVars) throws QueryEvaluationException {
        super(strategy, join, BadlyDesignedLeftJoinIterator.getFilteredBindings(inputBindings, problemVars));
        this.inputBindings = inputBindings;
        this.problemVars = problemVars;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = super.getNextElement();
        while (result != null && !QueryResultUtil.bindingSetsCompatible((BindingSet)this.inputBindings, (BindingSet)result)) {
            result = super.getNextElement();
        }
        if (result != null) {
            QueryBindingSet extendedResult = null;
            for (String problemVar : this.problemVars) {
                if (result.hasBinding(problemVar)) continue;
                if (extendedResult == null) {
                    extendedResult = new QueryBindingSet(result);
                }
                extendedResult.addBinding(problemVar, this.inputBindings.getValue(problemVar));
            }
            if (extendedResult != null) {
                result = extendedResult;
            }
        }
        return result;
    }

    private static QueryBindingSet getFilteredBindings(BindingSet bindings, Set<String> problemVars) {
        QueryBindingSet filteredBindings = new QueryBindingSet(bindings);
        filteredBindings.removeAll(problemVars);
        return filteredBindings;
    }
}

