/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.FilterIteration;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.SubQueryValueOperator;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator
extends FilterIteration<BindingSet, QueryEvaluationException> {
    private final Filter filter;
    private final EvaluationStrategy strategy;
    private final Set<String> scopeBindingNames;

    public FilterIterator(Filter filter, CloseableIteration<BindingSet, QueryEvaluationException> iter, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(iter);
        this.filter = filter;
        this.strategy = strategy;
        this.scopeBindingNames = filter.getBindingNames();
    }

    private boolean isPartOfSubQuery(QueryModelNode node) {
        if (node instanceof SubQueryValueOperator) {
            return true;
        }
        QueryModelNode parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        return this.isPartOfSubQuery(parent);
    }

    protected boolean accept(BindingSet bindings) throws QueryEvaluationException {
        try {
            QueryBindingSet scopeBindings = new QueryBindingSet(bindings);
            if (!this.isPartOfSubQuery((QueryModelNode)this.filter)) {
                scopeBindings.retainAll(this.scopeBindingNames);
            }
            return this.strategy.isTrue(this.filter.getCondition(), scopeBindings);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }
}

