/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.AttributeProcessor;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasTime;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementActionValue;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.model.exception.UncheckedException;

public class ProvUtilities {
    public List<Relation> getRelations(Document d) {
        return this.getObject(Relation.class, d.getStatementOrBundle());
    }

    public List<Entity> getEntity(Document d) {
        return this.getObject(Entity.class, d.getStatementOrBundle());
    }

    public List<Activity> getActivity(Document d) {
        return this.getObject(Activity.class, d.getStatementOrBundle());
    }

    public List<Agent> getAgent(Document d) {
        return this.getObject(Agent.class, d.getStatementOrBundle());
    }

    public List<Bundle> getBundle(Document d) {
        return this.getObject(Bundle.class, d.getStatementOrBundle());
    }

    public List<Relation> getRelations(Bundle d) {
        return this.getObject2(Relation.class, d.getStatement());
    }

    public List<Entity> getEntity(Bundle d) {
        return this.getObject2(Entity.class, d.getStatement());
    }

    public List<Activity> getActivity(Bundle d) {
        return this.getObject2(Activity.class, d.getStatement());
    }

    public List<Agent> getAgent(Bundle d) {
        return this.getObject2(Agent.class, d.getStatement());
    }

    public List<Bundle> getNamedBundle(Document d) {
        return this.getObject(Bundle.class, d.getStatementOrBundle());
    }

    public List<Statement> getStatement(Document d) {
        return this.getObject(Statement.class, d.getStatementOrBundle());
    }

    public List<Statement> getStatement(Bundle d) {
        List<Statement> res = d.getStatement();
        return res;
    }

    public <T> List<T> getObject(Class<T> cl, List<StatementOrBundle> ll) {
        LinkedList<StatementOrBundle> res = new LinkedList<StatementOrBundle>();
        for (StatementOrBundle o : ll) {
            if (!cl.isInstance(o)) continue;
            StatementOrBundle o2 = o;
            res.add(o2);
        }
        return res;
    }

    public <T> List<T> getObject2(Class<T> cl, List<Statement> ll) {
        LinkedList<Statement> res = new LinkedList<Statement>();
        for (Statement o : ll) {
            if (!cl.isInstance(o)) continue;
            Statement o2 = o;
            res.add(o2);
        }
        return res;
    }

    public QualifiedName getEffect(Relation r) {
        if (r instanceof Used) {
            return ((Used)r).getActivity();
        }
        if (r instanceof WasStartedBy) {
            return ((WasStartedBy)r).getActivity();
        }
        if (r instanceof WasEndedBy) {
            return ((WasEndedBy)r).getActivity();
        }
        if (r instanceof WasGeneratedBy) {
            return ((WasGeneratedBy)r).getEntity();
        }
        if (r instanceof WasDerivedFrom) {
            return ((WasDerivedFrom)r).getGeneratedEntity();
        }
        if (r instanceof WasAssociatedWith) {
            return ((WasAssociatedWith)r).getActivity();
        }
        if (r instanceof WasInvalidatedBy) {
            return ((WasInvalidatedBy)r).getEntity();
        }
        if (r instanceof WasAttributedTo) {
            return ((WasAttributedTo)r).getEntity();
        }
        if (r instanceof AlternateOf) {
            return ((AlternateOf)r).getAlternate1();
        }
        if (r instanceof SpecializationOf) {
            return ((SpecializationOf)r).getSpecificEntity();
        }
        if (r instanceof HadMember) {
            return ((HadMember)r).getCollection();
        }
        if (r instanceof WasInformedBy) {
            return ((WasInformedBy)r).getInformed();
        }
        if (r instanceof MentionOf) {
            return ((MentionOf)r).getSpecificEntity();
        }
        if (r instanceof WasInfluencedBy) {
            return ((WasInfluencedBy)r).getInfluencee();
        }
        if (r instanceof ActedOnBehalfOf) {
            return ((ActedOnBehalfOf)r).getDelegate();
        }
        if (r instanceof DerivedByInsertionFrom) {
            return ((DerivedByInsertionFrom)r).getNewDictionary();
        }
        System.out.println("Unknown relation " + r);
        throw new UnsupportedOperationException();
    }

    public QualifiedName getCause(Relation r) {
        if (r instanceof Used) {
            return ((Used)r).getEntity();
        }
        if (r instanceof WasGeneratedBy) {
            return ((WasGeneratedBy)r).getActivity();
        }
        if (r instanceof WasInvalidatedBy) {
            return ((WasInvalidatedBy)r).getActivity();
        }
        if (r instanceof WasStartedBy) {
            return ((WasStartedBy)r).getTrigger();
        }
        if (r instanceof WasEndedBy) {
            return ((WasEndedBy)r).getTrigger();
        }
        if (r instanceof WasDerivedFrom) {
            return ((WasDerivedFrom)r).getUsedEntity();
        }
        if (r instanceof WasInfluencedBy) {
            return ((WasInfluencedBy)r).getInfluencer();
        }
        if (r instanceof WasAssociatedWith) {
            return ((WasAssociatedWith)r).getAgent();
        }
        if (r instanceof WasAttributedTo) {
            return ((WasAttributedTo)r).getAgent();
        }
        if (r instanceof AlternateOf) {
            return ((AlternateOf)r).getAlternate2();
        }
        if (r instanceof SpecializationOf) {
            return ((SpecializationOf)r).getGeneralEntity();
        }
        if (r instanceof HadMember) {
            return ((HadMember)r).getEntity().get(0);
        }
        if (r instanceof MentionOf) {
            return ((MentionOf)r).getGeneralEntity();
        }
        if (r instanceof WasInformedBy) {
            return ((WasInformedBy)r).getInformant();
        }
        if (r instanceof ActedOnBehalfOf) {
            return ((ActedOnBehalfOf)r).getResponsible();
        }
        if (r instanceof DerivedByInsertionFrom) {
            return ((DerivedByInsertionFrom)r).getOldDictionary();
        }
        System.out.println("Unknown relation " + r);
        throw new UnsupportedOperationException();
    }

    public List<QualifiedName> getOtherCauses(Relation r) {
        if (r instanceof WasAssociatedWith) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            QualifiedName e = ((WasAssociatedWith)r).getPlan();
            if (e == null) {
                return null;
            }
            res.add(e);
            return res;
        }
        if (r instanceof WasStartedBy) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            QualifiedName a = ((WasStartedBy)r).getStarter();
            if (a == null) {
                return null;
            }
            res.add(a);
            return res;
        }
        if (r instanceof MentionOf) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            QualifiedName a = ((MentionOf)r).getBundle();
            if (a == null) {
                return null;
            }
            res.add(a);
            return res;
        }
        if (r instanceof HadMember) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            List<QualifiedName> entities = ((HadMember)r).getEntity();
            if (entities == null || entities.size() <= 1) {
                return null;
            }
            boolean first = true;
            for (QualifiedName ee : entities) {
                if (!first) {
                    res.add(ee);
                }
                first = false;
            }
            return res;
        }
        if (r instanceof WasEndedBy) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            QualifiedName a = ((WasEndedBy)r).getEnder();
            if (a == null) {
                return null;
            }
            res.add(a);
            return res;
        }
        if (r instanceof ActedOnBehalfOf) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            QualifiedName a = ((ActedOnBehalfOf)r).getActivity();
            if (a == null) {
                return null;
            }
            res.add(a);
            return res;
        }
        if (r instanceof DerivedByInsertionFrom) {
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            DerivedByInsertionFrom dbif = (DerivedByInsertionFrom)r;
            for (Entry entry : dbif.getKeyEntityPair()) {
                res.add(entry.getEntity());
            }
            return res;
        }
        return null;
    }

    public Hashtable<String, List<Other>> attributesWithNamespace(HasOther object, String namespace) {
        List<Other> ll = object.getOther();
        AttributeProcessor _attrs = new AttributeProcessor(ll);
        return _attrs.attributesWithNamespace(namespace);
    }

    public void forAllStatementOrBundle(List<StatementOrBundle> records, StatementAction action) {
        for (StatementOrBundle o : records) {
            this.doAction(o, action);
        }
    }

    public void forAllStatement(List<Statement> records, StatementAction action) {
        for (Statement o : records) {
            this.doAction((StatementOrBundle)o, action);
        }
    }

    public void doAction(StatementOrBundle s, StatementAction action) {
        switch (s.getKind()) {
            case PROV_ACTIVITY: {
                action.doAction((Activity)s);
                break;
            }
            case PROV_AGENT: {
                action.doAction((Agent)s);
                break;
            }
            case PROV_ALTERNATE: {
                action.doAction((AlternateOf)s);
                break;
            }
            case PROV_ASSOCIATION: {
                action.doAction((WasAssociatedWith)s);
                break;
            }
            case PROV_ATTRIBUTION: {
                action.doAction((WasAttributedTo)s);
                break;
            }
            case PROV_BUNDLE: {
                action.doAction((Bundle)s, this);
                break;
            }
            case PROV_COMMUNICATION: {
                action.doAction((WasInformedBy)s);
                break;
            }
            case PROV_DELEGATION: {
                action.doAction((ActedOnBehalfOf)s);
                break;
            }
            case PROV_DERIVATION: {
                action.doAction((WasDerivedFrom)s);
                break;
            }
            case PROV_DICTIONARY_INSERTION: {
                action.doAction((DerivedByInsertionFrom)s);
                break;
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                action.doAction((DictionaryMembership)s);
                break;
            }
            case PROV_DICTIONARY_REMOVAL: {
                action.doAction((DerivedByRemovalFrom)s);
                break;
            }
            case PROV_END: {
                action.doAction((WasEndedBy)s);
                break;
            }
            case PROV_ENTITY: {
                action.doAction((Entity)s);
                break;
            }
            case PROV_GENERATION: {
                action.doAction((WasGeneratedBy)s);
                break;
            }
            case PROV_INFLUENCE: {
                action.doAction((WasInfluencedBy)s);
                break;
            }
            case PROV_INVALIDATION: {
                action.doAction((WasInvalidatedBy)s);
                break;
            }
            case PROV_MEMBERSHIP: {
                action.doAction((HadMember)s);
                break;
            }
            case PROV_MENTION: {
                action.doAction((MentionOf)s);
                break;
            }
            case PROV_SPECIALIZATION: {
                action.doAction((SpecializationOf)s);
                break;
            }
            case PROV_START: {
                action.doAction((WasStartedBy)s);
                break;
            }
            case PROV_USAGE: {
                action.doAction((Used)s);
            }
        }
    }

    public Object doAction(StatementOrBundle s, StatementActionValue action) {
        switch (s.getKind()) {
            case PROV_ACTIVITY: {
                return action.doAction((Activity)s);
            }
            case PROV_AGENT: {
                return action.doAction((Agent)s);
            }
            case PROV_ALTERNATE: {
                return action.doAction((AlternateOf)s);
            }
            case PROV_ASSOCIATION: {
                return action.doAction((WasAssociatedWith)s);
            }
            case PROV_ATTRIBUTION: {
                return action.doAction((WasAttributedTo)s);
            }
            case PROV_BUNDLE: {
                return action.doAction((Bundle)s, this);
            }
            case PROV_COMMUNICATION: {
                return action.doAction((WasInformedBy)s);
            }
            case PROV_DELEGATION: {
                return action.doAction((ActedOnBehalfOf)s);
            }
            case PROV_DERIVATION: {
                return action.doAction((WasDerivedFrom)s);
            }
            case PROV_DICTIONARY_INSERTION: {
                return action.doAction((DerivedByInsertionFrom)s);
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                return action.doAction((DictionaryMembership)s);
            }
            case PROV_DICTIONARY_REMOVAL: {
                return action.doAction((DerivedByRemovalFrom)s);
            }
            case PROV_END: {
                return action.doAction((WasEndedBy)s);
            }
            case PROV_ENTITY: {
                return action.doAction((Entity)s);
            }
            case PROV_GENERATION: {
                return action.doAction((WasGeneratedBy)s);
            }
            case PROV_INFLUENCE: {
                return action.doAction((WasInfluencedBy)s);
            }
            case PROV_INVALIDATION: {
                return action.doAction((WasInvalidatedBy)s);
            }
            case PROV_MEMBERSHIP: {
                return action.doAction((HadMember)s);
            }
            case PROV_MENTION: {
                return action.doAction((MentionOf)s);
            }
            case PROV_SPECIALIZATION: {
                return action.doAction((SpecializationOf)s);
            }
            case PROV_START: {
                return action.doAction((WasStartedBy)s);
            }
            case PROV_USAGE: {
                return action.doAction((Used)s);
            }
        }
        throw new InvalidCaseException("Statement Kind: " + (Object)((Object)s.getKind()));
    }

    public static String unescape(String s) {
        return s.replace("\\\"", "\"");
    }

    public static String valueToNotationString(Key key) {
        return ProvUtilities.valueToNotationString(key.getValue(), key.getType());
    }

    public static String escape(String s) {
        return s.replace("\"", "\\\"");
    }

    public static String valueToNotationString(Object val, QualifiedName xsdType) {
        if (val instanceof LangString) {
            LangString istring = (LangString)val;
            return "\"" + istring.getValue() + (istring.getLang() == null ? "\"" : "\"@" + istring.getLang()) + (xsdType == null ? "" : " %% " + Namespace.qualifiedNameToStringWithNamespace(xsdType));
        }
        if (val instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)val;
            return "'" + Namespace.qualifiedNameToStringWithNamespace(qn) + "'";
        }
        if (val instanceof String) {
            String s = (String)val;
            if (s.contains("\n")) {
                return "\"\"\"" + ProvUtilities.escape(s) + "\"\"\"";
            }
            return "\"" + ProvUtilities.escape(s) + (xsdType == null ? "" : "\" %% " + Namespace.qualifiedNameToStringWithNamespace(xsdType));
        }
        return "\"" + val + "\" %% " + Namespace.qualifiedNameToStringWithNamespace(xsdType);
    }

    public static boolean hasType(QualifiedName type, Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            switch (attribute.getKind()) {
                case PROV_TYPE: {
                    if (!attribute.getValue().equals(type)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getter(Statement s, int i) {
        StatementOrBundle.Kind kind = s.getKind();
        switch (kind) {
            case PROV_ACTIVITY: {
                Activity a = (Activity)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getStartTime();
                    }
                    case 2: {
                        return a.getEndTime();
                    }
                    case 3: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_AGENT: {
                Agent a = (Agent)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ALTERNATE: {
                AlternateOf a = (AlternateOf)s;
                switch (i) {
                    case 0: {
                        return a.getAlternate1();
                    }
                    case 1: {
                        return a.getAlternate2();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ASSOCIATION: {
                WasAssociatedWith a = (WasAssociatedWith)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getActivity();
                    }
                    case 2: {
                        return a.getAgent();
                    }
                    case 3: {
                        return a.getPlan();
                    }
                    case 4: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ATTRIBUTION: {
                WasAttributedTo a = (WasAttributedTo)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getEntity();
                    }
                    case 2: {
                        return a.getAgent();
                    }
                    case 3: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_BUNDLE: {
                throw new InvalidCaseException("ProvUtilities.getter() for " + (Object)((Object)kind));
            }
            case PROV_COMMUNICATION: {
                WasInformedBy a = (WasInformedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getInformed();
                    }
                    case 2: {
                        return a.getInformant();
                    }
                    case 3: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DELEGATION: {
                ActedOnBehalfOf a = (ActedOnBehalfOf)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getDelegate();
                    }
                    case 2: {
                        return a.getResponsible();
                    }
                    case 3: {
                        return a.getActivity();
                    }
                    case 4: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DERIVATION: {
                WasDerivedFrom a = (WasDerivedFrom)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getGeneratedEntity();
                    }
                    case 2: {
                        return a.getUsedEntity();
                    }
                    case 3: {
                        return a.getActivity();
                    }
                    case 4: {
                        return a.getGeneration();
                    }
                    case 5: {
                        return a.getUsage();
                    }
                    case 6: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DICTIONARY_INSERTION: {
                throw new InvalidCaseException("ProvUtilities.getter() for " + (Object)((Object)kind));
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new InvalidCaseException("ProvUtilities.getter() for " + (Object)((Object)kind));
            }
            case PROV_DICTIONARY_REMOVAL: {
                throw new InvalidCaseException("ProvUtilities.getter() for " + (Object)((Object)kind));
            }
            case PROV_END: {
                WasEndedBy a = (WasEndedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getActivity();
                    }
                    case 2: {
                        return a.getTrigger();
                    }
                    case 3: {
                        return a.getEnder();
                    }
                    case 4: {
                        return a.getTime();
                    }
                    case 5: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ENTITY: {
                Entity a = (Entity)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_GENERATION: {
                WasGeneratedBy a = (WasGeneratedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getEntity();
                    }
                    case 2: {
                        return a.getActivity();
                    }
                    case 3: {
                        return a.getTime();
                    }
                    case 4: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_INFLUENCE: {
                WasInfluencedBy a = (WasInfluencedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getInfluencee();
                    }
                    case 2: {
                        return a.getInfluencer();
                    }
                    case 3: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_INVALIDATION: {
                WasInvalidatedBy a = (WasInvalidatedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getEntity();
                    }
                    case 2: {
                        return a.getActivity();
                    }
                    case 3: {
                        return a.getTime();
                    }
                    case 4: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_MEMBERSHIP: {
                HadMember a = (HadMember)s;
                switch (i) {
                    case 0: {
                        return a.getCollection();
                    }
                    case 1: {
                        return a.getEntity();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_MENTION: {
                MentionOf a = (MentionOf)s;
                switch (i) {
                    case 0: {
                        throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
                    }
                    case 1: {
                        return a.getSpecificEntity();
                    }
                    case 2: {
                        return a.getGeneralEntity();
                    }
                    case 3: {
                        return a.getBundle();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_SPECIALIZATION: {
                SpecializationOf a = (SpecializationOf)s;
                switch (i) {
                    case 0: {
                        return a.getSpecificEntity();
                    }
                    case 1: {
                        return a.getGeneralEntity();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_START: {
                WasStartedBy a = (WasStartedBy)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getActivity();
                    }
                    case 2: {
                        return a.getTrigger();
                    }
                    case 3: {
                        return a.getStarter();
                    }
                    case 4: {
                        return a.getTime();
                    }
                    case 5: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_USAGE: {
                Used a = (Used)s;
                switch (i) {
                    case 0: {
                        return a.getId();
                    }
                    case 1: {
                        return a.getActivity();
                    }
                    case 2: {
                        return a.getEntity();
                    }
                    case 3: {
                        return a.getTime();
                    }
                    case 4: {
                        return a.getOther();
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.getter() for " + (Object)((Object)kind) + " and index " + i);
            }
        }
        throw new InvalidCaseException("ProvUtilities.getter() for " + (Object)((Object)kind));
    }

    public void setter(Statement s, int i, Object val) {
        StatementOrBundle.Kind kind = s.getKind();
        switch (kind) {
            case PROV_ACTIVITY: {
                Activity a = (Activity)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setStartTime((XMLGregorianCalendar)val);
                        return;
                    }
                    case 2: {
                        a.setEndTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_AGENT: {
                Agent a = (Agent)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ALTERNATE: {
                AlternateOf a = (AlternateOf)s;
                switch (i) {
                    case 0: {
                        a.setAlternate1((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setAlternate2((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ASSOCIATION: {
                WasAssociatedWith a = (WasAssociatedWith)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setAgent((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setPlan((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ATTRIBUTION: {
                WasAttributedTo a = (WasAttributedTo)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setEntity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setAgent((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_BUNDLE: {
                throw new InvalidCaseException("ProvUtilities.setter() for " + (Object)((Object)kind));
            }
            case PROV_COMMUNICATION: {
                WasInformedBy a = (WasInformedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setInformed((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setInformant((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DELEGATION: {
                ActedOnBehalfOf a = (ActedOnBehalfOf)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setDelegate((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setResponsible((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DERIVATION: {
                WasDerivedFrom a = (WasDerivedFrom)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setGeneratedEntity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setUsedEntity((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 4: {
                        a.setGeneration((QualifiedName)val);
                        return;
                    }
                    case 5: {
                        a.setUsage((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_DICTIONARY_INSERTION: {
                throw new InvalidCaseException("ProvUtilities.setter() for " + (Object)((Object)kind));
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new InvalidCaseException("ProvUtilities.setter() for " + (Object)((Object)kind));
            }
            case PROV_DICTIONARY_REMOVAL: {
                throw new InvalidCaseException("ProvUtilities.setter() for " + (Object)((Object)kind));
            }
            case PROV_END: {
                WasEndedBy a = (WasEndedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setTrigger((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setEnder((QualifiedName)val);
                        return;
                    }
                    case 4: {
                        a.setTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_ENTITY: {
                Entity a = (Entity)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_GENERATION: {
                WasGeneratedBy a = (WasGeneratedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setEntity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_INFLUENCE: {
                WasInfluencedBy a = (WasInfluencedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setInfluencee((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setInfluencer((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_INVALIDATION: {
                WasInvalidatedBy a = (WasInvalidatedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setEntity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_MEMBERSHIP: {
                HadMember a = (HadMember)s;
                switch (i) {
                    case 0: {
                        a.setCollection((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.getEntity().remove(0);
                        a.getEntity().add((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_MENTION: {
                MentionOf a = (MentionOf)s;
                switch (i) {
                    case 0: {
                        throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
                    }
                    case 1: {
                        a.setSpecificEntity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setGeneralEntity((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setBundle((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_SPECIALIZATION: {
                SpecializationOf a = (SpecializationOf)s;
                switch (i) {
                    case 0: {
                        a.setSpecificEntity((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setGeneralEntity((QualifiedName)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_START: {
                WasStartedBy a = (WasStartedBy)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setTrigger((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setStarter((QualifiedName)val);
                        return;
                    }
                    case 4: {
                        a.setTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
            case PROV_USAGE: {
                Used a = (Used)s;
                switch (i) {
                    case 0: {
                        a.setId((QualifiedName)val);
                        return;
                    }
                    case 1: {
                        a.setActivity((QualifiedName)val);
                        return;
                    }
                    case 2: {
                        a.setEntity((QualifiedName)val);
                        return;
                    }
                    case 3: {
                        a.setTime((XMLGregorianCalendar)val);
                        return;
                    }
                }
                throw new ArrayIndexOutOfBoundsException("ProvUtilities.setter() for " + (Object)((Object)kind) + " and index " + i);
            }
        }
        throw new InvalidCaseException("ProvUtilities.setter() for " + (Object)((Object)kind));
    }

    public boolean hasNoTime(Statement o) {
        if (o instanceof HasTime) {
            return false;
        }
        return !(o instanceof Activity);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gCalendar = new GregorianCalendar();
        gCalendar.setTime(date);
        XMLGregorianCalendar xmlCalendar = null;
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
        }
        catch (DatatypeConfigurationException ex) {
            ex.printStackTrace();
            throw new UncheckedException(ex);
        }
        return xmlCalendar;
    }

    public static Date toDate(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toGregorianCalendar().getTime();
    }
}

