/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.DateTimeColumn;
import org.openrdf.sail.rdbms.algebra.NumberValue;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.managers.LiteralManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;

    public SqlExpr createTimeExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit((QueryModelVisitor)this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    public void meet(Datatype node) {
        this.result = SqlExprSupport.sqlNull();
    }

    public void meet(Lang node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    public void meet(MathExpr node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    public void meet(Str node) {
        this.result = SqlExprSupport.sqlNull();
    }

    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    public void meet(Var node) {
        this.result = node.getValue() == null ? new DateTimeColumn(node) : this.valueOf(node.getValue());
    }

    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    private SqlExpr valueOf(Value value) {
        Literal lit;
        URI dt;
        if (value instanceof Literal && (dt = (lit = (Literal)value).getDatatype()) != null && XMLDatatypeUtil.isCalendarDatatype((URI)dt)) {
            try {
                return new NumberValue(LiteralManager.getCalendarValue(lit.calendarValue()));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

