/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.binary.BinaryQueryResultConstants;
import org.openrdf.query.resultio.binary.QueryErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryQueryResultWriter
implements TupleQueryResultWriter {
    private DataOutputStream out;
    private CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
    private Map<String, Integer> namespaceTable = new HashMap<String, Integer>(32);
    private int nextNamespaceID;
    private BindingSet previousBindings;
    private List<String> bindingNames;

    public BinaryQueryResultWriter(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.BINARY;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        bindingNames = new ArrayList<String>(bindingNames);
        this.bindingNames = Collections.unmodifiableList(bindingNames);
        try {
            this.out.write(BinaryQueryResultConstants.MAGIC_NUMBER);
            this.out.writeInt(4);
            this.out.writeInt(this.bindingNames.size());
            for (String bindingName : this.bindingNames) {
                this.writeString(bindingName);
            }
            List<Value> nullTuple = Collections.nCopies(this.bindingNames.size(), null);
            this.previousBindings = new ListBindingSet(this.bindingNames, nullTuple);
            this.nextNamespaceID = 0;
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.out.writeByte(127);
            this.out.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (bindingSet.size() == 0) {
                this.writeEmptyRow();
            } else {
                for (String bindingName : this.bindingNames) {
                    Value value = bindingSet.getValue(bindingName);
                    if (value == null) {
                        this.writeNull();
                        continue;
                    }
                    if (value.equals(this.previousBindings.getValue(bindingName))) {
                        this.writeRepeat();
                        continue;
                    }
                    if (value instanceof URI) {
                        this.writeQName((URI)value);
                        continue;
                    }
                    if (value instanceof BNode) {
                        this.writeBNode((BNode)value);
                        continue;
                    }
                    if (value instanceof Literal) {
                        this.writeLiteral((Literal)value);
                        continue;
                    }
                    throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
                }
                this.previousBindings = bindingSet;
            }
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    private void writeNull() throws IOException {
        this.out.writeByte(0);
    }

    private void writeRepeat() throws IOException {
        this.out.writeByte(1);
    }

    private void writeEmptyRow() throws IOException {
        this.out.writeByte(9);
    }

    private void writeQName(URI uri) throws IOException {
        String namespace = uri.getNamespace();
        Integer nsID = this.namespaceTable.get(namespace);
        if (nsID == null) {
            nsID = this.writeNamespace(namespace);
        }
        this.out.writeByte(3);
        this.out.writeInt(nsID);
        this.writeString(uri.getLocalName());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.out.writeByte(5);
        this.writeString(bnode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        String language = literal.getLanguage();
        URI datatype = literal.getDatatype();
        int marker = 6;
        if (datatype != null) {
            String namespace = datatype.getNamespace();
            if (!this.namespaceTable.containsKey(namespace)) {
                this.writeNamespace(namespace);
            }
            marker = 8;
        } else if (language != null) {
            marker = 7;
        }
        this.out.writeByte(marker);
        this.writeString(label);
        if (datatype != null) {
            this.writeQName(datatype);
        } else if (language != null) {
            this.writeString(language);
        }
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        this.out.writeByte(126);
        if (errType == QueryErrorType.MALFORMED_QUERY_ERROR) {
            this.out.writeByte(1);
        } else {
            this.out.writeByte(2);
        }
        this.writeString(msg);
    }

    private Integer writeNamespace(String namespace) throws IOException {
        this.out.writeByte(2);
        this.out.writeInt(this.nextNamespaceID);
        this.writeString(namespace);
        Integer result = new Integer(this.nextNamespaceID);
        this.namespaceTable.put(namespace, result);
        ++this.nextNamespaceID;
        return result;
    }

    private void writeString(String s) throws IOException {
        ByteBuffer byteBuf = this.charsetEncoder.encode(CharBuffer.wrap(s));
        this.out.writeInt(byteBuf.remaining());
        this.out.write(byteBuf.array(), 0, byteBuf.remaining());
    }
}

