/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.generator;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.openprovenance.prov.generator.GeneratorDetails;
import org.openprovenance.prov.generator.Tree;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;

public class GraphGenerator {
    public static final String TERM_PREFIX = "term";
    public static final String TERM_NS = "http://openprovenance.org/term/";
    public static final String FIRST_NODE_AS_ACTIVITY = "activity";
    public static final String FIRST_NODE_AS_ENTITY = "entity";
    private static int NO_OF_EDGES = 4;
    private Tree<String> graph = null;
    private LinkedList<String> list = null;
    private int noOfNodes = 10;
    private int noOfEdges = NO_OF_EDGES;
    private int count = 1;
    private String root = "e1";
    private final int ENTITY = 1;
    private final int ACTIVITY = 2;
    private final int AGENT = 3;
    private final ProvFactory pf;
    private final Random randomGenerator;
    private final Long seed;
    private final String namespace;
    private String term;
    private String firstNode;

    public GraphGenerator(GeneratorDetails details, ProvFactory pf) {
        this(details.getNumberOfNodes(), details.getNumberOfEdges(), details.getFirstNode(), details.getNamespace(), pf, details.getSeed(), details.getTermToAnnotate());
    }

    public GraphGenerator(int noOfNodes, int noOfEdges, String firstNode, String namespace, ProvFactory pf) {
        this(noOfNodes, noOfEdges, firstNode, namespace, pf, null, null);
    }

    public GraphGenerator(int noOfNodes, int noOfEdges, String firstNode, String namespace, ProvFactory pf, Long seed, String term) {
        this.firstNode = firstNode;
        if (FIRST_NODE_AS_ACTIVITY.equals(firstNode)) {
            this.root = "a1";
        }
        this.graph = new Tree<String>(this.root);
        this.list = new LinkedList();
        this.noOfNodes = noOfNodes;
        this.noOfEdges = noOfEdges;
        this.namespace = namespace;
        this.pf = pf;
        if (seed == null) {
            this.seed = new Random().nextLong();
            this.randomGenerator = new Random(this.seed);
        } else {
            this.seed = seed;
            this.randomGenerator = new Random(seed);
        }
        System.out.println("GraphGenerator seed: " + this.seed);
        this.term = term;
    }

    private void addElement(String root_, String node) {
        this.graph.addLeaf(root_, node);
        this.list.add(node);
    }

    public long getSeed() {
        return this.seed;
    }

    public void generateElements() {
        String node = "";
        int nd = 1;
        this.list.add(this.root);
        while (!this.list.isEmpty()) {
            int n;
            String root_ = this.list.pollFirst();
            if (root_.startsWith("e") || root_.startsWith("a")) {
                n = this.randomGenerator.nextInt(this.noOfEdges) + 1;
                block7: for (int i = 0; i < n; ++i) {
                    switch (nd) {
                        case 1: {
                            ++this.count;
                            node = "e" + this.count;
                            this.addElement(root_, node);
                            nd = 2;
                            continue block7;
                        }
                        case 2: {
                            ++this.count;
                            node = "a" + this.count;
                            this.addElement(root_, node);
                            nd = 3;
                            if (this.count % 3 != 0) continue block7;
                            nd = 1;
                            continue block7;
                        }
                        case 3: {
                            ++this.count;
                            n = this.randomGenerator.nextInt(2);
                            node = n == 1 ? "g" + this.count : "e" + this.count;
                            this.addElement(root_, node);
                            nd = 0;
                            continue block7;
                        }
                        case 0: {
                            if (this.list.size() > 0) {
                                int nn = this.list.size() - this.randomGenerator.nextInt(this.list.size());
                                node = nn < this.list.size() ? "*" + this.list.get(nn) : "*" + this.list.peek();
                                Collection<String> c = this.graph.getSuccessors(root_);
                                if (!c.contains(node.substring(1))) {
                                    this.graph.addLeaf(root_, node);
                                }
                            }
                            nd = 1;
                        }
                    }
                }
            } else if (root_.startsWith("g") && (n = this.randomGenerator.nextInt(3)) == 1) {
                ++this.count;
                node = "g" + this.count;
                this.addElement(root_, node);
            }
            if (this.count < this.noOfNodes) continue;
            break;
        }
    }

    public int getCount() {
        return this.count;
    }

    private void getElements(String root, Tree<String> graph, Namespace ns, List<Statement> ll) {
        Collection<String> sucessors;
        if (!root.startsWith("*")) {
            if (root.startsWith("e")) {
                ll.add((Statement)this.pf.newEntity(ns.stringToQualifiedName(root, this.pf)));
            } else if (root.startsWith("a")) {
                ll.add((Statement)this.pf.newActivity(ns.stringToQualifiedName(root, this.pf)));
            } else if (root.startsWith("g")) {
                ll.add((Statement)this.pf.newAgent(ns.stringToQualifiedName(root, this.pf)));
            }
        }
        if (!(sucessors = graph.getSuccessors(root)).isEmpty()) {
            for (String node : sucessors) {
                String node1;
                this.getElements(node, graph, ns, ll);
                if (root.startsWith("e")) {
                    if (node.startsWith("e")) {
                        ll.add((Statement)this.pf.newWasDerivedFrom(ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (node.startsWith("a")) {
                        ll.add((Statement)this.pf.newWasGeneratedBy(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (node.startsWith("g")) {
                        ll.add((Statement)this.pf.newWasAttributedTo(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (!node.startsWith("*")) continue;
                    node1 = node.substring(1);
                    if (node1.startsWith("e")) {
                        ll.add((Statement)this.pf.newWasDerivedFrom(ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                        continue;
                    }
                    if (node1.startsWith("a")) {
                        ll.add((Statement)this.pf.newWasGeneratedBy(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                        continue;
                    }
                    if (!node1.startsWith("g")) continue;
                    ll.add((Statement)this.pf.newWasAttributedTo(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                    continue;
                }
                if (root.startsWith("a")) {
                    if (node.startsWith("e")) {
                        ll.add((Statement)this.pf.newUsed(ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (node.startsWith("a")) {
                        ll.add((Statement)this.pf.newWasInformedBy(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (node.startsWith("g")) {
                        ll.add((Statement)this.pf.newWasAssociatedWith(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
                        continue;
                    }
                    if (!node.startsWith("*")) continue;
                    node1 = node.substring(1);
                    if (node1.startsWith("e")) {
                        ll.add((Statement)this.pf.newUsed(ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                        continue;
                    }
                    if (node1.startsWith("a")) {
                        ll.add((Statement)this.pf.newWasInformedBy(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                        continue;
                    }
                    if (!node1.startsWith("g")) continue;
                    ll.add((Statement)this.pf.newWasAssociatedWith(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node1, this.pf)));
                    continue;
                }
                if (!root.startsWith("g") || !node.startsWith("g")) continue;
                ll.add((Statement)this.pf.newActedOnBehalfOf(null, ns.stringToQualifiedName(root, this.pf), ns.stringToQualifiedName(node, this.pf)));
            }
        }
    }

    public Document getDocument() {
        this.root = this.graph.getHead();
        Document doc = this.pf.newDocument();
        Namespace ns = new Namespace();
        ns.setDefaultNamespace(this.namespace);
        LinkedList<Statement> statements = new LinkedList<Statement>();
        this.getElements(this.root, this.graph, ns, statements);
        doc.getStatementOrBundle().addAll(statements);
        doc.setNamespace(ns);
        if (this.term != null) {
            this.addSeed(doc, this.seed, this.term);
        }
        return doc;
    }

    public GeneratorDetails getDetails() {
        GeneratorDetails details = new GeneratorDetails(this.noOfNodes, this.noOfEdges, this.firstNode, this.namespace, this.seed, this.firstNode);
        details.setDocument(this.getDocument());
        return details;
    }

    public void addSeed(Document doc, long seed, String name) {
        Namespace namespace = doc.getNamespace();
        QualifiedName qn = namespace.stringToQualifiedName(name, this.pf);
        for (StatementOrBundle statement : doc.getStatementOrBundle()) {
            Identifiable ss;
            if (!(statement instanceof Identifiable) || (ss = (Identifiable)statement).getId() == null || !ss.getId().equals((Object)qn)) continue;
            namespace.register(TERM_PREFIX, TERM_NS);
            namespace.addKnownNamespaces();
            ((HasOther)ss).getOther().add(this.pf.newOther(TERM_NS, "seed", TERM_PREFIX, (Object)seed, this.pf.getName().XSD_LONG));
            return;
        }
    }
}

