/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.tsv;

import info.aduna.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParserBase;

public class SPARQLResultsTSVParser
extends TupleQueryResultParserBase {
    private List<String> bindingNames;

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        String nextLine;
        InputStreamReader r = new InputStreamReader(in, Charset.forName("UTF-8"));
        BufferedReader reader = new BufferedReader(r);
        while ((nextLine = reader.readLine()) != null) {
            if (this.bindingNames == null) {
                String[] names = nextLine.split("\t", -1);
                this.bindingNames = new ArrayList<String>(names.length);
                for (String name : names) {
                    this.bindingNames.add(name.substring(1));
                }
                this.handler.startQueryResult(this.bindingNames);
                continue;
            }
            String[] lineTokens = nextLine.split("\t", -1);
            ArrayList<BNode> values = new ArrayList<BNode>();
            for (String valueString : lineTokens) {
                BNode v = null;
                if (valueString.startsWith("_:")) {
                    v = this.valueFactory.createBNode(valueString.substring(2));
                } else if (valueString.startsWith("<")) {
                    try {
                        v = this.valueFactory.createURI(valueString.substring(1, valueString.length() - 1));
                    }
                    catch (IllegalArgumentException e) {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                } else if (valueString.startsWith("\"")) {
                    v = this.parseLiteral(valueString);
                } else if (!"".equals(valueString)) {
                    if (valueString.matches("^[\\+\\-]?[\\d\\.].*")) {
                        URI datatype = null;
                        if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
                            datatype = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                        } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
                            datatype = XMLSchema.DECIMAL;
                        } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
                            datatype = XMLSchema.DOUBLE;
                        }
                        v = datatype != null ? this.valueFactory.createLiteral(valueString, datatype) : this.valueFactory.createLiteral(valueString);
                    } else {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                }
                values.add(v);
            }
            ListBindingSet bindingSet = new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
            this.handler.handleSolution((BindingSet)bindingSet);
        }
    }

    protected Literal parseLiteral(String literal) throws IllegalArgumentException {
        int endLabelIdx;
        if (literal.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(literal)) != -1) {
            int startLangIdx = literal.indexOf("@", endLabelIdx);
            int startDtIdx = literal.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = literal.substring(1, endLabelIdx);
            label = this.unescapeString(label);
            if (startLangIdx != -1) {
                String language = literal.substring(startLangIdx + 1);
                return this.valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = literal.substring(startDtIdx + 2);
                datatype = datatype.substring(1, datatype.length() - 1);
                URI dtURI = this.valueFactory.createURI(datatype);
                return this.valueFactory.createLiteral(label, dtURI);
            }
            return this.valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal literal: " + literal);
    }

    private int findEndOfLabel(String literal) {
        return literal.lastIndexOf("\"");
    }

    private String unescapeString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"", (String)s);
        return s;
    }
}

