/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.model.Project;
import com.google.refine.model.ProjectStub;
import com.google.refine.process.ProcessManager;
import java.time.LocalDateTime;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ProjectManagerTests
extends RefineTest {
    ProjectManagerStub pm;
    ProjectManagerStub SUT;
    Project project;
    ProjectMetadata metadata;
    ProcessManager procmgr;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.pm = new ProjectManagerStub();
        this.SUT = (ProjectManagerStub)((Object)Mockito.spy((Object)((Object)this.pm)));
        this.project = (Project)Mockito.mock(Project.class);
        this.metadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        this.procmgr = (ProcessManager)Mockito.mock(ProcessManager.class);
        Mockito.when((Object)this.project.getProcessManager()).thenReturn((Object)this.procmgr);
        Mockito.when((Object)this.procmgr.hasPending()).thenReturn((Object)false);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.metadata = null;
        this.project = null;
        this.SUT = null;
        this.pm = null;
    }

    @Test
    public void canRegisterProject() {
        this.SUT.registerProject(this.project, this.metadata);
        this.AssertProjectRegistered();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void canEnsureProjectSave() {
        this.whenGetSaveTimes(this.project, this.metadata);
        this.registerProject();
        this.SUT.ensureProjectSaved(this.project.id);
        this.AssertProjectRegistered();
        try {
            ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveMetadata(this.metadata, this.project.id);
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.verifySaveTimeCompared(1);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveProject(this.project);
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void canSaveAllModified() {
        this.whenGetSaveTimes(this.project, this.metadata);
        this.registerProject(this.project, this.metadata);
        Project project2 = (Project)Mockito.spy((Object)((Object)new ProjectStub(2L)));
        ProjectMetadata metadata2 = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        this.whenGetSaveTimes(project2, metadata2, 10);
        this.registerProject(project2, metadata2);
        Assert.assertFalse((this.project.id == project2.id ? 1 : 0) != 0);
        this.SUT.save(true);
        this.verifySaved(this.project, this.metadata);
        this.verifySaved(project2, metadata2);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    @Test
    public void canFlushFromCache() {
        this.whenGetSaveTimes(this.project, this.metadata, -10);
        this.registerProject(this.project, this.metadata);
        Assert.assertSame((Object)this.SUT.getProject(0L), (Object)this.project);
        this.SUT.save(true);
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getModified();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.times((int)1))).getProcessManager();
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.times((int)2))).getLastSave();
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.times((int)1))).dispose();
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveProject(this.project);
        Assert.assertEquals((Object)this.SUT.getProject(0L), null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    @Test
    public void cannotSaveWhenBusy() {
        this.registerProject();
        this.SUT.setBusy(true);
        this.SUT.save(false);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveProjects(Mockito.anyBoolean());
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveWorkspace();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void canSaveSomeModified() {
        this.registerProject();
        this.whenGetSaveTimes(this.project, this.metadata);
        this.SUT.save(false);
        this.verifySaved(this.project, this.metadata);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    protected void registerProject() {
        this.registerProject(this.project, this.metadata);
    }

    protected void registerProject(Project proj, ProjectMetadata meta) {
        this.SUT.registerProject(proj, meta);
    }

    protected void AssertProjectRegistered() {
        Assert.assertEquals((Object)this.SUT.getProject(this.project.id), (Object)this.project);
        Assert.assertEquals((Object)this.SUT.getProjectMetadata(this.project.id), (Object)this.metadata);
    }

    protected void whenGetSaveTimes(Project proj, ProjectMetadata meta) {
        this.whenGetSaveTimes(proj, meta, 5);
    }

    protected void whenGetSaveTimes(Project proj, ProjectMetadata meta, int secondsDifference) {
        this.whenProjectGetLastSave(proj);
        this.whenMetadataGetModified(meta, secondsDifference);
    }

    protected void whenProjectGetLastSave(Project proj) {
        LocalDateTime projectLastSaveDate = LocalDateTime.of(1970, 1, 2, 0, 30, 0);
        Mockito.when((Object)proj.getLastSave()).thenReturn((Object)projectLastSaveDate);
    }

    protected void whenMetadataGetModified(ProjectMetadata meta) {
        this.whenMetadataGetModified(meta, 300);
    }

    protected void whenMetadataGetModified(ProjectMetadata meta, int secondsDifference) {
        LocalDateTime metadataModifiedDate = LocalDateTime.of(1970, 1, 2, 0, 30 + secondsDifference);
        Mockito.when((Object)meta.getModified()).thenReturn((Object)metadataModifiedDate);
    }

    protected void verifySaveTimeCompared(int times) {
        this.verifySaveTimeCompared(this.project, this.metadata, times);
    }

    protected void verifySaveTimeCompared(Project project, ProjectMetadata metadata, int times) {
        ((ProjectMetadata)Mockito.verify((Object)metadata, (VerificationMode)Mockito.times((int)times))).getModified();
        ((Project)Mockito.verify((Object)project, (VerificationMode)Mockito.times((int)times))).getLastSave();
    }

    protected void verifySaved(Project proj, ProjectMetadata meta) {
        ((ProjectMetadata)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).getModified();
        ((Project)Mockito.verify((Object)proj, (VerificationMode)Mockito.times((int)2))).getLastSave();
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveProject(proj);
        ((ProjectMetadata)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).getTags();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{proj});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{meta});
    }
}

