/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.RefineServletStub;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import com.google.refine.importers.SeparatorBasedImporter;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.io.FileProjectManager;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class RefineTest {
    protected static Properties bindings = null;
    protected Logger logger;
    boolean testFailed;
    protected File workspaceDir;
    protected RefineServlet servlet;
    private List<Project> projects = new ArrayList<Project>();
    private List<ImportingJob> importingJobs = new ArrayList<ImportingJob>();

    @BeforeSuite
    public void init() {
        System.setProperty("log4j.configuration", "tests.log4j.properties");
        try {
            this.workspaceDir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
            File jsonPath = new File(this.workspaceDir, "workspace.json");
            FileUtils.writeStringToFile((File)jsonPath, (String)"{\"projectIDs\":[]\n,\"preferences\":{\"entries\":{\"scripting.starred-expressions\":{\"class\":\"com.google.refine.preference.TopList\",\"top\":2147483647,\"list\":[]},\"scripting.expressions\":{\"class\":\"com.google.refine.preference.TopList\",\"top\":100,\"list\":[]}}}}", (String)"UTF-8");
            FileProjectManager.initialize((File)this.workspaceDir);
        }
        catch (IOException e) {
            this.workspaceDir = null;
            e.printStackTrace();
        }
        this.testFailed = false;
    }

    @BeforeMethod
    protected void initProjectManager() {
        this.servlet = new RefineServletStub();
        ProjectManager.singleton = new ProjectManagerStub();
        ImportingManager.initialize((RefineServlet)this.servlet);
    }

    protected Project createProjectWithColumns(String projectName, String ... columnNames) throws IOException, ModelException {
        Project project = new Project();
        ProjectMetadata pm = new ProjectMetadata();
        pm.setName(projectName);
        ProjectManager.singleton.registerProject(project, pm);
        if (columnNames != null) {
            for (String columnName : columnNames) {
                int index = project.columnModel.allocateNewCellIndex();
                Column column = new Column(index, columnName);
                project.columnModel.addColumn(index, column, true);
            }
        }
        return project;
    }

    protected Project createCSVProject(String input) {
        return this.createCSVProject("test project", input);
    }

    protected Project createCSVProject(String projectName, String input) {
        Project project = new Project();
        ProjectMetadata metadata = new ProjectMetadata();
        metadata.setName(projectName);
        ObjectNode options = (ObjectNode)Mockito.mock(ObjectNode.class);
        RefineTest.prepareImportOptions(options, ",", -1, 0, 0, 1, false, false);
        ImportingJob job = ImportingManager.createJob();
        SeparatorBasedImporter importer = new SeparatorBasedImporter();
        ArrayList exceptions = new ArrayList();
        importer.parseOneFile(project, metadata, job, "filesource", (Reader)new StringReader(input), -1, options, exceptions);
        project.update();
        ProjectManager.singleton.registerProject(project, metadata);
        this.projects.add(project);
        this.importingJobs.add(job);
        return project;
    }

    public static void prepareImportOptions(ObjectNode options, String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes) {
        RefineTest.whenGetStringOption("separator", options, sep);
        RefineTest.whenGetIntegerOption("limit", options, limit);
        RefineTest.whenGetIntegerOption("skipDataLines", options, skip);
        RefineTest.whenGetIntegerOption("ignoreLines", options, ignoreLines);
        RefineTest.whenGetIntegerOption("headerLines", options, headerLines);
        RefineTest.whenGetBooleanOption("guessCellValueTypes", options, guessValueType);
        RefineTest.whenGetBooleanOption("processQuotes", options, !ignoreQuotes);
        RefineTest.whenGetBooleanOption("storeBlankCellsAsNulls", options, true);
    }

    @AfterMethod
    protected void cleanupProjectsAndJobs() {
        for (ImportingJob job : this.importingJobs) {
            ImportingManager.disposeJob((long)job.id);
        }
        for (Project project : this.projects) {
            ProjectManager.singleton.deleteProject(project.id);
        }
        this.servlet = null;
    }

    public static void assertProjectCreated(Project project, int numCols, int numRows) {
        Assert.assertNotNull((Object)project);
        Assert.assertNotNull((Object)project.columnModel);
        Assert.assertNotNull((Object)project.columnModel.columns);
        Assert.assertEquals((int)project.columnModel.columns.size(), (int)numCols);
        Assert.assertNotNull((Object)project.rows);
        Assert.assertEquals((int)project.rows.size(), (int)numRows);
    }

    public static void assertProjectCreated(Project project, int numCols, int numRows, int numRecords) {
        RefineTest.assertProjectCreated(project, numCols, numRows);
        Assert.assertNotNull((Object)project.recordModel);
        Assert.assertEquals((int)project.recordModel.getRecordCount(), (int)numRecords);
    }

    public void log(Project project) {
        StringBuilder sb = new StringBuilder();
        for (Column c : project.columnModel.columns) {
            sb.append(c.getName());
            sb.append("; ");
        }
        this.logger.info(sb.toString());
        for (Row r : project.rows) {
            sb = new StringBuilder();
            for (int i = 0; i < r.cells.size(); ++i) {
                Cell c = r.getCell(i);
                if (c != null) {
                    sb.append(c.value);
                    sb.append("; ");
                    continue;
                }
                sb.append("null; ");
            }
            this.logger.info(sb.toString());
        }
    }

    public static void whenGetBooleanOption(String name, ObjectNode options, Boolean def) {
        Mockito.when((Object)options.has(name)).thenReturn((Object)true);
        Mockito.when((Object)options.get(name)).thenReturn((Object)(def != false ? BooleanNode.TRUE : BooleanNode.FALSE));
    }

    public static void whenGetIntegerOption(String name, ObjectNode options, int def) {
        Mockito.when((Object)options.has(name)).thenReturn((Object)true);
        Mockito.when((Object)options.get(name)).thenReturn((Object)new IntNode(def));
    }

    public static void whenGetStringOption(String name, ObjectNode options, String def) {
        Mockito.when((Object)options.has(name)).thenReturn((Object)true);
        Mockito.when((Object)options.get(name)).thenReturn((Object)new TextNode(def));
    }

    public static void whenGetObjectOption(String name, ObjectNode options, ObjectNode def) {
        Mockito.when((Object)options.has(name)).thenReturn((Object)true);
        Mockito.when((Object)options.get(name)).thenReturn((Object)def);
    }

    public static void whenGetArrayOption(String name, ObjectNode options, ArrayNode def) {
        Mockito.when((Object)options.has(name)).thenReturn((Object)true);
        Mockito.when((Object)options.get(name)).thenReturn((Object)def);
    }

    public static void verifyGetArrayOption(String name, ObjectNode options) {
        ((ObjectNode)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).has(name);
        ((ObjectNode)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).get(name);
    }

    protected static Object invoke(String name, Object ... args) {
        Function function = ControlFunctionRegistry.getFunction((String)name);
        if (bindings == null) {
            bindings = new Properties();
        }
        if (function == null) {
            throw new IllegalArgumentException("Unknown function " + name);
        }
        if (args == null) {
            return function.call(bindings, new Object[0]);
        }
        return function.call(bindings, args);
    }

    protected void parseEval(Properties bindings, String[] test) throws ParsingException {
        Evaluable eval = MetaParser.parse((String)("grel:" + test[0]));
        Object result = eval.evaluate(bindings);
        Assert.assertEquals((String)result.toString(), (String)test[1], (String)("Wrong result for expression: " + test[0]));
    }

    protected void parseEvalType(Properties bindings, String test, Class clazz) throws ParsingException {
        Evaluable eval = MetaParser.parse((String)("grel:" + test));
        Object result = eval.evaluate(bindings);
        Assert.assertTrue((boolean)clazz.isInstance(result), (String)("Wrong result type for expression: " + test));
    }

    @AfterMethod
    public void TearDown() throws Exception {
        bindings = null;
    }

    protected ButterflyModule getCoreModule() {
        ButterflyModule coreModule = (ButterflyModule)Mockito.mock(ButterflyModule.class);
        Mockito.when((Object)coreModule.getName()).thenReturn((Object)"core");
        return coreModule;
    }

    protected void runAndWait(ProcessManager processManager, Process process, int timeout) {
        process.startPerforming(processManager);
        Assert.assertTrue((boolean)process.isRunning());
        try {
            for (int time = 0; process.isRunning() && time < timeout; time += 200) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Test interrupted");
        }
        Assert.assertFalse((boolean)process.isRunning(), (String)("Process failed to complete within timeout " + timeout));
    }
}

