/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.ListFacet;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import org.testng.annotations.Test;

public class ListFacetTests
extends RefineTest {
    private static String jsonConfig = "{\"type\":\"list\",\"name\":\"facet A\",\"columnName\":\"Column A\",\"expression\":\"value+\\\"bar\\\"\",\"omitBlank\":false,\"omitError\":false,\"selection\":[{\"v\":{\"v\":\"foobar\",\"l\":\"true\"}}],\"selectBlank\":false,\"selectError\":false,\"invert\":false}";
    private static String jsonFacetError = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"error\":\"No column named Column A\"}";
    private static String jsonFacet = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"choices\":[     {\"v\":{\"v\":\"foobar\",\"l\":\"foobar\"},\"c\":1,\"s\":true},     {\"v\":{\"v\":\"barbar\",\"l\":\"barbar\"},\"c\":1,\"s\":false}]}";
    private static String selectedEmptyChoiceFacet = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"choices\":[    {\"v\":{\"v\":\"ebar\",\"l\":\"ebar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"cbar\",\"l\":\"cbar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"abar\",\"l\":\"abar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"foobar\",\"l\":\"true\"},\"c\":0,\"s\":true}]}";

    @Test
    public void serializeListFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        TestUtils.isSerializedTo(facetConfig, jsonConfig);
    }

    @Test
    public void serializeListFacet() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("Column A\nfoo\nbar\n");
        Engine engine = new Engine(project);
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        TestUtils.isSerializedTo(facet, jsonFacet);
    }

    @Test
    public void serializeListFacetWithError() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("other column\nfoo\nbar\n");
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        TestUtils.isSerializedTo(facet, jsonFacetError);
    }

    @Test
    public void testSelectedEmptyChoice() throws IOException {
        Project project = this.createCSVProject("Column A\na\nc\ne");
        Engine engine = new Engine(project);
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        TestUtils.isSerializedTo(facet, selectedEmptyChoiceFacet);
    }
}

