/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.TextSearchFacet;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TextSearchFacetTests
extends RefineTest {
    private Project project;
    private TextSearchFacet.TextSearchFacetConfig textfilterconfig;
    private TextSearchFacet textfilter;
    private RowFilter rowfilter;
    private String sensitiveConfigJson = "{\"type\":\"text\",\"name\":\"Value\",\"columnName\":\"Value\",\"mode\":\"text\",\"caseSensitive\":true,\"invert\":false,\"query\":\"A\"}";
    private String sensitiveFacetJson = "{\"name\":\"Value\",\"columnName\":\"Value\",\"query\":\"A\",\"mode\":\"text\",\"caseSensitive\":true,\"invert\":false}";

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void setUp() throws IOException, ModelException {
        this.project = this.createCSVProject("TextSearchFacet", "Value\na\nb\nab\nAbc\n");
    }

    private void configureFilter(String filter) throws JsonParseException, JsonMappingException, IOException {
        this.textfilterconfig = (TextSearchFacet.TextSearchFacetConfig)ParsingUtilities.mapper.readValue(filter, TextSearchFacet.TextSearchFacetConfig.class);
        this.textfilter = this.textfilterconfig.apply(this.project);
        this.rowfilter = this.textfilter.getRowFilter(this.project);
    }

    @Test
    public void testTextFilter() throws Exception {
        String filter = "{\"type\":\"text\",\"name\":\"Value\",\"columnName\":\"Value\",\"mode\":\"text\",\"caseSensitive\":false,\"invert\":false,\"query\":\"a\"}";
        this.configureFilter(filter);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 0, (Row)this.project.rows.get(0)), (boolean)true);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 1, (Row)this.project.rows.get(1)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 2, (Row)this.project.rows.get(2)), (boolean)true);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 3, (Row)this.project.rows.get(3)), (boolean)true);
    }

    @Test
    public void testInvertedTextFilter() throws Exception {
        String filter = "{\"type\":\"text\",\"name\":\"Value\",\"columnName\":\"Value\",\"mode\":\"text\",\"caseSensitive\":false,\"invert\":true,\"query\":\"a\"}";
        this.configureFilter(filter);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 0, (Row)this.project.rows.get(0)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 1, (Row)this.project.rows.get(1)), (boolean)true);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 2, (Row)this.project.rows.get(2)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 3, (Row)this.project.rows.get(3)), (boolean)false);
    }

    @Test
    public void testRegExFilter() throws Exception {
        String filter = "{\"type\":\"text\",\"name\":\"Value\",\"columnName\":\"Value\",\"mode\":\"regex\",\"caseSensitive\":false,\"invert\":false,\"query\":\"[bc]\"}";
        this.configureFilter(filter);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 0, (Row)this.project.rows.get(0)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 1, (Row)this.project.rows.get(1)), (boolean)true);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 2, (Row)this.project.rows.get(2)), (boolean)true);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 3, (Row)this.project.rows.get(3)), (boolean)true);
    }

    @Test
    public void testCaseSensitiveFilter() throws Exception {
        this.configureFilter(this.sensitiveConfigJson);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 0, (Row)this.project.rows.get(0)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 1, (Row)this.project.rows.get(1)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 2, (Row)this.project.rows.get(2)), (boolean)false);
        Assert.assertEquals((boolean)this.rowfilter.filterRow(this.project, 3, (Row)this.project.rows.get(3)), (boolean)true);
    }

    @Test
    public void serializeTextSearchFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        TextSearchFacet.TextSearchFacetConfig config = (TextSearchFacet.TextSearchFacetConfig)ParsingUtilities.mapper.readValue(this.sensitiveConfigJson, TextSearchFacet.TextSearchFacetConfig.class);
        TestUtils.isSerializedTo(config, this.sensitiveConfigJson);
    }

    @Test
    public void serializeTextSearchFacet() throws JsonParseException, JsonMappingException, IOException {
        TextSearchFacet.TextSearchFacetConfig config = (TextSearchFacet.TextSearchFacetConfig)ParsingUtilities.mapper.readValue(this.sensitiveConfigJson, TextSearchFacet.TextSearchFacetConfig.class);
        TextSearchFacet facet = config.apply(this.project);
        TestUtils.isSerializedTo(facet, this.sensitiveFacetJson);
    }
}

