/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.facets.TimeRangeFacet;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.testng.annotations.Test;

public class TimeRangeFacetTests
extends RefineTest {
    public static String facetJson = "{\"name\":\"my column\",\"expression\":\"value\",\"columnName\":\"my column\",\"min\":1199329445000,\"max\":1514966950000,\"step\":31556952000,\"bins\":[1,0,0,0,1,0,0,0,0,0,1],\"baseBins\":[1,0,0,0,1,0,0,0,0,0,1],\"from\":1262443349000,\"to\":1514966950000,\"baseTimeCount\":3,\"baseNonTimeCount\":1,\"baseBlankCount\":0,\"baseErrorCount\":0,\"timeCount\":3,\"nonTimeCount\":1,\"blankCount\":0,\"errorCount\":0}";
    public static String configJson = "{\n          \"selectNonTime\": true,\n          \"expression\": \"value\",\n          \"selectBlank\": true,\n          \"selectError\": true,\n          \"selectTime\": true,\n          \"name\": \"my column\",\n          \"from\": 1262443349000,\n          \"to\": 1514966950000,\n          \"type\": \"timerange\",\n          \"columnName\": \"my column\"\n        }";

    @Test
    public void serializeTimeRangeFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        TimeRangeFacet.TimeRangeFacetConfig config = (TimeRangeFacet.TimeRangeFacetConfig)ParsingUtilities.mapper.readValue(configJson, TimeRangeFacet.TimeRangeFacetConfig.class);
        TestUtils.isSerializedTo(config, configJson);
    }

    @Test
    public void serializeTimeRangeFacet() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("my column\nplaceholder\nnontime\nplaceholder\nplaceholder\n");
        ((Row)project.rows.get((int)0)).cells.set(0, new Cell((Serializable)OffsetDateTime.parse("2018-01-03T08:09:10Z"), null));
        ((Row)project.rows.get((int)2)).cells.set(0, new Cell((Serializable)OffsetDateTime.parse("2008-01-03T03:04:05Z"), null));
        ((Row)project.rows.get((int)3)).cells.set(0, new Cell((Serializable)OffsetDateTime.parse("2012-04-05T02:00:01Z"), null));
        Engine engine = new Engine(project);
        TimeRangeFacet.TimeRangeFacetConfig config = (TimeRangeFacet.TimeRangeFacetConfig)ParsingUtilities.mapper.readValue(configJson, TimeRangeFacet.TimeRangeFacetConfig.class);
        TimeRangeFacet facet = config.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        TestUtils.isSerializedTo(facet, facetJson);
    }
}

