/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.RefineTest;
import com.google.refine.browsing.util.ExpressionNominalValueGrouper;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ExpressionNominalValueGrouperTests
extends RefineTest {
    private static Project project;
    private static Properties bindings;
    private static OffsetDateTime dateTimeValue;
    private static String dateTimeStringValue;
    private static int integerValue;
    private static String integerStringValue;
    private static String stringStringValue;
    private static ExpressionNominalValueGrouper grouper;
    private static Evaluable eval;
    private static final int cellIndex = 0;
    private static final String columnName = "Col1";
    private static final int numberOfRows = 5;
    private static final String projectName = "ExpressionNominalValueGrouper";

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void setUp() throws IOException, ModelException {
        project = this.createProjectWithColumns(projectName, columnName);
        bindings = new Properties();
        bindings.put("project", project);
    }

    @AfterMethod
    public void tearDown() {
        project = null;
    }

    @Test
    public void expressionNominalValueGrouperStrings() throws Exception {
        Row row;
        for (int i = 0; i < 5; ++i) {
            row = new Row(1);
            row.setCell(0, new Cell((Serializable)((Object)stringStringValue), null));
            ExpressionNominalValueGrouperTests.project.rows.add(row);
        }
        eval = MetaParser.parse((String)"value");
        grouper = new ExpressionNominalValueGrouper(eval, columnName, 0);
        try {
            grouper.start(project);
            for (int rowIndex = 0; rowIndex < 5; ++rowIndex) {
                row = (Row)ExpressionNominalValueGrouperTests.project.rows.get(rowIndex);
                grouper.visit(project, rowIndex, row);
            }
        }
        finally {
            grouper.end(project);
        }
        Assert.assertEquals((int)ExpressionNominalValueGrouperTests.grouper.choices.size(), (int)1);
        Assert.assertTrue((boolean)ExpressionNominalValueGrouperTests.grouper.choices.containsKey(stringStringValue));
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.stringStringValue)).decoratedValue.label, (String)stringStringValue);
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.stringStringValue)).decoratedValue.value.toString(), (String)stringStringValue);
    }

    @Test
    public void expressionNominalValueGrouperInts() throws Exception {
        Row row;
        for (int i = 0; i < 5; ++i) {
            row = new Row(1);
            row.setCell(0, new Cell((Serializable)Integer.valueOf(integerValue), null));
            ExpressionNominalValueGrouperTests.project.rows.add(row);
        }
        eval = MetaParser.parse((String)"value");
        grouper = new ExpressionNominalValueGrouper(eval, columnName, 0);
        try {
            grouper.start(project);
            for (int rowIndex = 0; rowIndex < 5; ++rowIndex) {
                row = (Row)ExpressionNominalValueGrouperTests.project.rows.get(rowIndex);
                grouper.visit(project, rowIndex, row);
            }
        }
        finally {
            grouper.end(project);
        }
        Assert.assertEquals((int)ExpressionNominalValueGrouperTests.grouper.choices.size(), (int)1);
        Assert.assertTrue((boolean)ExpressionNominalValueGrouperTests.grouper.choices.containsKey(integerStringValue));
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.integerStringValue)).decoratedValue.label, (String)integerStringValue);
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.integerStringValue)).decoratedValue.value.toString(), (String)integerStringValue);
    }

    @Test
    public void expressionNominalValueGrouperDates() throws Exception {
        Row row;
        for (int i = 0; i < 5; ++i) {
            row = new Row(1);
            row.setCell(0, new Cell((Serializable)dateTimeValue, null));
            ExpressionNominalValueGrouperTests.project.rows.add(row);
        }
        eval = MetaParser.parse((String)"value");
        grouper = new ExpressionNominalValueGrouper(eval, columnName, 0);
        try {
            grouper.start(project);
            for (int rowIndex = 0; rowIndex < 5; ++rowIndex) {
                row = (Row)ExpressionNominalValueGrouperTests.project.rows.get(rowIndex);
                grouper.visit(project, rowIndex, row);
            }
        }
        finally {
            grouper.end(project);
        }
        Assert.assertEquals((int)ExpressionNominalValueGrouperTests.grouper.choices.size(), (int)1);
        Assert.assertTrue((boolean)ExpressionNominalValueGrouperTests.grouper.choices.containsKey(dateTimeStringValue));
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.dateTimeStringValue)).decoratedValue.label, (String)dateTimeStringValue);
        Assert.assertEquals((String)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.dateTimeStringValue)).decoratedValue.value.toString(), (String)dateTimeStringValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expressionNominalValueGrouperRecords() throws Exception {
        String completeProjectJson = "col1,col2,col3\nrecord1,1,a\n,,a\n,,a\nrecord2,,a\n,1,a\n";
        project = this.createCSVProject(completeProjectJson);
        bindings = new Properties();
        bindings.put("project", project);
        eval = MetaParser.parse((String)"value");
        grouper = new ExpressionNominalValueGrouper(eval, "col2", 1);
        try {
            grouper.start(project);
            int c = ExpressionNominalValueGrouperTests.project.recordModel.getRecordCount();
            for (int r = 0; r < c; ++r) {
                grouper.visit(project, ExpressionNominalValueGrouperTests.project.recordModel.getRecord(r));
            }
        }
        finally {
            grouper.end(project);
        }
        Assert.assertEquals((int)ExpressionNominalValueGrouperTests.grouper.blankCount, (int)3);
        Assert.assertEquals((int)ExpressionNominalValueGrouperTests.grouper.choices.size(), (int)1);
        Assert.assertTrue((boolean)ExpressionNominalValueGrouperTests.grouper.choices.containsKey(integerStringValue));
        Assert.assertEquals((int)((ExpressionNominalValueGrouper.IndexedNominalFacetChoice)ExpressionNominalValueGrouperTests.grouper.choices.get((Object)ExpressionNominalValueGrouperTests.integerStringValue)).count, (int)2);
    }

    static {
        dateTimeValue = OffsetDateTime.parse("2017-05-12T05:45:00+00:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        dateTimeStringValue = "2017-05-12T05:45:00Z";
        integerValue = 1;
        integerStringValue = "1";
        stringStringValue = "a";
    }
}

