/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.clustering.binning;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.clustering.binning.BinningClusterer;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BinningClustererTests
extends RefineTest {
    String configJson = "{\"type\":\"binning\",\"function\":\"fingerprint\",\"column\":\"values\",\"params\":{}}";
    String configNgramJson = "{\"type\":\"binning\",\"function\":\"ngram-fingerprint\",\"column\":\"values\",\"params\":{\"ngram-size\":2}}";
    String clustererJson = "[  [{\"v\":\"a\",\"c\":1},{\"v\":\"\u00e0\",\"c\":1}],  [{\"v\":\"c\",\"c\":1},{\"v\":\"\u0109\",\"c\":1}]]";

    @Test
    public void testSerializeBinningClustererConfig() throws JsonParseException, JsonMappingException, IOException {
        BinningClusterer.BinningClustererConfig config = (BinningClusterer.BinningClustererConfig)ParsingUtilities.mapper.readValue(this.configJson, BinningClusterer.BinningClustererConfig.class);
        TestUtils.isSerializedTo(config, this.configJson);
    }

    @Test
    public void testSerializeBinningClustererConfigWithNgrams() throws JsonParseException, JsonMappingException, IOException {
        BinningClusterer.BinningClustererConfig config = (BinningClusterer.BinningClustererConfig)ParsingUtilities.mapper.readValue(this.configNgramJson, BinningClusterer.BinningClustererConfig.class);
        TestUtils.isSerializedTo(config, this.configNgramJson);
    }

    @Test
    public void testSerializeBinningClusterer() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("column\na\n\u00e0\nc\n\u0109\n");
        BinningClusterer.BinningClustererConfig config = (BinningClusterer.BinningClustererConfig)ParsingUtilities.mapper.readValue(this.configJson, BinningClusterer.BinningClustererConfig.class);
        BinningClusterer clusterer = config.apply(project);
        clusterer.computeClusters(new Engine(project));
        TestUtils.isSerializedTo(clusterer, this.clustererJson);
    }

    @Test
    public void testNoLonelyClusters() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("column\nc\n\u0109\nd\n");
        BinningClusterer.BinningClustererConfig config = (BinningClusterer.BinningClustererConfig)ParsingUtilities.mapper.readValue(this.configJson, BinningClusterer.BinningClustererConfig.class);
        BinningClusterer clusterer = config.apply(project);
        clusterer.computeClusters(new Engine(project));
        Assert.assertEquals((int)clusterer.getJsonRepresentation().size(), (int)1);
    }
}

