/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.clustering.knn;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.clustering.knn.kNNClusterer;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class kNNClustererTests
extends RefineTest {
    public static String configJson = "{\"type\":\"knn\",\"function\":\"PPM\",\"column\":\"values\",\"params\":{\"radius\":1,\"blocking-ngram-size\":2}}";
    public static String clustererJson = "[   [{\"v\":\"ab\",\"c\":1},{\"v\":\"abc\",\"c\":1}]]";

    @Test
    public void serializekNNClustererConfig() throws JsonParseException, JsonMappingException, IOException {
        kNNClusterer.kNNClustererConfig config = (kNNClusterer.kNNClustererConfig)ParsingUtilities.mapper.readValue(configJson, kNNClusterer.kNNClustererConfig.class);
        TestUtils.isSerializedTo(config, configJson);
    }

    @Test
    public void serializekNNClusterer() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("column\nab\nabc\nc\n\u0109\n");
        kNNClusterer.kNNClustererConfig config = (kNNClusterer.kNNClustererConfig)ParsingUtilities.mapper.readValue(configJson, kNNClusterer.kNNClustererConfig.class);
        kNNClusterer clusterer = config.apply(project);
        clusterer.computeClusters(new Engine(project));
        TestUtils.isSerializedTo(clusterer, clustererJson);
    }

    @Test
    public void testNoLonelyclusters() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createCSVProject("column\nfoo\nbar\n");
        kNNClusterer.kNNClustererConfig config = (kNNClusterer.kNNClustererConfig)ParsingUtilities.mapper.readValue(configJson, kNNClusterer.kNNClustererConfig.class);
        kNNClusterer clusterer = config.apply(project);
        clusterer.computeClusters(new Engine(project));
        Assert.assertTrue((boolean)clusterer.getJsonRepresentation().isEmpty());
    }
}

