/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.commands.CommandStub;
import com.google.refine.model.Project;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CommandTests
extends RefineTest {
    CommandStub SUT = null;
    HttpServletRequest request = null;
    ProjectManager projectManager = null;
    Project project = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new CommandStub();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.project = (Project)Mockito.mock(Project.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.request = null;
        this.projectManager = null;
        this.project = null;
    }

    @Test
    public void getProjectThrowsWithNullParameter() {
        try {
            this.SUT.wrapGetProject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void getProjectThrowsIfResponseHasNoOrBrokenProjectParameter() {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)"");
        try {
            this.SUT.wrapGetProject(this.request);
        }
        catch (ServletException servletException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("project");
    }

    @Test
    public void getEngineConfigThrowsWithNullParameter() {
        try {
            this.SUT.wrapGetEngineConfig(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void getEngineConfigReturnsNullWithNullEngineParameter() {
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn(null);
        try {
            Assert.assertNull((Object)this.SUT.wrapGetEngineConfig(this.request));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void getEngineConfigReturnsNullWithEmptyOrBadParameterValue() {
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn((Object)"sdfasdfas");
        Assert.assertNull((Object)this.SUT.wrapGetEngineConfig(this.request));
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("engine");
    }

    @Test
    public void getEngineConfigRegressionTest() {
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn((Object)"{\"mode\":\"row-based\"}");
        EngineConfig o = null;
        try {
            o = this.SUT.wrapGetEngineConfig(this.request);
            Assert.assertEquals((Object)Engine.Mode.RowBased, (Object)o.getMode());
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("engine");
    }

    @Test
    public void getEngineThrowsOnNullParameter() {
        try {
            this.SUT.wrapGetEngine(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.SUT.wrapGetEngine(null, this.project);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.SUT.wrapGetEngine(this.request, null);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void getEngineRegressionTest() {
        Engine engine = null;
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn((Object)"{\"hello\":\"world\"}");
        try {
            engine = this.SUT.wrapGetEngine(this.request, this.project);
            Assert.assertNotNull((Object)engine);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("engine");
    }

    @Test
    public void getIntegerParameterWithNullParameters() {
        try {
            this.SUT.wrapGetIntegerParameter(null, null, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.SUT.wrapGetIntegerParameter(null, "name", 0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIntegerParametersWithIncorrectParameterName() {
        int returned;
        Mockito.when((Object)this.request.getParameter(null)).thenReturn(null);
        Mockito.when((Object)this.request.getParameter("incorrect")).thenReturn(null);
        try {
            returned = this.SUT.wrapGetIntegerParameter(this.request, null, 5);
            Assert.assertEquals((int)5, (int)returned);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        try {
            returned = this.SUT.wrapGetIntegerParameter(this.request, "incorrect", 5);
            Assert.assertEquals((int)5, (int)returned);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter(null);
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("incorrect");
    }

    @Test
    public void getIntegerParametersRegressionTest() {
        int returned;
        Mockito.when((Object)this.request.getParameter("positivenumber")).thenReturn((Object)"22");
        Mockito.when((Object)this.request.getParameter("zeronumber")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("negativenumber")).thenReturn((Object)"-40");
        try {
            returned = this.SUT.wrapGetIntegerParameter(this.request, "positivenumber", 5);
            Assert.assertEquals((int)22, (int)returned);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        try {
            returned = this.SUT.wrapGetIntegerParameter(this.request, "zeronumber", 5);
            Assert.assertEquals((int)0, (int)returned);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        try {
            int returned2 = this.SUT.wrapGetIntegerParameter(this.request, "negativenumber", 5);
            Assert.assertEquals((int)-40, (int)returned2);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("positivenumber");
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("zeronumber");
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("negativenumber");
    }
}

