/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.cell;

import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.cell.EditOneCellCommand;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EditOneCellCommandTests
extends RefineTest {
    private static final String PARSABLE_DOUBLE_NUMBER = "12345.123";
    private static final String PARSABLE_LONG_NUMBER = "12345";
    protected Project project = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Command command = null;
    protected StringWriter writer = null;

    @BeforeMethod
    public void setUpProject() {
        this.project = this.createCSVProject("first_column,second_column\na,b\nc,d\n");
        this.command = new EditOneCellCommand();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.writer = new StringWriter();
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testEditOneCell() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("type")).thenReturn((Object)"string");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)"e");
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        this.command.doPost(this.request, this.response);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"a");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"e");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"d");
    }

    @Test
    public void testNumberParsing_parsableLong() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("type")).thenReturn((Object)"number");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)PARSABLE_LONG_NUMBER);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        this.command.doPost(this.request, this.response);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"a");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b");
        Assert.assertTrue((boolean)(((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value instanceof Long));
        Assert.assertEquals((Object)new Long(12345L), (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"d");
    }

    @Test
    public void testNumberParsing_parsableDouble() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("type")).thenReturn((Object)"number");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)PARSABLE_DOUBLE_NUMBER);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        this.command.doPost(this.request, this.response);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"a");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b");
        Assert.assertTrue((boolean)(((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value instanceof Double));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)12345.123);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"d");
    }

    @Test
    public void testMissingCSRFToken() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("type")).thenReturn((Object)"string");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)"e");
        this.command.doPost(this.request, this.response);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"c");
        TestUtils.assertEqualAsJson("{\"code\":\"error\",\"message\":\"Missing or invalid csrf_token parameter\"}", this.writer.toString());
    }
}

