/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.commands.Command;
import com.google.refine.io.FileProjectManager;
import com.google.refine.util.TestUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;

public class ExpressionCommandTestBase {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Command command = null;
    protected StringWriter writer = null;

    @BeforeMethod
    public void setUpRequestResponse() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.writer = new StringWriter();
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initWorkspace(String expressionsJson, String starredExpressionsJson) {
        String starred = starredExpressionsJson == null ? "{\"class\":\"com.google.refine.preference.TopList\",\"top\":2147483647,\"list\":[]}" : starredExpressionsJson;
        String expressions = expressionsJson == null ? "{\"class\":\"com.google.refine.preference.TopList\",\"top\":100,\"list\":[]}" : expressionsJson;
        String jsonData = "{\"projectIDs\":[]\n,\"preferences\":{\"entries\":{\"scripting.starred-expressions\":" + starred + ",\"scripting.expressions\":" + expressions + "}}}";
        this.initWorkspace(jsonData);
    }

    public void initWorkspace(String jsonData) {
        try {
            File workspaceDir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
            File jsonPath = new File(workspaceDir, "workspace.json");
            FileUtils.writeStringToFile((File)jsonPath, (String)jsonData);
            FileProjectManager.initialize((File)workspaceDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void assertResponseJsonIs(String expectedJson) {
        String actualJson = this.writer.toString();
        if (!TestUtils.equalAsJson(expectedJson, actualJson)) {
            try {
                TestUtils.jsonDiff(expectedJson, actualJson);
            }
            catch (JsonParseException | JsonMappingException e) {
                e.printStackTrace();
            }
        }
        TestUtils.assertEqualsAsJson(actualJson, expectedJson);
    }
}

