/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.google.refine.ProjectManager;
import com.google.refine.commands.Command;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.commands.expr.LogExpressionCommand;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.preference.TopList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LogExpressionCommandTests
extends CommandTestBase {
    PreferenceStore prefStore;

    @BeforeMethod
    public void setUpCommand() {
        this.command = new LogExpressionCommand();
        ProjectManager.singleton = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.prefStore = new PreferenceStore();
        Mockito.when((Object)ProjectManager.singleton.getPreferenceStore()).thenReturn((Object)this.prefStore);
    }

    @Test
    public void testCSRFProtection() throws ServletException, IOException {
        this.command.doPost(this.request, this.response);
        this.assertCSRFCheckFailed();
    }

    @Test
    public void testNullExpressions() throws ServletException, IOException {
        this.prefStore.put("scripting.expressions", null);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value+'a'");
        this.command.doPost(this.request, this.response);
        TopList topList = (TopList)this.prefStore.get("scripting.expressions");
        Assert.assertEquals((Collection)topList.getList(), Collections.singletonList("grel:value+'a'"));
    }
}

