/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.expr.PreviewExpressionCommand;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PreviewExpressionCommandTests
extends RefineTest {
    protected Project project = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Command command = null;
    protected StringWriter writer = null;

    @BeforeMethod
    public void setUpRequestResponse() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.writer = new StringWriter();
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.command = new PreviewExpressionCommand();
        this.project = this.createCSVProject("a,b\nc,d\ne,f\ng,h");
    }

    @Test
    public void testJsonResponse() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("cellIndex")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value + \"_u\"");
        Mockito.when((Object)this.request.getParameter("rowIndices")).thenReturn((Object)"[0,2]");
        String json = "{\n       \"code\" : \"ok\",\n       \"results\" : [ \"d_u\", \"h_u\" ]\n     }";
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), json);
    }

    @Test
    public void testParseError() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("cellIndex")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value +");
        Mockito.when((Object)this.request.getParameter("rowIndices")).thenReturn((Object)"[0,2]");
        String json = "{\n       \"code\" : \"error\",\n       \"message\" : \"Parsing error at offset 7: Expecting something more at end of expression\",\n       \"type\" : \"parser\"\n     }";
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), json);
    }
}

