/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.project;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.project.SetProjectMetadataCommand;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SetProjectMetadataCommandTests
extends RefineTest {
    SetProjectMetadataCommand SUT = null;
    long PROJECT_ID_LONG = 1234L;
    String PROJECT_ID = "1234";
    String SUBJECT = "subject for project";
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    ProjectManager projMan = null;
    Project proj = null;
    PrintWriter pw = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException {
        ProjectManager.singleton = this.projMan = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.proj = (Project)Mockito.mock(Project.class);
        this.pw = (PrintWriter)Mockito.mock(PrintWriter.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.SUT = new SetProjectMetadataCommand();
        ProjectMetadata metadata = new ProjectMetadata();
        metadata.setUserMetadata((ArrayNode)ParsingUtilities.mapper.readTree("[ {name: \"clientID\", display: true} ]"));
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)this.PROJECT_ID);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.projMan.getProject(ArgumentMatchers.anyLong())).thenReturn((Object)this.proj);
        Mockito.when((Object)this.proj.getMetadata()).thenReturn((Object)metadata);
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.pw);
        }
        catch (IOException e1) {
            Assert.fail();
        }
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.projMan = null;
        ProjectManager.singleton = null;
        this.proj = null;
        this.pw = null;
        this.request = null;
        this.response = null;
    }

    @Test
    public void setMetadataTest() {
        Mockito.when((Object)this.request.getParameter("name")).thenReturn((Object)"subject");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)this.SUBJECT);
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("Content-Type", "application/json");
        ((Project)Mockito.verify((Object)this.proj, (VerificationMode)Mockito.times((int)1))).getMetadata();
        try {
            ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getWriter();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((PrintWriter)Mockito.verify((Object)this.pw, (VerificationMode)Mockito.times((int)1))).write("{ \"code\" : \"ok\" }");
        Assert.assertEquals((String)this.proj.getMetadata().getSubject(), (String)this.SUBJECT);
    }

    @Test
    public void setUserMetadataFieldTest() {
        Mockito.when((Object)this.request.getParameter("name")).thenReturn((Object)"clientID");
        Mockito.when((Object)this.request.getParameter("value")).thenReturn((Object)"IBM");
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("Content-Type", "application/json");
        ((Project)Mockito.verify((Object)this.proj, (VerificationMode)Mockito.times((int)1))).getMetadata();
        try {
            ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getWriter();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((PrintWriter)Mockito.verify((Object)this.pw, (VerificationMode)Mockito.times((int)1))).write("{ \"code\" : \"ok\" }");
        ObjectNode obj = (ObjectNode)this.proj.getMetadata().getUserMetadata().get(0);
        Assert.assertEquals((String)obj.get("name").asText(), (String)"clientID");
        Assert.assertEquals((String)obj.get("value").asText(), (String)"IBM");
    }

    @Test
    public void doPostThrowsIfCommand_getProjectReturnsNull() {
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException servletException) {
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
    }
}

