/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.recon;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.recon.ReconJudgeOneCellCommand;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.StandardReconConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReconJudgeOneCellCommandTest
extends RefineTest {
    Project project = null;
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    Command command = null;
    PrintWriter writer = null;

    @BeforeMethod
    public void setUp() {
        this.project = this.createCSVProject("reconciled column,unreconciled column\na,b\nc,d\n");
        Column reconciled = (Column)this.project.columnModel.columns.get(0);
        StandardReconConfig config = new StandardReconConfig("http://my.recon.service/api", "http://my.recon.service/rdf/space", "http://my.recon.service/rdf/schema", "type3894", "octopus", true, Collections.emptyList(), 5);
        reconciled.setReconConfig((ReconConfig)config);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)String.valueOf(this.project.id));
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        this.writer = (PrintWriter)Mockito.mock(PrintWriter.class);
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.writer);
        }
        catch (IOException e1) {
            Assert.fail();
        }
        this.command = new ReconJudgeOneCellCommand();
    }

    @AfterMethod
    public void tearDown() {
        ProjectManager.singleton.deleteProject(this.project.id);
    }

    @Test
    public void testMarkOneCellInReconciledColumn() throws Exception {
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("judgment")).thenReturn((Object)"new");
        this.command.doPost(this.request, this.response);
        Cell cell = (Cell)((Row)this.project.rows.get((int)0)).cells.get(0);
        Assert.assertEquals((Object)Recon.Judgment.New, (Object)cell.recon.judgment);
        Assert.assertEquals((String)"http://my.recon.service/rdf/space", (String)cell.recon.identifierSpace);
    }

    @Test
    public void testMarkOneCellWithCustomSpace() throws Exception {
        Mockito.when((Object)this.request.getParameter("row")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("cell")).thenReturn((Object)"0");
        Mockito.when((Object)this.request.getParameter("judgment")).thenReturn((Object)"new");
        Mockito.when((Object)this.request.getParameter("identifierSpace")).thenReturn((Object)"http://my.custom.space/id");
        Mockito.when((Object)this.request.getParameter("schemaSpace")).thenReturn((Object)"http://my.custom.space/schema");
        this.command.doPost(this.request, this.response);
        Cell cell = (Cell)((Row)this.project.rows.get((int)0)).cells.get(0);
        Assert.assertEquals((Object)Recon.Judgment.New, (Object)cell.recon.judgment);
        Assert.assertEquals((String)"http://my.custom.space/id", (String)cell.recon.identifierSpace);
        Assert.assertEquals((String)"http://my.custom.space/schema", (String)cell.recon.schemaSpace);
    }
}

