/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.row;

import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.row.GetRowsCommand;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetRowsCommandTest
extends RefineTest {
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    Command command = null;
    Project project = null;
    StringWriter writer = null;

    @BeforeMethod
    public void setUp() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.project = this.createCSVProject("a,b\nc,d\n,f");
        this.command = new GetRowsCommand();
        this.writer = new StringWriter();
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)String.valueOf(this.project.id));
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testJsonOutputRows() throws ServletException, IOException {
        String rowJson = "{\n       \"filtered\" : 2,\n       \"limit\" : 2,\n       \"mode\" : \"row-based\",\n       \"pool\" : {\n         \"recons\" : { }\n       },\n       \"rows\" : [ {\n         \"cells\" : [ {\n           \"v\" : \"c\"\n         }, {\n           \"v\" : \"d\"\n         } ],\n         \"flagged\" : false,\n         \"i\" : 0,\n         \"starred\" : false\n       }, {\n         \"cells\" : [ null, {\n           \"v\" : \"f\"\n         } ],\n         \"flagged\" : false,\n         \"i\" : 1,\n         \"starred\" : false\n       } ],\n       \"start\" : 0,\n       \"total\" : 2\n     }";
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn((Object)"{\"mode\":\"row-based\",\"facets\":[]}");
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), rowJson);
    }

    @Test
    public void testJsonOutputRecords() throws ServletException, IOException {
        String recordJson = "{\n       \"filtered\" : 1,\n       \"limit\" : 2,\n       \"mode\" : \"record-based\",\n       \"pool\" : {\n         \"recons\" : { }\n       },\n       \"rows\" : [ {\n         \"cells\" : [ {\n           \"v\" : \"c\"\n         }, {\n           \"v\" : \"d\"\n         } ],\n         \"flagged\" : false,\n         \"i\" : 0,\n         \"j\" : 0,\n         \"starred\" : false\n       }, {\n         \"cells\" : [ null, {\n           \"v\" : \"f\"\n         } ],\n         \"flagged\" : false,\n         \"i\" : 1,\n         \"starred\" : false\n       } ],\n       \"start\" : 0,\n       \"total\" : 1\n     }";
        Mockito.when((Object)this.request.getParameter("engine")).thenReturn((Object)"{\"mode\":\"record-based\",\"facets\":[]}");
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), recordJson);
    }
}

