/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.CsvExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CsvExporterTests
extends RefineTest {
    StringWriter writer;
    Project project;
    Engine engine;
    Properties options;
    CsvExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new CsvExporter();
        this.writer = new StringWriter();
        this.project = new Project();
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.writer = null;
        this.project = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void exportSimpleCsv() {
        this.CreateGrid(2, 2);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1\nrow0cell0,row0cell1\nrow1cell0,row1cell1\n");
    }

    @Test
    public void exportSimpleCsvNoHeader() {
        this.CreateGrid(2, 2);
        Mockito.when((Object)this.options.getProperty("printColumnHeader")).thenReturn((Object)"false");
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"row0cell0,row0cell1\nrow1cell0,row1cell1\n");
        ((Properties)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)2))).getProperty("printColumnHeader");
    }

    @Test
    public void exportSimpleCsvCustomLineSeparator() {
        this.CreateGrid(2, 2);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)"{\"lineSeparator\":\"X\"}");
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1Xrow0cell0,row0cell1Xrow1cell0,row1cell1X");
    }

    @Test
    public void exportSimpleCsvQuoteAll() {
        this.CreateGrid(2, 2);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)"{\"quoteAll\":\"true\"}");
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"\"column0\",\"column1\"\n\"row0cell0\",\"row0cell1\"\n\"row1cell0\",\"row1cell1\"\n");
    }

    @Test
    public void exportCsvWithLineBreaks() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, new Cell((Serializable)((Object)"line\n\n\nbreak"), null));
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1,column2\nrow0cell0,row0cell1,row0cell2\nrow1cell0,\"line\n\n\nbreak\",row1cell2\nrow2cell0,row2cell1,row2cell2\n");
    }

    @Test
    public void exportCsvWithComma() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, new Cell((Serializable)((Object)"with, comma"), null));
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1,column2\nrow0cell0,row0cell1,row0cell2\nrow1cell0,\"with, comma\",row1cell2\nrow2cell0,row2cell1,row2cell2\n");
    }

    @Test
    public void exportCsvWithQuote() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, new Cell((Serializable)((Object)"line has \"quote\""), null));
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1,column2\nrow0cell0,row0cell1,row0cell2\nrow1cell0,\"line has \"\"quote\"\"\",row1cell2\nrow2cell0,row2cell1,row2cell2\n");
    }

    @Test
    public void exportCsvWithEmptyCells() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, null);
        ((Row)this.project.rows.get((int)2)).cells.set(0, null);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"column0,column1,column2\nrow0cell0,row0cell1,row0cell2\nrow1cell0,,row1cell2\n,row2cell1,row2cell2\n");
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }
}

