/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.HtmlTableExporter;
import com.google.refine.exporters.WriterExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class HtmlExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "html table exporter test project";
    StringWriter writer;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    WriterExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new HtmlTableExporter();
        this.writer = new StringWriter();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.writer = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.projectMetadata = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void exportSimpleHtmlTable() {
        this.CreateGrid(2, 2);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"<html>\n<head>\n<title>html table exporter test project</title>\n<meta charset=\"utf-8\" />\n</head>\n<body>\n<table>\n<tr><th>column0</th><th>column1</th></tr>\n<tr><td>row0cell0</td><td>row0cell1</td></tr>\n<tr><td>row1cell0</td><td>row1cell1</td></tr>\n</table>\n</body>\n</html>\n");
    }

    @Test(enabled=false)
    public void exportSimpleHtmlTableNoHeader() {
        this.CreateGrid(2, 2);
        Mockito.when((Object)this.options.getProperty("printColumnHeader")).thenReturn((Object)"false");
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"<html>\n<head>\n<title>html table exporter test project</title>\n<meta charset=\"utf-8\" />\n</head>\n<body>\n<table>\n<tr><td>row0cell0</td><td>row0cell1</td></tr>\n<tr><td>row1cell0</td><td>row1cell1</td></tr>\n</table>\n</body>\n</html>\n");
        ((Properties)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)2))).getProperty("printColumnHeader");
    }

    @Test
    public void exportHtmlTableWithEmptyCells() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, null);
        ((Row)this.project.rows.get((int)2)).cells.set(0, null);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"<html>\n<head>\n<title>html table exporter test project</title>\n<meta charset=\"utf-8\" />\n</head>\n<body>\n<table>\n<tr><th>column0</th><th>column1</th><th>column2</th></tr>\n<tr><td>row0cell0</td><td>row0cell1</td><td>row0cell2</td></tr>\n<tr><td>row1cell0</td><td></td><td>row1cell2</td></tr>\n<tr><td></td><td>row2cell1</td><td>row2cell2</td></tr>\n</table>\n</body>\n</html>\n");
    }

    @Test
    public void exportHtmlTableWithURLs() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, new Cell((Serializable)((Object)"ftp://ftp.ripe.net/ripe/"), null));
        ((Row)this.project.rows.get((int)2)).cells.set(0, new Cell((Serializable)((Object)"https://gnu.org/"), null));
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)"<html>\n<head>\n<title>html table exporter test project</title>\n<meta charset=\"utf-8\" />\n</head>\n<body>\n<table>\n<tr><th>column0</th><th>column1</th><th>column2</th></tr>\n<tr><td>row0cell0</td><td>row0cell1</td><td>row0cell2</td></tr>\n<tr><td>row1cell0</td><td><a href=\"ftp://ftp.ripe.net/ripe/\">ftp://ftp.ripe.net/ripe/</a></td><td>row1cell2</td></tr>\n<tr><td><a href=\"https://gnu.org/\">https://gnu.org/</a></td><td>row2cell1</td><td>row2cell2</td></tr>\n</table>\n</body>\n</html>\n");
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }
}

