/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters.sql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.sql.SqlCreateBuilder;
import com.google.refine.exporters.sql.SqlExporter;
import com.google.refine.exporters.sql.SqlInsertBuilder;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SqlExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "SQL_EXPORTER_TEST_PROJECT";
    StringWriter writer;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    SqlCreateBuilder sqlCreateBuilder;
    SqlInsertBuilder sqlInsertBuilder;
    SqlExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new SqlExporter();
        this.writer = new StringWriter();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.writer = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.projectMetadata = null;
        this.engine = null;
        this.options = null;
        this.sqlCreateBuilder = null;
        this.sqlInsertBuilder = null;
    }

    @Test
    public void testExportSqlWithNonZeroScaleNumericValue() {
        this.createNonZeroScaleNumericGrid(2, 2);
        String tableName = "sql_table_test";
        String optionsString = this.createOptionsFromProject(tableName, "NUMERIC", null).toString();
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsString);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        this.logger.debug("result = \n" + result);
        Assert.assertNotNull((Object)result);
        Assert.assertNotEquals((Object)this.writer.toString(), (Object)"****NO OPTIONS PRESENT****");
        boolean checkResult = result.contains("CREATE TABLE " + tableName);
        checkResult = result.contains("INSERT INTO " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)true);
    }

    private void createNonZeroScaleNumericGrid(int noOfRows, int noOfColumns) {
        this.createColumnsWithScaleEqualsTwo(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)Double.valueOf(this.generateRandomNumericValues()), null));
            }
            this.project.rows.add(row);
        }
    }

    protected void createColumnsWithScaleEqualsTwo(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    @Test
    public void testExportSimpleSql() {
        this.createGrid(2, 2);
        String tableName = "sql_table_test";
        String optionsString = this.createOptionsFromProject(tableName, null, null).toString();
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsString);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertNotEquals((Object)this.writer.toString(), (Object)"****NO OPTIONS PRESENT****");
        Assert.assertTrue((boolean)result.contains("INSERT INTO " + tableName));
    }

    @Test
    public void testExportSqlNoSchema() {
        this.createGrid(2, 2);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = (ObjectNode)this.createOptionsFromProject(tableName, null, null);
        optionsJson.put("includeStructure", false);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertNotEquals((Object)this.writer.toString(), (Object)"****NO OPTIONS PRESENT****");
        boolean checkResult = result.contains("CREATE TABLE " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)false);
        checkResult = result.contains("INSERT INTO " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)true);
    }

    @Test
    public void testExportSqlNoContent() {
        this.createGrid(2, 2);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = (ObjectNode)this.createOptionsFromProject(tableName, null, null);
        optionsJson.put("includeContent", false);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertNotEquals((Object)this.writer.toString(), (Object)"****NO OPTIONS PRESENT****");
        boolean checkResult = result.contains("CREATE TABLE " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)true);
        checkResult = result.contains("INSERT INTO " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)false);
    }

    @Test
    public void testExportSqlIncludeSchemaWithDropStmt() {
        this.createGrid(2, 2);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = (ObjectNode)this.createOptionsFromProject(tableName, null, null);
        optionsJson.put("includeStructure", true);
        optionsJson.put("includeDropStatement", true);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        Assert.assertNotNull((Object)result);
        boolean checkResult = result.contains("CREATE TABLE " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)true);
        checkResult = result.contains("INSERT INTO " + tableName);
        Assert.assertEquals((boolean)checkResult, (boolean)true);
        checkResult = result.contains("DROP TABLE IF EXISTS " + tableName + ";");
        Assert.assertEquals((boolean)checkResult, (boolean)true);
    }

    @Test
    public void testGetCreateSql() {
        this.createGrid(3, 3);
        String tableName = "sql_table_test";
        String type = "CHAR";
        String size = "2";
        JsonNode optionsJson = this.createOptionsFromProject(tableName, type, size);
        List columns = this.project.columnModel.columns.stream().map(col -> col.getName()).collect(Collectors.toList());
        this.sqlCreateBuilder = new SqlCreateBuilder(tableName, columns, optionsJson);
        String createSql = this.sqlCreateBuilder.getCreateSQL();
        Assert.assertNotNull((Object)createSql);
        boolean result = createSql.contains(type + "(" + size + ")");
        Assert.assertEquals((boolean)result, (boolean)true);
    }

    @Test
    public void testExportSqlWithSpecialCharacterInclusiveColumnNames() {
        int noOfCols = 4;
        int noOfRows = 1;
        this.createGridWithSpecialCharacters(noOfRows, noOfCols);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = this.createOptionsFromProject(tableName, null, null, null, false);
        optionsJson.put("includeStructure", true);
        optionsJson.put("includeDropStatement", true);
        optionsJson.put("convertNulltoEmptyString", true);
        optionsJson.put("trimColumnNames", true);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        this.logger.debug("\nresult:={} ", (Object)result);
        Assert.assertTrue((boolean)result.contains("INSERT INTO sql_table_test (_column_0_,_column_1_,_column_2_,_column_3_) VALUES \n( 'It''s row0cell0','It''s row0cell1','It''s row0cell2','It''s row0cell3' )"));
    }

    @Test
    public void testExportSqlWithNullFields() {
        int inNull = 8;
        this.createGridWithNullFields(3, 3, inNull);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = (ObjectNode)this.createOptionsFromProject(tableName, null, null);
        optionsJson.put("includeStructure", true);
        optionsJson.put("includeDropStatement", true);
        optionsJson.put("convertNulltoEmptyString", true);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        Assert.assertNotNull((Object)result);
        int countNull = this.countWordInString(result, "null");
        Assert.assertEquals((int)countNull, (int)inNull);
    }

    @Test
    public void testExportSqlWithNotNullColumns() {
        int noOfCols = 4;
        int noOfRows = 3;
        this.createGrid(noOfRows, noOfCols);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = this.createOptionsFromProject(tableName, null, null, null, false);
        optionsJson.put("includeStructure", true);
        optionsJson.put("includeDropStatement", true);
        optionsJson.put("convertNulltoEmptyString", true);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        this.logger.debug("\nresult:={} ", (Object)result);
        Assert.assertNotNull((Object)result);
        int countNull = this.countWordInString(result, "NOT NULL");
        this.logger.debug("\nNot Null Count: {}", (Object)countNull);
        Assert.assertEquals((int)countNull, (int)noOfCols);
    }

    @Test
    public void testExportSqlWithSingleQuote() {
        int noOfCols = 4;
        int noOfRows = 1;
        this.createGridWithSingleQuote(noOfRows, noOfCols);
        String tableName = "sql_table_test";
        ObjectNode optionsJson = this.createOptionsFromProject(tableName, null, null, null, false);
        optionsJson.put("includeStructure", true);
        optionsJson.put("includeDropStatement", true);
        optionsJson.put("convertNulltoEmptyString", true);
        Mockito.when((Object)this.options.getProperty("options")).thenReturn((Object)optionsJson.toString());
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String result = this.writer.toString();
        this.logger.debug("\nresult:={} ", (Object)result);
        Assert.assertTrue((boolean)result.contains("INSERT INTO sql_table_test (column0,column1,column2,column3) VALUES \n( 'It''s row0cell0','It''s row0cell1','It''s row0cell2','It''s row0cell3' )"));
    }

    public int countWordInString(String input, String word) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        int i = 0;
        Pattern p = Pattern.compile(word);
        Matcher m = p.matcher(input);
        while (m.find()) {
            ++i;
        }
        return i;
    }

    protected void createColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void createColumnsWithSpecialCharacters(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "@column " + i + "/"), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void createGrid(int noOfRows, int noOfColumns) {
        this.createColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    protected void createGridWithSingleQuote(int noOfRows, int noOfColumns) {
        this.createColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("It's row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    protected void createGridWithSpecialCharacters(int noOfRows, int noOfColumns) {
        this.createColumnsWithSpecialCharacters(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("It's row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    protected void createGridWithNullFields(int noOfRows, int noOfColumns, int noOfNullFields) {
        this.createColumns(noOfColumns);
        if (noOfNullFields > noOfColumns * noOfRows) {
            noOfNullFields = noOfColumns * noOfRows;
        }
        int k = 0;
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                if (k < noOfNullFields) {
                    row.cells.add(new Cell((Serializable)((Object)""), null));
                    ++k;
                    continue;
                }
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    protected ObjectNode createNumericColOptionsFromProject(String tableName, String type, String size) {
        ObjectNode json = ParsingUtilities.mapper.createObjectNode();
        ArrayNode columns = json.putArray("columns");
        json.put("tableName", tableName);
        List cols = this.project.columnModel.columns;
        cols.forEach(c -> {
            ObjectNode columnModel = ParsingUtilities.mapper.createObjectNode();
            columnModel.put("name", c.getName());
            if (type != null) {
                columnModel.put("type", type);
            } else {
                columnModel.put("type", "VARCHAR");
            }
            if (size != null) {
                columnModel.put("size", size);
            } else {
                columnModel.put("size", "100");
            }
            if (type != null) {
                columnModel.put("type", type);
            }
            if (size != null) {
                columnModel.put("size", size);
            }
            columns.add((JsonNode)columnModel);
        });
        return json;
    }

    protected JsonNode createOptionsFromProject(String tableName, String type, String size) {
        ObjectNode json = ParsingUtilities.mapper.createObjectNode();
        json.put("tableName", tableName);
        ArrayNode columns = json.putArray("columns");
        List cols = this.project.columnModel.columns;
        cols.forEach(c -> {
            ObjectNode columnModel = ParsingUtilities.mapper.createObjectNode();
            columnModel.put("name", c.getName());
            if (type != null) {
                columnModel.put("type", type);
            } else {
                columnModel.put("type", "VARCHAR");
            }
            if (size != null) {
                columnModel.put("size", size);
            } else {
                columnModel.put("size", "100");
            }
            if (type != null) {
                columnModel.put("type", type);
            }
            if (size != null) {
                columnModel.put("size", size);
            }
            columns.add((JsonNode)columnModel);
        });
        return json;
    }

    protected ObjectNode createOptionsFromProject(String tableName, String type, String size, String defaultValue, boolean allowNull) {
        ObjectNode json = ParsingUtilities.mapper.createObjectNode();
        ArrayNode columns = json.putArray("columns");
        json.put("tableName", tableName);
        List cols = this.project.columnModel.columns;
        cols.forEach(c -> {
            ObjectNode columnModel = ParsingUtilities.mapper.createObjectNode();
            columnModel.put("name", c.getName());
            if (type != null) {
                columnModel.put("type", type);
            } else {
                columnModel.put("type", "VARCHAR");
            }
            if (size != null) {
                columnModel.put("size", size);
            } else {
                columnModel.put("size", "100");
            }
            if (type != null) {
                columnModel.put("type", type);
            }
            if (size != null) {
                columnModel.put("size", size);
            }
            columnModel.put("defaultValue", defaultValue);
            columnModel.put("allowNull", allowNull);
            columns.add((JsonNode)columnModel);
        });
        return json;
    }

    double generateRandomNumericValues() {
        int precision = 100;
        double randomnum = Math.floor(Math.random() * (double)(10 * precision - 1 * precision) + (double)(1 * precision)) / (double)(1 * precision);
        return randomnum;
    }
}

