/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.HasFieldsListImpl;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.WrappedRow;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CrossTests
extends RefineTest {
    private static OffsetDateTime dateTimeValue = OffsetDateTime.parse("2017-05-12T05:45:00+00:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    Project projectGift;
    Project projectAddress;
    Project projectDuplicate1;
    Project projectDuplicate2;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        bindings = new Properties();
        String projectName = "My Address Book";
        String input = "friend,address\njohn,120 Main St.\nmary,50 Broadway Ave.\njohn,999 XXXXXX St.\nanne,17 Morning Crescent\n2017-05-12T05:45:00Z,dateTime\n1600,integer\n123456789123456789,long\ntrue,boolean\n3.14,double\n";
        this.projectAddress = this.createCSVProject(projectName, input);
        projectName = "Christmas Gifts";
        input = "gift,recipient\nlamp,mary\nclock,john\ndateTime,2017-05-12T05:45:00Z\ninteger,1600\n123456789123456789,long\nboolean,true\n";
        this.projectGift = this.createCSVProject(projectName, input);
        projectName = "Duplicate";
        input = "Col1,Col2";
        this.projectDuplicate1 = this.createCSVProject(projectName, input);
        this.projectDuplicate2 = this.createCSVProject(projectName, input);
        bindings.put("project", this.projectGift);
        ((Row)this.projectAddress.rows.get((int)4)).cells.set(0, new Cell((Serializable)dateTimeValue, null));
        ((Row)this.projectAddress.rows.get((int)5)).cells.set(0, new Cell((Serializable)Integer.valueOf(1600), null));
        ((Row)this.projectAddress.rows.get((int)6)).cells.set(0, new Cell((Serializable)Long.valueOf(123456789123456789L), null));
        ((Row)this.projectAddress.rows.get((int)7)).cells.set(0, new Cell((Serializable)Boolean.valueOf(true), null));
        ((Row)this.projectAddress.rows.get((int)8)).cells.set(0, new Cell((Serializable)Double.valueOf(3.14), null));
        ((Row)this.projectGift.rows.get((int)2)).cells.set(1, new Cell((Serializable)dateTimeValue, null));
        ((Row)this.projectGift.rows.get((int)3)).cells.set(1, new Cell((Serializable)Integer.valueOf(1600), null));
        ((Row)this.projectGift.rows.get((int)4)).cells.set(1, new Cell((Serializable)Long.valueOf(123456789123456789L), null));
        ((Row)this.projectGift.rows.get((int)5)).cells.set(1, new Cell((Serializable)Boolean.valueOf(true), null));
        bindings.put("columnName", "recipient");
    }

    @Test
    public void crossFunctionMissingProject() throws Exception {
        String nonExistentProject = "NOPROJECT";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"Anne", nonExistentProject, "friend"})).message, (String)("Unable to find project with name: " + nonExistentProject));
    }

    @Test
    public void crossFunctionMultipleProjects() throws Exception {
        String duplicateProjectName = "Duplicate";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"Anne", duplicateProjectName, "friend"})).message, (String)("2 projects found with name: " + duplicateProjectName));
    }

    @Test
    public void crossFunctionMissingColumn() throws Exception {
        String nonExistentColumn = "NoColumn";
        String projectName = "My Address Book";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"mary", projectName, nonExistentColumn})).message, (String)("Unable to find column " + nonExistentColumn + " in project " + projectName));
    }

    @Test
    public void crossFunctionSameColumnTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)0)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionDifferentColumnTest() throws Exception {
        Project project = (Project)bindings.get("project");
        bindings.put("columnName", "gift");
        Cell c = (Cell)((Row)project.rows.get((int)0)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionOneArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0)})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionOneArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionOneArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)1), "", ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"john");
    }

    @Test
    public void crossFunctionTwoArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"lamp", "", "gift"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionTwoArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), "My Address Book"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"120 Main St.");
    }

    @Test
    public void crossFunctionTwoArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), "My Address Book", ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"120 Main St.");
    }

    @Test
    public void crossFunctionOneToOneTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"mary", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionOneToManyTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"john", "My Address Book", "friend"})).get((int)1)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"999 XXXXXX St.");
    }

    @Test
    public void crossFunctionCaseSensitiveTest() throws Exception {
        Assert.assertNull((Object)CrossTests.invoke("cross", "Anne", "My Address Book", "friend"));
    }

    @Test
    public void crossFunctionDateTimeTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)2)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionIntegerTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)3)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionBooleanTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)5)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionIntegerArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)1600), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Long.valueOf((long)1600L), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"1600", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest3() throws Exception {
        Assert.assertNull((Object)CrossTests.invoke("cross", "1600.0", "My Address Book", "friend"));
    }

    @Test
    public void crossFunctionLongArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Long.valueOf((long)123456789123456789L), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"long");
    }

    @Test
    public void crossFunctionLongArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"123456789123456789", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"long");
    }

    @Test
    public void crossFunctionDoubleArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Double.valueOf((double)3.14), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDoubleArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Float.valueOf((float)3.14f), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDoubleArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"3.14", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDateTimeArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{CrossTests.dateTimeValue, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionDateTimeArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{CrossTests.dateTimeValue.toString(), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionBooleanArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Boolean.valueOf((boolean)true), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionBooleanArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"true", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionMatchNotFoundTest() throws Exception {
        Assert.assertNull((Object)CrossTests.invoke("cross", "NON-EXIST", "My Address Book", "friend"));
    }

    @Test
    public void crossFunctionNonLiteralValue() throws Exception {
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{null, "My Address Book", "friend"})).message, (String)"cross expects a cell or value, a project name to look up (optional), and a column name in that project (optional)");
    }
}

