/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.TimeSinceUnixEpochToDate;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimeSinceUnixEpochToDateTest
extends RefineTest {
    long epoch = 1650547184707L;
    static Properties bindings = new Properties();

    @Test
    public void testTimeSinceUnixEpochToDateOneParam() {
        long epoch1 = this.epoch / 1000L;
        TimeSinceUnixEpochToDate etd = new TimeSinceUnixEpochToDate();
        Assert.assertEquals((String)etd.call(bindings, new Object[]{epoch1}).toString(), (String)"2022-04-21T13:19:44Z");
    }

    @Test
    public void testTimeSinceUnixEpochToDateTwoParam() {
        long epochSecond = this.epoch / 1000L;
        long epochMilliSecond = this.epoch;
        long epochMicroSecond = this.epoch * 1000L;
        TimeSinceUnixEpochToDate etd = new TimeSinceUnixEpochToDate();
        Assert.assertEquals((String)etd.call(bindings, new Object[]{epochSecond, "second"}).toString(), (String)"2022-04-21T13:19:44Z");
        Assert.assertEquals((String)etd.call(bindings, new Object[]{epochMilliSecond, "millisecond"}).toString(), (String)"2022-04-21T13:19:44Z");
        Assert.assertEquals((String)etd.call(bindings, new Object[]{epochMicroSecond, "microsecond"}).toString(), (String)"2022-04-21T13:19:44Z");
    }

    @Test
    public void testDescriptionParamsReturns() {
        long epochMilliSecond = this.epoch;
        TimeSinceUnixEpochToDate etd = new TimeSinceUnixEpochToDate();
        Assert.assertEquals((String)etd.getDescription(), (String)"Returns a number converted to a date based on Unix Epoch Time. The number can be Unix Epoch Time in one of the following supported units: second, millisecond, microsecond. Defaults to 'second'.");
        Assert.assertEquals((String)etd.getParams(), (String)"number n, string unit (optional, defaults to 'seconds')");
        Assert.assertEquals((String)etd.getReturns(), (String)"date(OffsetDateTime)");
        Assert.assertTrue((boolean)(etd.call(bindings, new Object[]{"millisecond", epochMilliSecond}) instanceof EvalError));
    }

    @Test
    public void testTimeSinceUnixEpochToDateEvalError() {
        long epochMilliSecond = this.epoch;
        TimeSinceUnixEpochToDate etd = new TimeSinceUnixEpochToDate();
        Assert.assertTrue((boolean)(etd.call(bindings, new Object[]{"millisecond", epochMilliSecond}) instanceof EvalError));
    }
}

