/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.util.CalendarParser;
import com.google.refine.expr.util.CalendarParserException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ToStringTests
extends RefineTest {
    @Test
    public void testToString() throws CalendarParserException {
        Assert.assertTrue((boolean)(ToStringTests.invoke("toString", new Object[0]) instanceof EvalError));
        Assert.assertEquals((Object)ToStringTests.invoke("toString", new Object[]{null}), (Object)"");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", 100L), (Object)"100");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", 100.0), (Object)"100.0");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", 100.0, "%.0f"), (Object)"100");
        String inputDate = "2013-06-01";
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDate)), (Object)"2013-06-01T00:00:00Z");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDate), "yyyy-MM-dd"), (Object)"2013-06-01");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDate), "yyyy/dd/MM"), (Object)"2013/01/06");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDate), "yyyy-MM-dd hh:mm:ss"), (Object)"2013-06-01 12:00:00");
        String inputDateTime = "2013-06-01 13:12:11";
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDateTime)), (Object)"2013-06-01T13:12:11Z");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDateTime), "yyyy-MM-dd"), (Object)"2013-06-01");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDateTime), "yyyy-MM-dd hh:mm:ss"), (Object)"2013-06-01 01:12:11");
        Assert.assertEquals((Object)ToStringTests.invoke("toString", CalendarParser.parseAsOffsetDateTime((String)inputDateTime), "yyyy-MM-dd HH:mm:ss"), (Object)"2013-06-01 13:12:11");
    }
}

