/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InArrayTests
extends RefineTest {
    static Properties bindings;
    static final List<String> listArray;
    static final String[] stringArray;

    @Test
    public void testInArrayParameters() {
        Assert.assertTrue((boolean)(InArrayTests.invoke("inArray", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(InArrayTests.invoke("inArray", "string1") instanceof EvalError));
        Assert.assertTrue((boolean)(InArrayTests.invoke("inArray", "string1", "string2") instanceof EvalError));
        Assert.assertTrue((boolean)(InArrayTests.invoke("inArray", "string1", "string2", "string3") instanceof EvalError));
    }

    @Test
    public void testInArray() {
        Assert.assertTrue((boolean)((Boolean)InArrayTests.invoke("inArray", listArray, "v1")));
        Assert.assertFalse((boolean)((Boolean)InArrayTests.invoke("inArray", listArray, "v4")));
        Assert.assertTrue((boolean)((Boolean)InArrayTests.invoke("inArray", stringArray, "v1")));
        Assert.assertFalse((boolean)((Boolean)InArrayTests.invoke("inArray", stringArray, "v4")));
    }

    @Test
    public void testInArrayWithArrayNode() {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (int i = 1; i < 4; ++i) {
            arrayNode.add("v" + i);
        }
        Assert.assertTrue((boolean)((Boolean)InArrayTests.invoke("inArray", arrayNode, "v1")));
        Assert.assertFalse((boolean)((Boolean)InArrayTests.invoke("inArray", arrayNode, "v4")));
    }

    static {
        listArray = Arrays.asList("v1", "v2", "v3");
        stringArray = new String[]{"v1", "v2", "v3"};
    }
}

