/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.ParsingException;
import org.testng.annotations.Test;

public class SortTests
extends RefineTest {
    @Test
    public void sortJsonArray() throws ParsingException {
        String[] test = new String[]{"'[2,1,3]'.parseJson().sort().toString()", "[1, 2, 3]"};
        this.parseEval(bindings, test);
        String[] test1 = new String[]{"'[2,null,3]'.parseJson().sort().toString()", "[2, 3, null]"};
        this.parseEval(bindings, test1);
    }

    @Test
    public void sortArray() throws ParsingException {
        String[] test = new String[]{"[2,1,3].sort().toString()", "[1, 2, 3]"};
        this.parseEval(bindings, test);
        String[] test1 = new String[]{"[2,null,3].sort().toString()", "[2, 3, null]"};
        this.parseEval(bindings, test1);
        String[] test2 = new String[]{"['z','b','c','a'].sort().toString()", "[a, b, c, z]"};
        this.parseEval(bindings, test2);
        String[] test3 = new String[]{"['z',null,'c','a'].sort().toString()", "[a, c, z, null]"};
        this.parseEval(bindings, test3);
        String[] test4 = new String[]{"[toDate(2020), '2018-03-02'.toDate()].sort().toString()", "[2018-03-02T00:00Z, 2020-01-01T00:00Z]"};
        this.parseEval(bindings, test4);
    }

    @Test
    public void sortMixedArray() throws ParsingException {
        String test = "[2,1.0,3].sort().toString()";
        this.parseEvalType(bindings, test, EvalError.class);
        test = "[2,'a',3].sort().toString()";
        this.parseEvalType(bindings, test, EvalError.class);
        test = "'[2,\"a\",3]'.parseJson().sort().toString()";
        this.parseEvalType(bindings, test, EvalError.class);
    }
}

